/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.target;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.NonPlaceholderDragTarget;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.MultiComponentTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.scene.target.TargetSnapper;
import com.google.common.collect.ImmutableList;
import java.awt.Cursor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DragBaseTarget
extends BaseTarget
implements MultiComponentTarget,
NonPlaceholderDragTarget {
    private static final boolean DEBUG_RENDERER = false;
    protected int myOffsetX;
    protected int myOffsetY;
    protected int myFirstMouseX;
    protected int myFirstMouseY;
    protected boolean myChangedComponent;
    @NotNull
    private final TargetSnapper myTargetSnapper;

    private DragBaseTarget(@NotNull TargetSnapper targetSnapper) {
        this.myTargetSnapper = targetSnapper;
    }

    public DragBaseTarget() {
        this(new TargetSnapper());
    }

    @Override
    @Nullable
    public List<SceneComponent> newSelection() {
        if (this.hasChangedComponent()) {
            List<NlComponent> selection = this.getComponent().getScene().getSelection();
            if (selection.size() == 1) {
                return ImmutableList.of((Object)this.getComponent());
            }
            Scene scene = this.myComponent.getScene();
            return (List)selection.stream().map(c -> scene.getSceneComponent((NlComponent)c)).collect(ImmutableList.toImmutableList());
        }
        return null;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        int d;
        int minWidth = 16;
        int minHeight = 16;
        if (r - l < minWidth) {
            d = (minWidth - (r - l)) / 2;
            l -= d;
            r += d;
        }
        if (b - t < minHeight) {
            d = (minHeight - (b - t)) / 2;
            t -= d;
            b += d;
        }
        this.myLeft = l;
        this.myTop = t;
        this.myRight = r;
        this.myBottom = b;
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        this.myTargetSnapper.renderSnappedNotches(list, sceneContext, this.myComponent);
    }

    protected abstract void updateAttributes(@NotNull NlAttributesHolder var1, int var2, int var3);

    @Override
    protected boolean isHittable() {
        if (this.myComponent.isSelected()) {
            return this.myComponent.canShowBaseline() || !this.myComponent.isDragging();
        }
        return true;
    }

    @Override
    public int getPreferenceLevel() {
        return 20;
    }

    @Override
    public void mouseDown(int x, int y) {
        if (this.myComponent.getParent() == null) {
            return;
        }
        this.myFirstMouseX = x;
        this.myFirstMouseY = y;
        this.myOffsetX = x - this.myComponent.getDrawX(System.currentTimeMillis());
        this.myOffsetY = y - this.myComponent.getDrawY(System.currentTimeMillis());
        this.myChangedComponent = false;
        this.getTargetNotchSnapper().reset();
        this.getTargetNotchSnapper().gatherNotches(this.myComponent);
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets) {
        if (this.myComponent.getParent() == null) {
            return;
        }
        this.myComponent.setDragging(true);
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        int snappedX = this.myTargetSnapper.trySnapHorizontal(x -= this.myOffsetX).orElse(x);
        int snappedY = this.myTargetSnapper.trySnapVertical(y -= this.myOffsetY).orElse(y);
        ComponentModification modification = new ComponentModification(component, "Drag");
        this.updateAttributes(modification, snappedX, snappedY);
        modification.apply();
        component.fireLiveChangeEvent();
        this.myComponent.getScene().needsLayout(1);
        this.myChangedComponent = true;
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        if (!this.myComponent.isDragging()) {
            return;
        }
        this.myComponent.setDragging(false);
        if (this.myComponent.getParent() != null) {
            boolean commitChanges = true;
            if (Math.abs(x - this.myFirstMouseX) <= 1 && Math.abs(y - this.myFirstMouseY) <= 1) {
                commitChanges = false;
            }
            NlComponent component = this.myComponent.getAuthoritativeNlComponent();
            ComponentModification modification = new ComponentModification(component, "Drag");
            int snappedX = this.myTargetSnapper.trySnapHorizontal(x -= this.myOffsetX).orElse(x);
            int snappedY = this.myTargetSnapper.trySnapVertical(y -= this.myOffsetY).orElse(y);
            if (this.isAutoConnectionEnabled()) {
                this.myTargetSnapper.applyNotches(modification);
            }
            this.updateAttributes(modification, snappedX, snappedY);
            modification.apply();
            if (commitChanges) {
                modification.commit();
            }
        }
        if (this.myChangedComponent) {
            this.myComponent.getScene().needsLayout(1);
        }
    }

    protected boolean isAutoConnectionEnabled() {
        return true;
    }

    @Override
    public void mouseCancel() {
        int originalX = this.myFirstMouseX - this.myOffsetX;
        int originalY = this.myFirstMouseY - this.myOffsetY;
        this.myComponent.setPosition(originalX, originalY);
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        AttributesTransaction transaction = component.startAttributeTransaction();
        transaction.rollback();
        component.fireLiveChangeEvent();
        this.myComponent.setDragging(false);
        this.myTargetSnapper.reset();
        this.myChangedComponent = false;
        this.myComponent.getScene().needsLayout(1);
    }

    @Override
    public Cursor getMouseCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    @NotNull
    public TargetSnapper getTargetNotchSnapper() {
        return this.myTargetSnapper;
    }

    private boolean hasChangedComponent() {
        return this.myChangedComponent;
    }
}

