/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.adtui.Zoomable;
import com.android.tools.adtui.ZoomableKt;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.common.editor.ActionManager;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.error.IssuePanel;
import com.android.tools.idea.common.error.LintIssueProvider;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurfaceActionHandler;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionManager;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.PanZoomListener;
import com.android.tools.idea.common.surface.SceneLayer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.type.DefaultDesignerFileType;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.uibuilder.analytics.NlUsageTracker;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.utils.ImmutableCollectors;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.Alarm;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.plaf.ScrollBarUI;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DesignSurface
extends EditorDesignSurface
implements Disposable,
DataProvider,
Zoomable {
    private static final Integer LAYER_PROGRESS = JLayeredPane.POPUP_LAYER + 100;
    private final Project myProject;
    protected double myScale = 1.0;
    @NotNull
    protected final JScrollPane myScrollPane;
    private final MyLayeredPane myLayeredPane;
    @VisibleForTesting
    @NotNull
    public ImmutableList<Layer> myLayers = ImmutableList.of();
    private final InteractionManager myInteractionManager;
    private final GlassPane myGlassPane;
    protected final List<DesignSurfaceListener> myListeners = new ArrayList<DesignSurfaceListener>();
    private List<PanZoomListener> myZoomListeners;
    private final ActionManager myActionManager;
    @NotNull
    private WeakReference<FileEditor> myFileEditorDelegate = new WeakReference<Object>(null);
    protected final LinkedHashMap<NlModel, SceneManager> myModelToSceneManagers = new LinkedHashMap();
    private final SelectionModel mySelectionModel;
    private final ModelListener myModelListener = new ModelListener(){

        @Override
        public void modelChangedOnLayout(@NotNull NlModel model2, boolean animate) {
            DesignSurface.this.repaint();
        }
    };
    protected final IssueModel myIssueModel = new IssueModel();
    private final IssuePanel myIssuePanel;
    private final Object myErrorQueueLock = new Object();
    private MergingUpdateQueue myErrorQueue;
    private boolean myIsActive = false;
    private LintIssueProvider myLintIssueProvider;
    private boolean mySkipResizeContent;
    private boolean mySkipResizeContentOnce;
    private final ConfigurationListener myConfigurationListener = flags -> {
        if ((flags & 6) != 0 && !this.isLayoutDisabled()) {
            this.zoom(ZoomType.FIT_INTO, -1, -1);
        }
        return true;
    };
    private ZoomType myCurrentZoomType;
    private Timer myRepaintTimer = new Timer(15, actionEvent -> this.repaint());
    private final SelectionListener mySelectionListener = (model2, selection) -> {
        if (this.getCurrentSceneView() != null) {
            this.notifySelectionListeners(selection);
        } else {
            this.notifySelectionListeners(Collections.emptyList());
        }
    };
    private final List<ProgressIndicator> myProgressIndicators = new ArrayList<ProgressIndicator>();
    private final MyProgressPanel myProgressPanel;

    public DesignSurface(@NotNull Project project, @NotNull SelectionModel selectionModel, @NotNull Disposable parentDisposable) {
        super(new BorderLayout());
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.setOpaque(true);
        this.setFocusable(false);
        this.mySelectionModel = selectionModel;
        this.mySelectionModel.addListener(this.mySelectionListener);
        this.myInteractionManager = new InteractionManager(this);
        this.myLayeredPane = new MyLayeredPane();
        this.myLayeredPane.setBounds(0, 0, 100, 100);
        this.myGlassPane = new GlassPane();
        this.myLayeredPane.add((Component)this.myGlassPane, JLayeredPane.DRAG_LAYER);
        this.myProgressPanel = new MyProgressPanel();
        this.myProgressPanel.setName("Layout Editor Progress Panel");
        this.myLayeredPane.add((Component)this.myProgressPanel, LAYER_PROGRESS);
        this.myScrollPane = new MyScrollPane();
        this.myScrollPane.setViewportView(this.myLayeredPane);
        this.myScrollPane.setBorder(null);
        this.myScrollPane.setVerticalScrollBarPolicy(22);
        this.myScrollPane.setHorizontalScrollBarPolicy(32);
        this.myScrollPane.getHorizontalScrollBar().addAdjustmentListener(this::notifyPanningChanged);
        this.myScrollPane.getVerticalScrollBar().addAdjustmentListener(this::notifyPanningChanged);
        this.myScrollPane.getViewport().setBackground(this.getBackground());
        this.myIssuePanel = new IssuePanel(this, this.myIssueModel);
        Disposer.register((Disposable)this, (Disposable)this.myIssuePanel);
        this.add(this.myScrollPane);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                boolean scaled = false;
                if (DesignSurface.this.isShowing() && DesignSurface.this.getWidth() > 0 && DesignSurface.this.getHeight() > 0 && (!DesignSurface.this.contentResizeSkipped() || DesignSurface.this.getFitScale(false) > DesignSurface.this.myScale)) {
                    scaled = DesignSurface.this.zoomToFit();
                }
                if (!scaled) {
                    DesignSurface.this.layoutContent();
                    DesignSurface.this.updateScrolledAreaSize();
                }
            }
        });
        this.myInteractionManager.startListening();
        this.myActionManager = this.createActionManager();
        this.myActionManager.registerActionsShortcuts(this.myLayeredPane, this);
    }

    public abstract float getSceneScalingFactor();

    public float getScreenScalingFactor() {
        return 1.0f;
    }

    @NotNull
    protected abstract ActionManager<? extends DesignSurface> createActionManager();

    @NotNull
    protected abstract SceneManager createSceneManager(@NotNull NlModel var1);

    protected abstract void layoutContent();

    public JPanel getAccessoryPanel() {
        return null;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public DesignerEditorFileType getLayoutType() {
        NlModel model2 = this.getModel();
        return model2 == null ? DefaultDesignerFileType.INSTANCE : model2.getType();
    }

    @NotNull
    public ActionManager getActionManager() {
        return this.myActionManager;
    }

    public SelectionModel getSelectionModel() {
        return this.mySelectionModel;
    }

    @NotNull
    public ItemTransferable getSelectionAsTransferable() {
        NlModel model2 = this.getModel();
        ImmutableList components = (ImmutableList)this.getSelectionModel().getSelection().stream().map(component -> {
            int w = 0;
            int h = 0;
            if (this instanceof NlDesignSurface) {
                w = NlComponentHelperKt.getW(component);
                h = NlComponentHelperKt.getW(component);
            }
            return new DnDTransferComponent(component.getTagName(), component.getTagDeprecated().getText(), w, h);
        }).collect(ImmutableCollectors.toImmutableList());
        return new ItemTransferable(new DnDTransferItem(model2 != null ? model2.getId() : 0L, (ImmutableList<DnDTransferComponent>)components));
    }

    @Nullable
    public NlModel getModel() {
        return (NlModel)Iterables.getFirst(this.myModelToSceneManagers.keySet(), null);
    }

    @NotNull
    public ImmutableList<NlModel> getModels() {
        return ImmutableList.copyOf(this.myModelToSceneManagers.keySet());
    }

    @NotNull
    private SceneManager addModelImpl(@NotNull NlModel model2) {
        SceneManager manager = this.myModelToSceneManagers.get(model2);
        if (manager != null) {
            return manager;
        }
        model2.addListener(this.myModelListener);
        model2.getConfiguration().addListener(this.myConfigurationListener);
        manager = this.createSceneManager(model2);
        this.myModelToSceneManagers.put(model2, manager);
        return manager;
    }

    public void addModel(@NotNull NlModel model2) {
        this.addModelImpl(model2);
        this.requestRender().whenCompleteAsync((result2, ex) -> {
            this.reactivateInteractionManager();
            this.zoomToFit();
            for (DesignSurfaceListener listener2 : ImmutableList.copyOf(this.myListeners)) {
                listener2.modelChanged(this, model2);
            }
        }, (Executor)EdtExecutor.INSTANCE);
    }

    private boolean removeModelImpl(@NotNull NlModel model2) {
        SceneManager manager = (SceneManager)this.myModelToSceneManagers.remove(model2);
        if (manager == null) {
            return false;
        }
        model2.deactivate((Object)this);
        model2.getConfiguration().removeListener(this.myConfigurationListener);
        model2.removeListener(this.myModelListener);
        this.removeLayers(manager.getLayers());
        Disposer.dispose((Disposable)manager);
        return true;
    }

    public void removeModel(@NotNull NlModel model2) {
        if (!this.removeModelImpl(model2)) {
            return;
        }
        this.reactivateInteractionManager();
        this.zoomToFit();
        this.requestRender();
    }

    public CompletableFuture<Void> setModel(@Nullable NlModel model2) {
        NlModel oldModel = this.getModel();
        if (model2 == oldModel) {
            return CompletableFuture.completedFuture(null);
        }
        if (oldModel != null) {
            this.removeModelImpl(oldModel);
        }
        assert (this.myModelToSceneManagers.isEmpty());
        if (model2 == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.addModelImpl(model2);
        CompletionStage future2 = this.requestRender().whenCompleteAsync((result2, ex) -> {
            this.reactivateInteractionManager();
            this.zoomToFit();
            for (DesignSurfaceListener listener2 : ImmutableList.copyOf(this.myListeners)) {
                listener2.modelChanged(this, model2);
            }
        }, (Executor)EdtExecutor.INSTANCE);
        if (this.myIsActive) {
            model2.activate((Object)this);
        }
        return future2;
    }

    private void reactivateInteractionManager() {
        if (this.getLayoutType().isEditable()) {
            this.myInteractionManager.startListening();
        } else {
            this.myInteractionManager.stopListening();
        }
    }

    public void dispose() {
        this.myInteractionManager.stopListening();
        for (NlModel model2 : this.myModelToSceneManagers.keySet()) {
            model2.getConfiguration().removeListener(this.myConfigurationListener);
            model2.removeListener(this.myModelListener);
        }
    }

    @Nullable
    public abstract Dimension getScrolledAreaSize();

    public void updateScrolledAreaSize() {
        Dimension dimension2 = this.getScrolledAreaSize();
        if (dimension2 == null) {
            return;
        }
        this.myLayeredPane.setSize(dimension2.width, dimension2.height);
        this.myLayeredPane.setPreferredSize(dimension2);
        this.myScrollPane.revalidate();
        SceneView view = this.getCurrentSceneView();
        if (view != null) {
            this.myProgressPanel.setBounds(this.getContentOriginX(), this.getContentOriginY(), view.getSize().width, view.getSize().height);
        }
    }

    public abstract int getContentOriginX();

    public abstract int getContentOriginY();

    public JComponent getPreferredFocusedComponent() {
        return this.myGlassPane;
    }

    public void needsRepaint() {
        if (!this.myRepaintTimer.isRunning()) {
            this.myRepaintTimer.setRepeats(false);
            this.myRepaintTimer.start();
        }
    }

    @Nullable
    public SceneView getCurrentSceneView() {
        SceneManager sceneManager = this.getSceneManager();
        return sceneManager != null ? sceneManager.getSceneView() : null;
    }

    public void startDragDropInteraction() {
        for (Layer layer : this.myLayers) {
            SceneLayer sceneLayer;
            if (!(layer instanceof SceneLayer) || (sceneLayer = (SceneLayer)layer).isShowOnHover()) continue;
            sceneLayer.setShowOnHover(true);
            this.repaint();
        }
    }

    public void stopDragDropInteraction() {
        for (Layer layer : this.myLayers) {
            SceneLayer sceneLayer;
            if (!(layer instanceof SceneLayer) || !(sceneLayer = (SceneLayer)layer).isShowOnHover()) continue;
            sceneLayer.setShowOnHover(false);
            this.repaint();
        }
    }

    @NotNull
    public abstract Dimension getContentSize(@Nullable Dimension var1);

    public void hover(int x, int y) {
        for (Layer layer : this.myLayers) {
            layer.hover(x, y);
        }
    }

    public boolean zoom(@NotNull ZoomType type) {
        switch (type) {
            case ACTUAL: {
                NlUsageTracker.getInstance(this).logAction(LayoutEditorEvent.LayoutEditorEventType.ZOOM_ACTUAL);
                break;
            }
            case IN: {
                NlUsageTracker.getInstance(this).logAction(LayoutEditorEvent.LayoutEditorEventType.ZOOM_IN);
                break;
            }
            case OUT: {
                NlUsageTracker.getInstance(this).logAction(LayoutEditorEvent.LayoutEditorEventType.ZOOM_OUT);
                break;
            }
            case FIT_INTO: 
            case FIT: {
                NlUsageTracker.getInstance(this).logAction(LayoutEditorEvent.LayoutEditorEventType.ZOOM_FIT);
                break;
            }
        }
        return this.zoom(type, -1, -1);
    }

    public boolean zoom(@NotNull ZoomType type, int x, int y) {
        boolean scaled;
        SceneComponent component;
        Scene scene;
        SceneView view = this.getCurrentSceneView();
        if (!(type != ZoomType.IN || x >= 0 && y >= 0 || view == null || this.getSelectionModel().isEmpty() || (scene = this.getScene()) == null || (component = scene.getSceneComponent(this.getSelectionModel().getPrimary())) == null)) {
            x = Coordinates.getSwingXDip(view, component.getCenterX());
            y = Coordinates.getSwingYDip(view, component.getCenterY());
        }
        switch (type) {
            case IN: {
                double currentScale = this.myScale * (double)this.getScreenScalingFactor();
                int current = (int)Math.round(currentScale * 100.0);
                double scale = (double)ZoomType.zoomIn((int)current) / 100.0 / (double)this.getScreenScalingFactor();
                scaled = this.setScale(scale, x, y);
                break;
            }
            case OUT: {
                double currentScale = this.myScale * (double)this.getScreenScalingFactor();
                int current = (int)(currentScale * 100.0);
                double scale = (double)ZoomType.zoomOut((int)current) / 100.0 / (double)this.getScreenScalingFactor();
                scaled = this.setScale(scale, x, y);
                break;
            }
            case ACTUAL: {
                scaled = this.setScale(1.0 / (double)this.getScreenScalingFactor());
                this.myCurrentZoomType = type;
                break;
            }
            case FIT_INTO: 
            case FIT: {
                if (this.getCurrentSceneView() == null) {
                    return false;
                }
                scaled = this.setScale(this.getFitScale(type == ZoomType.FIT_INTO));
                this.myCurrentZoomType = type;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented: " + type);
            }
        }
        if (scaled) {
            this.repaint();
        }
        return scaled;
    }

    protected double getFitScale(boolean fitInto) {
        int availableWidth = this.myScrollPane.getWidth() - this.myScrollPane.getVerticalScrollBar().getWidth();
        int availableHeight = this.myScrollPane.getHeight() - this.myScrollPane.getHorizontalScrollBar().getHeight();
        return this.getFitScale(this.getPreferredContentSize(availableWidth, availableHeight), fitInto);
    }

    protected double getFitScale(Dimension size, boolean fitInto) {
        int availableWidth = this.myScrollPane.getWidth() - this.myScrollPane.getVerticalScrollBar().getWidth();
        int availableHeight = this.myScrollPane.getHeight() - this.myScrollPane.getHorizontalScrollBar().getHeight();
        Dimension padding = this.getDefaultOffset();
        double scaleX = size.width == 0 ? 1.0 : (double)(availableWidth -= padding.width) / (double)size.width;
        double scaleY = size.height == 0 ? 1.0 : (double)(availableHeight -= padding.height) / (double)size.height;
        double scale = Math.min(scaleX, scaleY);
        if (fitInto) {
            double min = 1.0 / (double)this.getScreenScalingFactor();
            scale = Math.min(min, scale);
        }
        return scale;
    }

    protected abstract Dimension getDefaultOffset();

    @NotNull
    protected abstract Dimension getPreferredContentSize(int var1, int var2);

    public boolean zoomToFit() {
        return this.zoom(ZoomType.FIT, -1, -1);
    }

    public double getScale() {
        return this.myScale;
    }

    public boolean canZoomIn() {
        return this.getScale() < this.getMaxScale();
    }

    public boolean canZoomOut() {
        return this.getScale() > this.getMinScale();
    }

    public boolean canZoomToFit() {
        return true;
    }

    public abstract void scrollToCenter(@NotNull List<NlComponent> var1);

    public void setScrollPosition(int x, int y) {
        this.setScrollPosition(new Point(x, y));
    }

    public void setScrollPosition(Point p) {
        Dimension extent = this.myScrollPane.getViewport().getExtentSize();
        Dimension view = this.myScrollPane.getViewport().getViewSize();
        p.setLocation(Math.max(0, Math.min(view.width - extent.width, p.x)), Math.max(0, Math.min(view.height - extent.height, p.y)));
        this.myScrollPane.getViewport().setViewPosition(p);
    }

    public Point getScrollPosition() {
        return this.myScrollPane.getViewport().getViewPosition();
    }

    private boolean setScale(double scale) {
        return this.setScale(scale, -1, -1);
    }

    @VisibleForTesting
    public boolean setScale(double scale, int x, int y) {
        double newScale = Math.min(Math.max(scale, this.getMinScale()), this.getMaxScale());
        if (Math.abs(newScale - this.myScale) < 0.005 / (double)this.getScreenScalingFactor()) {
            return false;
        }
        this.myCurrentZoomType = null;
        Point oldViewPosition = this.getScrollPosition();
        if (x < 0 || y < 0) {
            x = oldViewPosition.x + this.myScrollPane.getWidth() / 2;
            y = oldViewPosition.y + this.myScrollPane.getHeight() / 2;
        }
        SceneView view = this.getCurrentSceneView();
        int androidX = 0;
        int androidY = 0;
        if (view != null) {
            androidX = Coordinates.getAndroidXDip(view, x);
            androidY = Coordinates.getAndroidYDip(view, y);
        }
        this.myScale = newScale;
        this.layoutContent();
        this.updateScrolledAreaSize();
        if (view != null) {
            int shiftedX = Coordinates.getSwingXDip(view, androidX);
            int shiftedY = Coordinates.getSwingYDip(view, androidY);
            this.myScrollPane.getViewport().setViewPosition(new Point(oldViewPosition.x + shiftedX - x, oldViewPosition.y + shiftedY - y));
        }
        this.notifyScaleChanged();
        return true;
    }

    protected double getMinScale() {
        return 0.0;
    }

    protected double getMaxScale() {
        return 1.0;
    }

    private void notifyScaleChanged() {
        if (this.myZoomListeners != null) {
            for (PanZoomListener myZoomListener : this.myZoomListeners) {
                myZoomListener.zoomChanged(this);
            }
        }
    }

    private void notifyPanningChanged(AdjustmentEvent adjustmentEvent) {
        if (this.myZoomListeners != null) {
            for (PanZoomListener myZoomListener : this.myZoomListeners) {
                myZoomListener.panningChanged(adjustmentEvent);
            }
        }
    }

    @NotNull
    public JComponent getLayeredPane() {
        return this.myLayeredPane;
    }

    protected void notifySelectionListeners(@NotNull List<NlComponent> newSelection) {
        ArrayList listeners = Lists.newArrayList(this.myListeners);
        for (DesignSurfaceListener listener2 : listeners) {
            listener2.componentSelectionChanged(this, newSelection);
        }
    }

    public void notifyComponentActivate(@NotNull NlComponent component, int x, int y) {
        this.notifyComponentActivate(component);
    }

    public void notifyComponentActivate(@NotNull NlComponent component) {
        this.activatePreferredEditor(component);
    }

    @NotNull
    public abstract Consumer<NlComponent> getComponentRegistrar();

    protected void activatePreferredEditor(@NotNull NlComponent component) {
        for (DesignSurfaceListener listener2 : new ArrayList<DesignSurfaceListener>(this.myListeners)) {
            if (listener2.activatePreferredEditor(this, component)) break;
        }
    }

    public void addListener(@NotNull DesignSurfaceListener listener2) {
        this.myListeners.remove(listener2);
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull DesignSurfaceListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void addPanZoomListener(PanZoomListener listener2) {
        if (this.myZoomListeners == null) {
            this.myZoomListeners = Lists.newArrayList();
        } else {
            this.myZoomListeners.remove(listener2);
        }
        this.myZoomListeners.add(listener2);
    }

    public void removePanZoomListener(PanZoomListener listener2) {
        if (this.myZoomListeners != null) {
            this.myZoomListeners.remove(listener2);
        }
    }

    public void activate() {
        if (!this.myIsActive) {
            for (NlModel model2 : this.myModelToSceneManagers.keySet()) {
                model2.activate((Object)this);
            }
        }
        this.myIsActive = true;
    }

    public void deactivate() {
        if (this.myIsActive) {
            for (NlModel model2 : this.myModelToSceneManagers.keySet()) {
                model2.deactivate((Object)this);
            }
        }
        this.myIsActive = false;
        this.myInteractionManager.cancelInteraction();
    }

    public void setFileEditorDelegate(@Nullable FileEditor fileEditor) {
        this.myFileEditorDelegate = new WeakReference<FileEditor>(fileEditor);
    }

    @Nullable
    public SceneView getSceneView(int x, int y) {
        return this.getCurrentSceneView();
    }

    @NotNull
    public abstract Rectangle getRenderableBoundsOfSceneView(@NotNull SceneView var1, @Nullable Rectangle var2);

    @Nullable
    public SceneView getHoverSceneView(int x, int y) {
        return this.getCurrentSceneView();
    }

    @Nullable
    public Scene getScene() {
        SceneManager sceneManager = this.getSceneManager();
        return sceneManager != null ? sceneManager.getScene() : null;
    }

    @Nullable
    public SceneManager getSceneManager() {
        NlModel model2 = this.getModel();
        return model2 != null ? this.getSceneManager(model2) : null;
    }

    @Nullable
    public SceneManager getSceneManager(@NotNull NlModel model2) {
        return this.myModelToSceneManagers.get(model2);
    }

    public void setSkipResizeContent(boolean skipLayout) {
        this.mySkipResizeContent = skipLayout;
    }

    public void skipContentResizeOnce() {
        this.mySkipResizeContentOnce = true;
    }

    public boolean isSkipContentResize() {
        return this.mySkipResizeContent || this.mySkipResizeContentOnce || this.myCurrentZoomType != ZoomType.FIT;
    }

    protected boolean contentResizeSkipped() {
        boolean skip = this.isSkipContentResize();
        this.mySkipResizeContentOnce = false;
        return skip;
    }

    public CompletableFuture<?> goingToSetModel(NlModel model2) {
        return CompletableFuture.completedFuture(null);
    }

    @NotNull
    public InteractionManager getInteractionManager() {
        return this.myInteractionManager;
    }

    protected boolean getSupportPinchAndZoom() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIndicator(@NotNull ProgressIndicator indicator) {
        if (this.myProject.isDisposed() || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.add(indicator);
            this.myProgressPanel.showProgressIcon();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterIndicator(@NotNull ProgressIndicator indicator) {
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.remove(indicator);
            if (this.myProgressIndicators.isEmpty()) {
                this.myProgressPanel.hideProgressIcon();
            }
        }
    }

    protected boolean useSmallProgressIcon() {
        return true;
    }

    @NotNull
    public CompletableFuture<Void> requestRender() {
        if (this.myModelToSceneManagers.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.allOf((CompletableFuture[])this.myModelToSceneManagers.values().stream().map(manager -> manager.requestRender()).toArray(CompletableFuture[]::new));
    }

    @NotNull
    public JScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    public void setDesignToolTip(@Nullable String text) {
        this.myLayeredPane.setToolTipText(text);
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (ZoomableKt.ZOOMABLE_KEY.is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this.myFileEditorDelegate.get();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.createActionHandler();
        }
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId)) {
            SceneView view = this.getCurrentSceneView();
            NlComponent selection = this.getSelectionModel().getPrimary();
            Scene scene = this.getScene();
            if (view == null || scene == null || selection == null) {
                return null;
            }
            SceneComponent sceneComponent = scene.getSceneComponent(selection);
            if (sceneComponent == null) {
                return null;
            }
            return new Point(Coordinates.getSwingXDip(view, sceneComponent.getCenterX()), Coordinates.getSwingYDip(view, sceneComponent.getCenterY()));
        }
        return this.myLayeredPane.getData(dataId);
    }

    @NotNull
    protected abstract DesignSurfaceActionHandler createActionHandler();

    public abstract boolean isLayoutDisabled();

    @Override
    @Nullable
    public Configuration getConfiguration() {
        return this.getModel() != null ? this.getModel().getConfiguration() : null;
    }

    @NotNull
    public IssueModel getIssueModel() {
        return this.myIssueModel;
    }

    public void setLintAnnotationsModel(@NotNull LintAnnotationsModel model2) {
        if (this.myLintIssueProvider != null) {
            this.myLintIssueProvider.setLintAnnotationsModel(model2);
        } else {
            this.myLintIssueProvider = new LintIssueProvider(model2);
            this.getIssueModel().addIssueProvider(this.myLintIssueProvider);
        }
    }

    @NotNull
    public IssuePanel getIssuePanel() {
        return this.myIssuePanel;
    }

    public void setShowIssuePanel(boolean show) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myIssuePanel.setMinimized(!show);
            this.revalidate();
            this.repaint();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected MergingUpdateQueue getErrorQueue() {
        Object object = this.myErrorQueueLock;
        synchronized (object) {
            if (this.myErrorQueue == null) {
                this.myErrorQueue = new MergingUpdateQueue("android.error.computation", 200, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
            }
            return this.myErrorQueue;
        }
    }

    public void addLayers(@NotNull ImmutableList<Layer> layers) {
        this.myLayers = ImmutableList.copyOf((Iterable)Iterables.concat(this.myLayers, layers));
    }

    public void removeLayers(@NotNull ImmutableList<Layer> layers) {
        this.myLayers = ImmutableList.copyOf((Iterable)Iterables.filter(this.myLayers, l -> !layers.contains(l)));
    }

    @NotNull
    protected List<Layer> getLayers() {
        return this.myLayers;
    }

    @Nullable
    public final Interaction createInteractionOnClick(int mouseX, int mouseY) {
        SceneView sceneView = this.getSceneView(mouseX, mouseY);
        if (sceneView == null) {
            return null;
        }
        return this.doCreateInteractionOnClick(mouseX, mouseY, sceneView);
    }

    @VisibleForTesting
    @Nullable
    public abstract Interaction doCreateInteractionOnClick(int var1, int var2, @NotNull SceneView var3);

    @Nullable
    public abstract Interaction createInteractionOnDrag(@NotNull SceneComponent var1, @Nullable SceneComponent var2);

    @NotNull
    public ConfigurationManager getConfigurationManager(@NotNull AndroidFacet facet) {
        return ConfigurationManager.getOrCreateInstance(facet);
    }

    @NotNull
    public abstract List<NlComponent> getSelectableComponents();

    private class MyProgressPanel
    extends JPanel {
        private AsyncProcessIcon mySmallProgressIcon;
        private AsyncProcessIcon myLargeProgressIcon;
        private boolean mySmall;
        private boolean myProgressVisible;

        private MyProgressPanel() {
            super(new BorderLayout());
            this.setOpaque(false);
            this.setVisible(false);
        }

        private void setSmallIcon(boolean small) {
            if (small != this.mySmall) {
                if (this.myProgressVisible && this.getComponentCount() != 0) {
                    AsyncProcessIcon oldIcon = this.getProgressIcon();
                    oldIcon.suspend();
                }
                this.mySmall = true;
                this.removeAll();
                AsyncProcessIcon icon2 = this.getProgressIcon();
                this.add((Component)icon2, "Center");
                if (this.myProgressVisible) {
                    icon2.setVisible(true);
                    icon2.resume();
                }
            }
        }

        public void showProgressIcon() {
            if (!this.myProgressVisible) {
                this.setSmallIcon(DesignSurface.this.useSmallProgressIcon());
                this.myProgressVisible = true;
                this.setVisible(true);
                AsyncProcessIcon icon2 = this.getProgressIcon();
                if (this.getComponentCount() == 0) {
                    this.add((Component)this.getProgressIcon(), "Center");
                } else {
                    icon2.setVisible(true);
                }
                icon2.resume();
            }
        }

        public void hideProgressIcon() {
            if (this.myProgressVisible) {
                this.myProgressVisible = false;
                this.setVisible(false);
                AsyncProcessIcon icon2 = this.getProgressIcon();
                icon2.setVisible(false);
                icon2.suspend();
            }
        }

        @Override
        public void doLayout() {
            super.doLayout();
            this.setBackground((Color)JBColor.RED);
            if (!this.myProgressVisible) {
                return;
            }
            AsyncProcessIcon icon2 = this.getProgressIcon();
            Dimension size = icon2.getPreferredSize();
            if (this.mySmall) {
                icon2.setBounds(this.getWidth() - size.width - 1, 1, size.width, size.height);
            } else {
                icon2.setBounds(this.getWidth() / 2 - size.width / 2, this.getHeight() / 2 - size.height / 2, size.width, size.height);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getProgressIcon().getPreferredSize();
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon() {
            return this.getProgressIcon(this.mySmall);
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon(boolean small) {
            if (small) {
                if (this.mySmallProgressIcon == null) {
                    this.mySmallProgressIcon = new AsyncProcessIcon("Android layout rendering");
                    Disposer.register((Disposable)DesignSurface.this, (Disposable)this.mySmallProgressIcon);
                }
                return this.mySmallProgressIcon;
            }
            if (this.myLargeProgressIcon == null) {
                this.myLargeProgressIcon = new AsyncProcessIcon.Big("Android layout rendering");
                Disposer.register((Disposable)DesignSurface.this, (Disposable)this.myLargeProgressIcon);
            }
            return this.myLargeProgressIcon;
        }
    }

    private static class GlassPane
    extends JComponent {
        private static final long EVENT_FLAGS = 56L;

        public GlassPane() {
            this.enableEvents(56L);
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (enabled) {
                this.enableEvents(56L);
            } else {
                this.disableEvents(56L);
            }
        }

        @Override
        protected void processKeyEvent(KeyEvent event) {
            if (!event.isConsumed()) {
                super.processKeyEvent(event);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent event) {
            if (event.getID() == 501) {
                this.requestFocusInWindow();
            }
            super.processMouseEvent(event);
        }
    }

    private class MyLayeredPane
    extends JLayeredPane
    implements Magnificator,
    DataProvider {
        public MyLayeredPane() {
            if (DesignSurface.this.getSupportPinchAndZoom()) {
                this.putClientProperty(Magnificator.CLIENT_PROPERTY_KEY, this);
            }
        }

        public Point magnify(double scale, Point at) {
            DesignSurface.this.setScale(scale * DesignSurface.this.myScale);
            DesignSurface.this.repaint();
            return new Point((int)((double)at.x * scale), (int)((double)at.y * scale));
        }

        @Override
        protected void paintComponent(@NotNull Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g2d = (Graphics2D)graphics;
            int tlx = DesignSurface.this.myScrollPane.getHorizontalScrollBar().getValue();
            int tly = DesignSurface.this.myScrollPane.getVerticalScrollBar().getValue();
            this.paintBackground(g2d, tlx, tly);
            if (DesignSurface.this.getCurrentSceneView() == null) {
                return;
            }
            Rectangle bounds = DesignSurface.this.myScrollPane.getViewport().getViewRect();
            for (Layer layer : DesignSurface.this.myLayers) {
                if (layer.isHidden()) continue;
                g2d.setClip(bounds);
                layer.paint(g2d);
            }
            if (!DesignSurface.this.getLayoutType().isEditable()) {
                return;
            }
            List<Layer> layers = DesignSurface.this.myInteractionManager.getLayers();
            if (layers != null) {
                for (Layer layer : layers) {
                    if (layer.isHidden()) continue;
                    layer.paint(g2d);
                }
            }
        }

        private void paintBackground(@NotNull Graphics2D graphics, int lx, int ly) {
            int width = DesignSurface.this.myScrollPane.getWidth();
            int height = DesignSurface.this.myScrollPane.getHeight();
            graphics.setColor(this.getBackground());
            graphics.fillRect(lx, ly, width, height);
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            SelectionModel selectionModel;
            NlComponent primary;
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && DesignSurface.this.getCurrentSceneView() != null && (primary = (selectionModel = DesignSurface.this.getCurrentSceneView().getSelectionModel()).getPrimary()) != null) {
                return primary.getTagDeprecated();
            }
            if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId) && DesignSurface.this.getCurrentSceneView() != null) {
                selectionModel = DesignSurface.this.getCurrentSceneView().getSelectionModel();
                ImmutableList<NlComponent> selection = selectionModel.getSelection();
                ArrayList list = Lists.newArrayListWithCapacity((int)selection.size());
                for (NlComponent component : selection) {
                    list.add(component.getTagDeprecated());
                }
                return list.toArray(XmlTag.EMPTY);
            }
            NlModel model2 = DesignSurface.this.getModel();
            if (LangDataKeys.MODULE.is(dataId) && model2 != null) {
                return model2.getModule();
            }
            return null;
        }
    }

    private static class MyScrollBar
    extends JBScrollBar
    implements IdeGlassPane.TopComponent {
        private ScrollBarUI myPersistentUI;

        private MyScrollBar(@JdkConstants.AdjustableOrientation int orientation) {
            super(orientation);
            this.setOpaque(false);
        }

        public boolean canBePreprocessed(MouseEvent e) {
            return JBScrollPane.canBePreprocessed((MouseEvent)e, (JScrollBar)((Object)this));
        }

        public void setUI(ScrollBarUI ui) {
            if (this.myPersistentUI == null) {
                this.myPersistentUI = ui;
            }
            super.setUI(this.myPersistentUI);
            this.setOpaque(false);
        }

        public int getUnitIncrement(int direction) {
            return 5;
        }

        public int getBlockIncrement(int direction) {
            return 1;
        }
    }

    private static class MyScrollPane
    extends JBScrollPane {
        private MyScrollPane() {
            super(0);
            this.setupCorners();
        }

        @NotNull
        public JScrollBar createVerticalScrollBar() {
            return new MyScrollBar(1);
        }

        @NotNull
        public JScrollBar createHorizontalScrollBar() {
            return new MyScrollBar(0);
        }
    }
}

