/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.scene.Display;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.flags.StudioFlags;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class SceneLayer
extends Layer {
    private final DesignSurface myDesignSurface;
    private final SceneView mySceneView;
    private final Dimension myScreenViewSize = new Dimension();
    private final Rectangle mySizeRectangle = new Rectangle();
    private final Rectangle mySurfaceRectangle = new Rectangle();
    private final Display myDisplay = new Display();
    private boolean myShowOnHover = false;
    private boolean myShowAlways = true;
    private boolean myAlwaysShowSelection;
    private boolean myTemporaryShow = false;

    public SceneLayer(@NotNull DesignSurface surface, @NotNull SceneView view, boolean showAlways) {
        this.myDesignSurface = surface;
        this.mySceneView = view;
        this.myShowAlways = showAlways;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(@NotNull Graphics2D g2) {
        SceneContext sceneContext = SceneContext.get(this.mySceneView);
        if (!(this.myTemporaryShow || this.myShowOnHover || this.myShowAlways || this.myAlwaysShowSelection)) {
            return;
        }
        sceneContext.setShowOnlySelection(!this.myTemporaryShow && !this.myShowOnHover && this.myAlwaysShowSelection && (Boolean)StudioFlags.NELE_SHOW_ONLY_SELECTION.get() != false);
        Graphics2D g = (Graphics2D)g2.create();
        try {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.mySceneView.getSize(this.myScreenViewSize);
            Rectangle clipBounds = g.getClipBounds();
            this.mySizeRectangle.setBounds(this.mySceneView.getX(), this.mySceneView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
            Rectangle2D.intersect(this.mySizeRectangle, clipBounds, this.mySizeRectangle);
            if (this.mySizeRectangle.isEmpty()) {
                return;
            }
            this.myDesignSurface.getRenderableBoundsOfSceneView(this.mySceneView, this.mySurfaceRectangle);
            Rectangle2D.intersect(this.mySurfaceRectangle, clipBounds, this.mySurfaceRectangle);
            sceneContext.setRenderableBounds(this.mySurfaceRectangle);
            if (this.myShowAlways) {
                this.paintBackground(g, sceneContext);
            }
            this.myDisplay.draw(sceneContext, g, this.mySceneView.getScene());
        }
        finally {
            g.dispose();
        }
    }

    private void paintBackground(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Shape shape = this.mySceneView.getScreenShape();
        if (shape == null) {
            g.setColor(sceneContext.getColorSet().getBackground());
            g.fillRect(this.mySizeRectangle.x, this.mySizeRectangle.y, this.mySizeRectangle.width, this.mySizeRectangle.height);
        } else {
            g.setColor(sceneContext.getColorSet().getBackground().darker());
            g.fillRect(this.mySizeRectangle.x, this.mySizeRectangle.y, this.mySizeRectangle.width, this.mySizeRectangle.height);
            Shape clip = g.getClip();
            g.setColor(sceneContext.getColorSet().getBackground());
            g.setClip(shape);
            g.fillRect(this.mySizeRectangle.x, this.mySizeRectangle.y, this.mySizeRectangle.width, this.mySizeRectangle.height);
            g.setClip(clip);
        }
    }

    public boolean isShowOnHover() {
        return this.myShowOnHover;
    }

    public void setShowOnHover(boolean value2) {
        this.myShowOnHover = value2;
    }

    public SceneView getSceneView() {
        return this.mySceneView;
    }

    @Override
    public void hover(int x, int y) {
        boolean show = false;
        if (this.getSceneView() == this.myDesignSurface.getHoverSceneView(x, y)) {
            show = true;
        }
        if (this.isShowOnHover() != show) {
            this.setShowOnHover(show);
            this.myDesignSurface.repaint();
        }
    }

    public void setAlwaysShowSelection(boolean alwaysShowSelection) {
        this.myAlwaysShowSelection = alwaysShowSelection;
    }

    public void setTemporaryShow(boolean temporaryShow) {
        this.myTemporaryShow = temporaryShow;
        this.myDisplay.reLayout();
    }
}

