/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.resources.ScreenRound;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.handlers.constraint.drawing.ColorSet;
import com.google.common.collect.ImmutableList;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SceneView {
    @NotNull
    private final DesignSurface mySurface;
    @NotNull
    private final SceneManager myManager;
    private ImmutableList<Layer> myLayersCache;
    private int x;
    private int y;

    public SceneView(@NotNull DesignSurface surface, @NotNull SceneManager manager) {
        this.mySurface = surface;
        this.myManager = manager;
    }

    @NotNull
    protected abstract ImmutableList<Layer> createLayers();

    @NotNull
    public final ImmutableList<Layer> getLayers() {
        if (this.myLayersCache == null) {
            this.myLayersCache = this.createLayers();
        }
        return this.myLayersCache;
    }

    @NotNull
    public Scene getScene() {
        return this.myManager.getScene();
    }

    @NotNull
    public Dimension getSize(@Nullable Dimension dimension2) {
        if (dimension2 == null) {
            dimension2 = new Dimension();
        }
        Dimension preferred = this.getPreferredSize(dimension2);
        double scale = this.getScale();
        dimension2.setSize((int)(scale * (double)preferred.width), (int)(scale * (double)preferred.height));
        return dimension2;
    }

    @NotNull
    public Dimension getPreferredSize() {
        return this.getPreferredSize(null);
    }

    @NotNull
    public Dimension getSize() {
        return this.getSize(null);
    }

    @NotNull
    public abstract Dimension getPreferredSize(@Nullable Dimension var1);

    @NotNull
    public Configuration getConfiguration() {
        return this.getSceneManager().getModel().getConfiguration();
    }

    @Deprecated
    @NotNull
    public NlModel getModel() {
        return this.myManager.getModel();
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        return this.getSurface().getSelectionModel();
    }

    @Nullable
    public Shape getScreenShape() {
        Device device = this.getConfiguration().getDevice();
        if (device == null) {
            return null;
        }
        Screen screen = device.getDefaultHardware().getScreen();
        if (screen.getScreenRound() != ScreenRound.ROUND) {
            return null;
        }
        Dimension size = this.getSize();
        int chin = screen.getChin();
        int originX = this.getX();
        int originY = this.getY();
        if (chin == 0) {
            return new Ellipse2D.Double(originX, originY, size.width, size.height);
        }
        int height = size.height * chin / screen.getYDimension();
        Area a1 = new Area(new Ellipse2D.Double(originX, originY, size.width, size.height + height));
        Area a2 = new Area(new Rectangle2D.Double(originX, originY + 2 * (size.height + height) - height, size.width, height));
        a1.subtract(a2);
        return a1;
    }

    @NotNull
    public DesignSurface getSurface() {
        return this.mySurface;
    }

    public double getScale() {
        return this.getSurface().getScale();
    }

    public float getSceneScalingFactor() {
        return this.getSurface().getSceneScalingFactor();
    }

    public void setLocation(int screenX, int screenY) {
        this.x = screenX;
        this.y = screenY;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getContentTranslationX() {
        return 0;
    }

    public int getContentTranslationY() {
        return 0;
    }

    @Nullable
    public Cursor getCursor(int x, int y) {
        SceneContext.get(this).setMouseLocation(x, y);
        this.getScene().mouseHover(SceneContext.get(this), Coordinates.getAndroidXDip(this, x), Coordinates.getAndroidYDip(this, y));
        return this.getScene().getMouseCursor();
    }

    @NotNull
    public SceneManager getSceneManager() {
        return this.myManager;
    }

    public void setToolTip(@Nullable String toolTip) {
        this.getSurface().setDesignToolTip(toolTip);
    }

    @NotNull
    public abstract ColorSet getColorSet();
}

