/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.concurrency;

import com.android.tools.idea.concurrency.Computation;
import com.android.tools.idea.concurrency.ValueWithTimestamp;
import com.android.tools.idea.concurrent.FutureUtils;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0013\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0004J\u0014\u0010\u0013\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00018\u00008\u00000\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0002J\u000b\u0010\u0016\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0017R(\u0010\u0006\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00028\u0000 \t*\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/concurrency/Computation;", "V", "", "modificationCountWhenScheduled", "", "(J)V", "future", "Lcom/google/common/util/concurrent/SettableFuture;", "Lcom/android/tools/idea/concurrency/ValueWithTimestamp;", "kotlin.jvm.PlatformType", "getModificationCountWhenScheduled", "()J", "result", "Ljava/util/concurrent/atomic/AtomicReference;", "broadcastResult", "", "complete", "(Ljava/lang/Object;)V", "getCompletionTimestamp", "getResult", "Lcom/google/common/util/concurrent/ListenableFuture;", "getResultAndCheckComplete", "getResultNow", "()Ljava/lang/Object;", "intellij.android.core"})
final class Computation<V> {
    private final AtomicReference<ValueWithTimestamp<V>> result;
    private final SettableFuture<ValueWithTimestamp<V>> future;
    private final long modificationCountWhenScheduled;

    private final ValueWithTimestamp<V> getResultAndCheckComplete() {
        ValueWithTimestamp<V> valueWithTimestamp = this.result.get();
        if (valueWithTimestamp == null) {
            throw (Throwable)new IllegalStateException("This Computation hasn't been executed yet.");
        }
        return valueWithTimestamp;
    }

    public final void complete(V result2) {
        ValueWithTimestamp<V> resultWithTimestamp = new ValueWithTimestamp<V>(result2, System.currentTimeMillis());
        if (!this.result.compareAndSet(null, resultWithTimestamp)) {
            throw (Throwable)new IllegalStateException("This Computation has already been executed.");
        }
    }

    public final void broadcastResult() {
        this.future.set(this.getResultAndCheckComplete());
    }

    @NotNull
    public final ListenableFuture<V> getResult() {
        ListenableFuture listenableFuture = Futures.nonCancellationPropagating((ListenableFuture)FutureUtils.transform$default((ListenableFuture)((ListenableFuture)this.future), null, (Function1)getResult.1.INSTANCE, (int)1, null));
        if (listenableFuture == null) {
            Intrinsics.throwNpe();
        }
        return listenableFuture;
    }

    public final V getResultNow() {
        return this.getResultAndCheckComplete().getValue();
    }

    public final long getCompletionTimestamp() {
        return this.getResultAndCheckComplete().getTimestampMs();
    }

    public final long getModificationCountWhenScheduled() {
        return this.modificationCountWhenScheduled;
    }

    public Computation(long modificationCountWhenScheduled) {
        this.modificationCountWhenScheduled = modificationCountWhenScheduled;
        this.result = new AtomicReference<Object>(null);
        SettableFuture settableFuture = SettableFuture.create();
        if (settableFuture == null) {
            Intrinsics.throwNpe();
        }
        this.future = settableFuture;
    }
}

