/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.LayoutDirection;
import com.android.resources.NightMode;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.android.tools.idea.configurations.ResourceResolverCache;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Configuration
implements Disposable,
ModificationTracker {
    public static final String AVD_ID_PREFIX = "_android_virtual_device_id_";
    public static final String CUSTOM_DEVICE_ID = "Custom";
    @Nullable
    final VirtualFile myFile;
    @Nullable
    private PsiFile myPsiFile;
    @NotNull
    protected final FolderConfiguration myFullConfig = new FolderConfiguration();
    @NotNull
    protected final ConfigurationManager myManager;
    @NotNull
    protected final FolderConfiguration myEditedConfig;
    @Nullable
    private IAndroidTarget myTarget;
    @Nullable
    private String myTheme;
    @Nullable
    private Device mySpecificDevice;
    @Nullable
    private State myState;
    @Nullable
    private Device myDevice;
    @Nullable
    private String myStateName;
    @Nullable
    private String myActivity;
    @Nullable
    private Locale myLocale = null;
    @NotNull
    private UiMode myUiMode = UiMode.NORMAL;
    @NotNull
    private NightMode myNightMode = NightMode.NOTNIGHT;
    private String myDisplayName;
    private int myBulkEditingCount;
    @Nullable
    private List<ConfigurationListener> myListeners;
    protected int myNotifyDirty;
    protected int myFolderConfigDirty = 246;
    protected int myProjectStateVersion;
    private long myModificationCount;
    private static final String NO_ACTIVITY = new String();

    protected Configuration(@NotNull ConfigurationManager manager, @Nullable VirtualFile file, @NotNull FolderConfiguration editedConfig) {
        this.myManager = manager;
        this.myFile = file;
        this.myEditedConfig = editedConfig;
        if (this.isLocaleSpecificLayout()) {
            this.myLocale = Locale.create(editedConfig);
        }
        if (this.isOrientationSpecificLayout()) {
            ScreenOrientationQualifier qualifier = editedConfig.getScreenOrientationQualifier();
            assert (qualifier != null);
            ScreenOrientation orientation = qualifier.getValue();
            if (orientation != null) {
                this.myStateName = orientation.getShortDisplayValue();
            }
        }
    }

    @NotNull
    public static Configuration create(@NotNull ConfigurationManager manager, @Nullable VirtualFile file, @NotNull FolderConfiguration editedConfig) {
        return new Configuration(manager, file, editedConfig);
    }

    @NotNull
    public static Configuration create(@NotNull Configuration base, @NotNull VirtualFile file) {
        Configuration configuration = base.clone();
        ConfigurationMatcher matcher = new ConfigurationMatcher(configuration, file);
        configuration.getEditedConfig().set(FolderConfiguration.getConfigForFolder((String)file.getParent().getName()));
        matcher.adaptConfigSelection(true);
        return configuration;
    }

    @NotNull
    public static Configuration create(@NotNull ConfigurationManager manager, @Nullable VirtualFile file, @Nullable ConfigurationFileState fileState, @NotNull FolderConfiguration editedConfig) {
        Configuration configuration = new Configuration(manager, file, editedConfig);
        configuration.startBulkEditing();
        if (fileState != null) {
            fileState.loadState(configuration);
        }
        configuration.finishBulkEditing();
        return configuration;
    }

    @NotNull
    public static Configuration copy(@NotNull Configuration original) {
        FolderConfiguration copiedConfig = new FolderConfiguration();
        copiedConfig.set(original.getEditedConfig());
        Configuration copy = new Configuration(original.myManager, original.myFile, copiedConfig);
        copy.myFullConfig.set(original.myFullConfig);
        copy.myFolderConfigDirty = original.myFolderConfigDirty;
        copy.myProjectStateVersion = original.myProjectStateVersion;
        copy.myTarget = original.myTarget;
        copy.myLocale = original.myLocale;
        copy.myTheme = original.getTheme();
        copy.mySpecificDevice = original.mySpecificDevice;
        copy.myDevice = original.myDevice;
        copy.myStateName = original.myStateName;
        copy.myState = original.myState;
        copy.myActivity = original.getActivity();
        copy.myUiMode = original.getUiMode();
        copy.myNightMode = original.getNightMode();
        copy.myDisplayName = original.getDisplayName();
        return copy;
    }

    public Configuration clone() {
        return Configuration.copy(this);
    }

    @NotNull
    public static Configuration copyCompatible(@NotNull Configuration source, @NotNull Configuration destination) {
        assert (!Comparing.equal((Object)source.myFile, (Object)destination.myFile));
        FolderConfiguration editedConfig = destination.getEditedConfig();
        if (editedConfig.getVersionQualifier() == null) {
            destination.myTarget = source.myTarget;
        }
        if (editedConfig.getScreenSizeQualifier() == null) {
            destination.mySpecificDevice = source.mySpecificDevice;
        }
        if (editedConfig.getScreenOrientationQualifier() == null && editedConfig.getSmallestScreenWidthQualifier() == null) {
            destination.myStateName = source.myStateName;
            destination.myState = source.myState;
        }
        if (editedConfig.getLocaleQualifier() == null) {
            destination.myLocale = source.myLocale;
        }
        if (editedConfig.getUiModeQualifier() == null) {
            destination.myUiMode = source.getUiMode();
        }
        if (editedConfig.getNightModeQualifier() == null) {
            destination.myNightMode = source.getNightMode();
        }
        destination.myActivity = source.getActivity();
        destination.myTheme = source.getTheme();
        ConfigurationMatcher matcher = new ConfigurationMatcher(destination, destination.myFile);
        matcher.adaptConfigSelection(true);
        return destination;
    }

    public void save() {
        ConfigurationStateManager stateManager = ConfigurationStateManager.get(this.myManager.getModule().getProject());
        if (this.myFile != null) {
            ConfigurationFileState fileState = new ConfigurationFileState();
            fileState.saveState(this);
            stateManager.setConfigurationState(this.myFile, fileState);
        }
    }

    @NotNull
    public ConfigurationManager getConfigurationManager() {
        return this.myManager;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Nullable
    public PsiFile getPsiFile() {
        if (this.myPsiFile == null && this.myFile != null) {
            this.myPsiFile = AndroidPsiUtils.getPsiFileSafely(this.myManager.getProject(), this.myFile);
        }
        return this.myPsiFile;
    }

    @Nullable
    public String getActivity() {
        if (this.myActivity == NO_ACTIVITY) {
            return null;
        }
        if (this.myActivity == null && this.myFile != null) {
            this.myActivity = (String)ApplicationManager.getApplication().runReadAction(() -> {
                XmlAttribute attribute;
                XmlFile xmlFile;
                XmlTag rootTag;
                if (this.myPsiFile == null) {
                    this.myPsiFile = PsiManager.getInstance((Project)this.myManager.getProject()).findFile(this.myFile);
                }
                if (this.myPsiFile instanceof XmlFile && (rootTag = (xmlFile = (XmlFile)this.myPsiFile).getRootTag()) != null && (attribute = rootTag.getAttribute("context", "http://schemas.android.com/tools")) != null) {
                    return attribute.getValue();
                }
                return null;
            });
            if (this.myActivity == null) {
                this.myActivity = NO_ACTIVITY;
                return null;
            }
        }
        return this.myActivity;
    }

    @Slow
    @Nullable
    public Device getDevice() {
        if (this.myDevice == null) {
            this.myDevice = this.mySpecificDevice != null ? this.mySpecificDevice : this.computeBestDevice();
        }
        return this.myDevice;
    }

    @Nullable
    public static FolderConfiguration getFolderConfig(@NotNull Module module, @NotNull State state, @NotNull Locale locale, @Nullable IAndroidTarget target) {
        FolderConfiguration currentConfig = DeviceConfigHelper.getFolderConfig((State)state);
        if (currentConfig != null && locale.hasLanguage()) {
            LayoutLibrary layoutLib;
            currentConfig.setLocaleQualifier(locale.qualifier);
            if (locale.hasLanguage() && (layoutLib = RenderService.getLayoutLibrary(module, target)) != null && layoutLib.isRtl(locale.toLocaleId())) {
                currentConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.RTL));
            }
        }
        return currentConfig;
    }

    @Slow
    @Nullable
    private Device computeBestDevice() {
        for (Device device : this.myManager.getRecentDevices()) {
            LocalResourceRepository resources;
            String stateName = this.myStateName;
            if (stateName == null) {
                stateName = device.getDefaultState().getName();
            }
            State selectedState = ConfigurationFileState.getState(device, stateName);
            Module module = this.myManager.getModule();
            FolderConfiguration currentConfig = Configuration.getFolderConfig(module, selectedState, this.getLocale(), this.getTarget());
            if (currentConfig == null || !this.myEditedConfig.isMatchFor(currentConfig) || (resources = ResourceRepositoryManager.getAppResources(module)) == null || this.myFile == null) continue;
            ResourceFolderType folderType = ResourceHelper.getFolderType(this.myFile);
            if (folderType != null) {
                if (ResourceFolderType.VALUES.equals((Object)folderType)) {
                    LocalResourceManager resourceManager = LocalResourceManager.getInstance(module);
                    if (resourceManager == null) continue;
                    for (PsiFile resourceFile : resourceManager.findResourceFiles(ResourceNamespace.TODO(), ResourceFolderType.VALUES)) {
                        FolderConfiguration folderConfiguration;
                        if (!this.myFile.equals(resourceFile.getVirtualFile()) || resourceFile.getParent() == null || !currentConfig.isMatchFor(folderConfiguration = FolderConfiguration.getConfigForFolder((String)resourceFile.getParent().getName()))) continue;
                        return device;
                    }
                    continue;
                }
                List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                if (types.isEmpty()) continue;
                ResourceType type = (ResourceType)types.get(0);
                List<VirtualFile> matches = ConfigurationMatcher.getMatchingFiles((ResourceRepository)resources, this.myFile, ResourceNamespace.TODO(), type, currentConfig);
                if (!matches.contains(this.myFile)) continue;
                return device;
            }
            if ("Kotlin".equals(this.myFile.getFileType().getName())) {
                return device;
            }
            if (!this.myFile.equals(this.myManager.getProject().getProjectFile())) continue;
            return device;
        }
        return this.myManager.getDefaultDevice();
    }

    @Nullable
    public State getDeviceState() {
        if (this.myState == null) {
            Device device = this.getDevice();
            this.myState = ConfigurationFileState.getState(device, this.myStateName);
        }
        return this.myState;
    }

    @NotNull
    public Locale getLocale() {
        if (this.myLocale == null) {
            return this.myManager.getLocale();
        }
        return this.myLocale;
    }

    @NotNull
    public UiMode getUiMode() {
        return this.myUiMode;
    }

    @NotNull
    public NightMode getNightMode() {
        return this.myNightMode;
    }

    @NotNull
    public String getTheme() {
        if (this.myTheme == null) {
            this.myTheme = this.myManager.computePreferredTheme(this);
        }
        return this.myTheme;
    }

    @Nullable
    public IAndroidTarget getTarget() {
        if (this.myTarget == null) {
            IAndroidTarget target = this.myManager.getTarget();
            VersionQualifier version2 = this.myEditedConfig.getVersionQualifier();
            if (target != null && version2 != null && version2.getVersion() > target.getVersion().getFeatureLevel()) {
                target = this.myManager.getTarget(version2.getVersion());
            }
            return Configuration.getTargetForRendering(target);
        }
        return this.myTarget;
    }

    @Nullable
    public IAndroidTarget getRealTarget() {
        CompatibilityRenderTarget compatTarget;
        IAndroidTarget target = this.getTarget();
        if (target instanceof CompatibilityRenderTarget && (compatTarget = (CompatibilityRenderTarget)target).getRealTarget() != null) {
            return compatTarget.getRealTarget();
        }
        return target;
    }

    @Nullable
    public String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isLocaleSpecificLayout() {
        return this.myEditedConfig.getLocaleQualifier() != null;
    }

    public boolean isTargetSpecificLayout() {
        return this.myEditedConfig.getVersionQualifier() != null;
    }

    public boolean isOrientationSpecificLayout() {
        return this.myEditedConfig.getScreenOrientationQualifier() != null;
    }

    @NotNull
    public FolderConfiguration getFullConfig() {
        if ((this.myFolderConfigDirty & 0xF6) != 0 || this.myProjectStateVersion != this.myManager.getStateVersion()) {
            this.syncFolderConfig();
        }
        return this.myFullConfig;
    }

    public void copyFullConfig(FolderConfiguration dest) {
        dest.set(this.myFullConfig);
    }

    @NotNull
    public FolderConfiguration getEditedConfig() {
        return this.myEditedConfig;
    }

    public void setActivity(@Nullable String activity) {
        if (!StringUtil.equals((CharSequence)this.myActivity, (CharSequence)activity)) {
            this.myActivity = activity;
            this.updated(256);
        }
    }

    public void setDevice(Device device, boolean preserveState) {
        if (this.mySpecificDevice != device) {
            Device prevDevice = this.mySpecificDevice;
            State prevState = this.myState;
            this.myDevice = this.mySpecificDevice = device;
            int updateFlags = 2;
            if (device != null) {
                State state = null;
                if (preserveState && prevDevice != null) {
                    if (prevState != null) {
                        FolderConfiguration oldConfig = DeviceConfigHelper.getFolderConfig((State)prevState);
                        if (oldConfig != null) {
                            String stateName = Configuration.getClosestMatch(oldConfig, device.getAllStates());
                            state = device.getState(stateName);
                        } else {
                            state = device.getState(prevState.getName());
                        }
                    }
                } else if (preserveState && this.myStateName != null) {
                    state = device.getState(this.myStateName);
                }
                if (state == null) {
                    state = device.getDefaultState();
                }
                if (this.myState != state) {
                    this.setDeviceStateName(state.getName());
                    this.myState = state;
                    updateFlags |= 4;
                }
            }
            if (this.mySpecificDevice != null && this.myState == null) {
                this.setDeviceStateName(this.mySpecificDevice.getDefaultState().getName());
                this.myState = this.mySpecificDevice.getDefaultState();
                updateFlags |= 4;
            }
            this.updated(updateFlags);
        }
    }

    @Nullable
    private static String getClosestMatch(@NotNull FolderConfiguration oldConfig, @NotNull List<State> states) {
        ArrayList<Object> list1 = new ArrayList<Object>(states.size());
        ArrayList<State> list2 = new ArrayList<State>(states.size());
        list1.addAll(states);
        int count = FolderConfiguration.getQualifierCount();
        for (int i2 = 0; i2 < count; ++i2) {
            for (State state : list1) {
                ResourceQualifier newQualifier;
                ResourceQualifier oldQualifier = oldConfig.getQualifier(i2);
                FolderConfiguration folderConfig = DeviceConfigHelper.getFolderConfig((State)state);
                ResourceQualifier resourceQualifier = newQualifier = folderConfig != null ? folderConfig.getQualifier(i2) : null;
                if (oldQualifier == null) {
                    if (newQualifier != null) continue;
                    list2.add(state);
                    continue;
                }
                if (!oldQualifier.equals((Object)newQualifier)) continue;
                list2.add(state);
            }
            if (list2.size() == 1) {
                return ((State)list2.get(0)).getName();
            }
            if (list2.isEmpty()) continue;
            list1.clear();
            list1.addAll(list2);
            list2.clear();
        }
        if (!list1.isEmpty()) {
            return ((State)list1.get(0)).getName();
        }
        return null;
    }

    public void setDeviceState(State state) {
        if (this.myState != state) {
            if (state != null) {
                this.setDeviceStateName(state.getName());
            } else {
                this.myStateName = null;
            }
            this.myState = state;
            this.updated(4);
        }
    }

    public void setDeviceStateName(@Nullable String stateName) {
        ScreenOrientation orientation;
        ScreenOrientationQualifier qualifier = this.myEditedConfig.getScreenOrientationQualifier();
        if (qualifier != null && (orientation = qualifier.getValue()) != null) {
            stateName = orientation.getShortDisplayValue();
        }
        if (!Objects.equal((Object)stateName, (Object)this.myStateName)) {
            this.myStateName = stateName;
            this.myState = null;
            this.updated(4);
        }
    }

    public void setLocale(@NotNull Locale locale) {
        if (!Objects.equal((Object)this.myLocale, (Object)locale)) {
            this.myLocale = locale;
            this.updated(16);
        }
    }

    public void setTarget(@Nullable IAndroidTarget target) {
        if (this.myTarget != target) {
            this.myTarget = Configuration.getTargetForRendering(target);
            this.updated(32);
        }
    }

    public void setDisplayName(@Nullable String displayName) {
        if (!StringUtil.equals((CharSequence)this.myDisplayName, (CharSequence)displayName)) {
            this.myDisplayName = displayName;
            this.updated(512);
        }
    }

    public void setNightMode(@NotNull NightMode night) {
        if (this.myNightMode != night) {
            this.myNightMode = night;
            this.updated(64);
        }
    }

    public void setUiMode(@NotNull UiMode uiMode) {
        if (this.myUiMode != uiMode) {
            this.myUiMode = uiMode;
            this.updated(128);
        }
    }

    public void setTheme(@Nullable String theme) {
        if (!StringUtil.equals((CharSequence)this.myTheme, (CharSequence)theme)) {
            this.myTheme = theme;
            this.checkThemePrefix();
            this.updated(8);
        }
    }

    protected void syncFolderConfig() {
        Device device = this.getDevice();
        if (device == null) {
            return;
        }
        State deviceState = this.getDeviceState();
        if (deviceState == null) {
            deviceState = device.getDefaultState();
        }
        FolderConfiguration config = Configuration.getFolderConfig(this.getModule(), deviceState, this.getLocale(), this.getTarget());
        this.myFullConfig.set(config);
        Locale locale = this.getLocale();
        this.myFullConfig.setLocaleQualifier(locale.qualifier);
        LayoutDirectionQualifier layoutDirectionQualifier = this.myEditedConfig.getLayoutDirectionQualifier();
        if (layoutDirectionQualifier != null && layoutDirectionQualifier != layoutDirectionQualifier.getNullQualifier()) {
            this.myFullConfig.setLayoutDirectionQualifier(layoutDirectionQualifier);
        } else if (!locale.hasLanguage()) {
            this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.LTR));
        } else {
            LayoutLibrary layoutLib = RenderService.getLayoutLibrary(this.getModule(), this.getTarget());
            if (layoutLib != null) {
                if (layoutLib.isRtl(locale.toLocaleId())) {
                    this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.RTL));
                } else {
                    this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.LTR));
                }
            }
        }
        UiMode uiMode = this.getUiMode();
        this.myFullConfig.setUiModeQualifier(new UiModeQualifier(uiMode));
        NightMode nightMode = this.getNightMode();
        this.myFullConfig.setNightModeQualifier(new NightModeQualifier(nightMode));
        IAndroidTarget target = this.getTarget();
        if (target != null) {
            int apiLevel = target.getVersion().getFeatureLevel();
            this.myFullConfig.setVersionQualifier(new VersionQualifier(apiLevel));
        }
        this.myFolderConfigDirty = 0;
        this.myProjectStateVersion = this.myManager.getStateVersion();
    }

    @Nullable
    public ScreenSize getScreenSize() {
        FolderConfiguration folderConfig;
        State deviceState = this.getDeviceState();
        if (deviceState != null && (folderConfig = DeviceConfigHelper.getFolderConfig((State)deviceState)) != null) {
            ScreenSizeQualifier qualifier = folderConfig.getScreenSizeQualifier();
            assert (qualifier != null);
            return qualifier.getValue();
        }
        ScreenSize screenSize = null;
        Device device = this.getDevice();
        if (device != null) {
            List states = device.getAllStates();
            for (State state : states) {
                FolderConfiguration folderConfig2 = DeviceConfigHelper.getFolderConfig((State)state);
                if (folderConfig2 == null) continue;
                ScreenSizeQualifier qualifier = folderConfig2.getScreenSizeQualifier();
                assert (qualifier != null);
                screenSize = qualifier.getValue();
                break;
            }
        }
        return screenSize;
    }

    private void checkThemePrefix() {
        if (this.myTheme != null && !this.myTheme.startsWith("@")) {
            if (this.myTheme.isEmpty()) {
                this.myTheme = this.myManager.computePreferredTheme(this);
                return;
            }
            this.myTheme = ResolutionUtils.getStyleResourceUrl(this.myTheme);
        }
    }

    @NotNull
    public Density getDensity() {
        Density d;
        DensityQualifier qualifier = this.getFullConfig().getDensityQualifier();
        if (qualifier != null && (d = qualifier.getValue()) != null && d.isValidValueForDevice()) {
            return d;
        }
        return Density.MEDIUM;
    }

    @Nullable
    public State getNextDeviceState(@Nullable State from) {
        Device device = this.getDevice();
        if (device == null) {
            return null;
        }
        List states = device.getAllStates();
        for (int i2 = 0; i2 < states.size(); ++i2) {
            if (states.get(i2) != from) continue;
            return (State)states.get((i2 + 1) % states.size());
        }
        if (from != null) {
            String name = from.getName();
            for (int i3 = 0; i3 < states.size(); ++i3) {
                if (!((State)states.get(i3)).getName().equals(name)) continue;
                return (State)states.get((i3 + 1) % states.size());
            }
        }
        return null;
    }

    public boolean supports(int capability) {
        IAndroidTarget target = this.getTarget();
        if (target != null) {
            return RenderService.supportsCapability(this.getModule(), target, capability);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBulkEditing() {
        Configuration configuration = this;
        synchronized (configuration) {
            ++this.myBulkEditingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBulkEditing() {
        boolean notify = false;
        Configuration configuration = this;
        synchronized (configuration) {
            --this.myBulkEditingCount;
            if (this.myBulkEditingCount == 0) {
                notify = true;
            }
        }
        if (notify) {
            this.updated(0);
        }
    }

    public void updated(int flags) {
        this.myNotifyDirty |= flags;
        this.myFolderConfigDirty |= flags;
        ++this.myModificationCount;
        if (this.myManager.getStateVersion() != this.myProjectStateVersion) {
            this.myNotifyDirty |= 0x32;
            this.myFolderConfigDirty |= 0x32;
            this.myDevice = null;
            this.myState = null;
        }
        if (this.myBulkEditingCount == 0) {
            int changed = this.myNotifyDirty;
            if (this.myListeners != null) {
                for (ConfigurationListener listener2 : this.myListeners) {
                    listener2.changed(changed);
                }
            }
            this.myNotifyDirty = 0;
        }
    }

    public void addListener(@NotNull ConfigurationListener listener2) {
        if (this.myListeners == null) {
            this.myListeners = new ArrayList<ConfigurationListener>();
        }
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull ConfigurationListener listener2) {
        if (this.myListeners != null) {
            this.myListeners.remove(listener2);
            if (this.myListeners.isEmpty()) {
                this.myListeners = null;
            }
        }
    }

    @NotNull
    public ResourceResolver getResourceResolver() {
        String theme = this.getTheme();
        Device device = this.getDevice();
        ResourceResolverCache resolverCache = this.myManager.getResolverCache();
        if (device != null && CUSTOM_DEVICE_ID.equals(device.getId())) {
            resolverCache.replaceCustomConfig(theme, this.getFullConfig());
        }
        return resolverCache.getResourceResolver(this.getTarget(), theme, this.getFullConfig());
    }

    @Nullable
    public ResourceRepository getFrameworkResources() {
        IAndroidTarget target = this.getTarget();
        if (target != null) {
            return this.myManager.getResolverCache().getFrameworkResources(this.getFullConfig(), target);
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("display", (Object)this.getDisplayName()).add("theme", (Object)this.getTheme()).add("activity", (Object)this.getActivity()).add("device", (Object)this.getDevice()).add("state", (Object)this.getDeviceState()).add("locale", (Object)this.getLocale()).add("target", (Object)this.getTarget()).add("uimode", (Object)this.getUiMode()).add("nightmode", (Object)this.getNightMode()).toString();
    }

    public Module getModule() {
        return this.myManager.getModule();
    }

    public boolean isBestMatchFor(VirtualFile file, FolderConfiguration config) {
        return new ConfigurationMatcher(this, file).isCurrentFileBestMatchFor(config);
    }

    public void dispose() {
    }

    public void setEffectiveDevice(@Nullable Device device, @Nullable State state) {
        int updateFlags = 0;
        if (this.myDevice != device) {
            updateFlags = 2;
            this.myDevice = device;
        }
        if (this.myState != state) {
            this.myState = state;
            this.myStateName = state != null ? state.getName() : null;
            updateFlags |= 4;
        }
        if (updateFlags != 0) {
            this.updated(updateFlags);
        }
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    @Nullable
    private static IAndroidTarget getTargetForRendering(@Nullable IAndroidTarget target) {
        if (target == null) {
            return null;
        }
        return StudioEmbeddedRenderTarget.getCompatibilityTarget(target);
    }
}

