/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import icons.AndroidIcons;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ConfigurationAction
extends AnAction
implements ConfigurationListener,
Toggleable {
    private static final String FILE_ARROW = " \u2192 ";
    protected final ConfigurationHolder myRenderContext;
    private int myFlags;

    public ConfigurationAction(@NotNull ConfigurationHolder renderContext) {
        this(renderContext, null, null);
    }

    public ConfigurationAction(@NotNull ConfigurationHolder renderContext, @Nullable String title) {
        this(renderContext, title, null);
    }

    public ConfigurationAction(@NotNull ConfigurationHolder renderContext, @Nullable String title, @Nullable Icon icon2) {
        super(title, null, icon2);
        this.myRenderContext = renderContext;
    }

    protected void updatePresentation(@NotNull Presentation presentation) {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ActionManagerEx manager = ActionManagerEx.getInstanceEx();
        DataContext dataContext = e.getDataContext();
        manager.fireBeforeActionPerformed((AnAction)this, dataContext, e);
        this.tryUpdateConfiguration();
        this.updatePresentation(e.getPresentation());
    }

    protected void tryUpdateConfiguration() {
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null) {
            ConfigurationMatcher matcher;
            List<VirtualFile> matchingFiles;
            VirtualFile file;
            Module module;
            boolean affectsFileSelection;
            Configuration clone = configuration.clone();
            this.myFlags = 0;
            clone.addListener(this);
            this.updateConfiguration(clone, false);
            clone.removeListener(this);
            boolean bl = affectsFileSelection = (this.myFlags & 0xF6) != 0;
            if (affectsFileSelection && (module = this.myRenderContext.getConfiguration().getModule()) != null && (file = this.myRenderContext.getConfiguration().getFile()) != null && !(matchingFiles = (matcher = new ConfigurationMatcher(clone, file)).getBestFileMatches()).isEmpty() && !matchingFiles.contains(file)) {
                this.pickedBetterMatch(matchingFiles.get(0), file);
                AndroidFacet facet = AndroidFacet.getInstance(module);
                assert (facet != null);
                ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(module);
                this.updateConfiguration(configurationManager.getConfiguration(matchingFiles.get(0)), true);
                return;
            }
            this.updateConfiguration(configuration, true);
        }
    }

    protected void pickedBetterMatch(@NotNull VirtualFile file, @NotNull VirtualFile old) {
        Module module = this.myRenderContext.getConfiguration().getModule();
        assert (module != null);
        Project project = module.getProject();
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, file, -1);
        FileEditorManagerEx manager = FileEditorManagerEx.getInstanceEx((Project)project);
        FileEditorWithProvider previousSelection = manager.getSelectedEditorWithProvider(old);
        manager.openEditor(descriptor2, true);
        if (previousSelection != null) {
            manager.setSelectedEditor(file, previousSelection.getProvider().getEditorTypeId());
        }
    }

    @Override
    public boolean changed(int flags) {
        this.myFlags |= flags;
        return true;
    }

    protected abstract void updateConfiguration(@NotNull Configuration var1, boolean var2);

    public static boolean isBetterMatchLabel(@NotNull String label) {
        return label.contains(FILE_ARROW);
    }

    public static String getBetterMatchLabel(@NotNull String prefix, @NotNull VirtualFile better, @Nullable VirtualFile file) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        sb.append(FILE_ARROW);
        String folderName = better.getParent().getName();
        if (folderName.equals("layout")) {
            if (file != null && !Comparing.equal((Object)file.getParent(), (Object)better.getParent())) {
                sb.append("layout");
                sb.append(File.separatorChar);
            }
        } else {
            if (folderName.startsWith("layout")) {
                folderName = folderName.substring("layout".length() + 1);
            }
            sb.append(folderName);
            sb.append(File.separatorChar);
        }
        sb.append(better.getName());
        return sb.toString();
    }

    public static Icon getBetterMatchIcon() {
        return AndroidIcons.NotMatch;
    }
}

