/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.resources.NightMode;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Tag;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="config")
public class ConfigurationFileState {
    @Nullable
    private String myDeviceState;
    @Nullable
    private String myDockMode;
    @Nullable
    private String myNightMode;
    @Nullable
    private String myTheme;

    @Tag(value="state")
    @Nullable
    public String getDeviceState() {
        return this.myDeviceState;
    }

    public void setDeviceState(@Nullable String deviceState) {
        this.myDeviceState = deviceState;
    }

    @Tag(value="dock")
    @Nullable
    public String getDockMode() {
        return this.myDockMode;
    }

    public void setDockMode(@Nullable String dockMode) {
        this.myDockMode = dockMode;
    }

    @Tag(value="night")
    @Nullable
    public String getNightMode() {
        return this.myNightMode;
    }

    public void setNightMode(@Nullable String nightMode) {
        this.myNightMode = nightMode;
    }

    @Tag(value="theme")
    @Nullable
    public String getTheme() {
        return this.myTheme;
    }

    public void setTheme(@Nullable String theme) {
        this.myTheme = theme;
    }

    public void saveState(@NotNull Configuration configuration) {
        UiMode dockMode;
        State deviceState;
        Device device = configuration.getDevice();
        this.myDeviceState = null;
        if (device != null && (deviceState = configuration.getDeviceState()) != null && deviceState != device.getDefaultState()) {
            this.myDeviceState = deviceState.getName();
        }
        this.myDockMode = (dockMode = configuration.getUiMode()) != UiMode.NORMAL ? dockMode.getResourceValue() : null;
        this.myDockMode = StringUtil.nullize((String)dockMode.getResourceValue());
        NightMode nightMode = configuration.getNightMode();
        this.myNightMode = nightMode != NightMode.NOTNIGHT ? nightMode.getResourceValue() : null;
        this.myTheme = StringUtil.nullize((String)configuration.getTheme());
    }

    public void loadState(@NotNull Configuration configuration) {
        NightMode nightMode;
        UiMode dockMode;
        configuration.startBulkEditing();
        ConfigurationManager manager = configuration.getConfigurationManager();
        configuration.setDeviceStateName(this.myDeviceState);
        if (this.myDockMode != null && (dockMode = UiMode.getEnum((String)this.myDockMode)) != null) {
            configuration.setUiMode(dockMode);
        }
        if (this.myNightMode != null && (nightMode = NightMode.getEnum((String)this.myNightMode)) != null) {
            configuration.setNightMode(nightMode);
        }
        if (this.myTheme != null) {
            configuration.setTheme(this.myTheme);
        }
        configuration.finishBulkEditing();
    }

    @Contract(value="!null, _ -> !null")
    @Nullable
    static State getState(@Nullable Device device, @Nullable String name) {
        State state;
        if (device == null) {
            return null;
        }
        if (name != null && (state = device.getState(name)) != null) {
            return state;
        }
        return device.getDefaultState();
    }
}

