/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repository.targets.PlatformTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.ConfigurationProjectState;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.android.tools.idea.configurations.ResourceResolverCache;
import com.android.tools.idea.model.ActivityAttributesSnapshot;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationManager
implements Disposable {
    private static final Key<ConfigurationManager> KEY = Key.create((String)ConfigurationManager.class.getName());
    @NotNull
    private final Module myModule;
    private final Map<VirtualFile, Configuration> myCache = ContainerUtil.createSoftValueMap();
    private final Object myLocalesLock = new Object();
    @GuardedBy(value="myLocalesLock")
    @NotNull
    private ImmutableList<Locale> myLocales = ImmutableList.of();
    @GuardedBy(value="myLocalesLock")
    private long myLocalesCacheStamp = -1L;
    private Device myDefaultDevice;
    private Locale myLocale;
    private IAndroidTarget myTarget;
    private int myStateVersion;
    private ResourceResolverCache myResolverCache;

    @NotNull
    public static ConfigurationManager getOrCreateInstance(@NotNull AndroidFacet androidFacet) {
        return ConfigurationManager.findConfigurationManager(androidFacet, true);
    }

    @NotNull
    public static ConfigurationManager getOrCreateInstance(@NotNull Module module) {
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet == null) {
            throw new IllegalArgumentException("Module '" + module.getName() + "' is not an Android module");
        }
        return ConfigurationManager.findConfigurationManager(androidFacet, true);
    }

    @Nullable
    public static ConfigurationManager findExistingInstance(@NotNull Module module) {
        AndroidFacet androidFacet = AndroidFacet.getInstance(module);
        if (androidFacet == null) {
            throw new IllegalArgumentException("Module '" + module.getName() + "' is not an Android module");
        }
        return ConfigurationManager.findConfigurationManager(androidFacet, false);
    }

    @Contract(value="_, true -> !null")
    @Nullable
    private static ConfigurationManager findConfigurationManager(@NotNull AndroidFacet androidFacet, boolean createIfNecessary) {
        Module module = androidFacet.getModule();
        ConfigurationManager configurationManager = (ConfigurationManager)module.getUserData(KEY);
        if (configurationManager == null && createIfNecessary) {
            configurationManager = new ConfigurationManager(module);
            module.putUserData(KEY, (Object)configurationManager);
        }
        return configurationManager;
    }

    public ConfigurationManager(@NotNull Module module) {
        this.myModule = module;
        Disposer.register((Disposable)this.myModule, (Disposable)this);
    }

    @Slow
    @NotNull
    public Configuration getConfiguration(@NotNull VirtualFile file) {
        Configuration configuration = this.myCache.get(file);
        if (configuration == null) {
            configuration = this.create(file);
            this.myCache.put(file, configuration);
        }
        return configuration;
    }

    boolean hasCachedConfiguration(@NotNull VirtualFile file) {
        return this.myCache.get(file) != null;
    }

    @Slow
    @NotNull
    private Configuration create(@NotNull VirtualFile file) {
        ConfigurationStateManager stateManager = this.getStateManager();
        ConfigurationFileState fileState = stateManager.getConfigurationState(file);
        assert (file.getParent() != null) : file;
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)file.getParent().getName());
        if (config == null) {
            config = new FolderConfiguration();
        }
        Configuration configuration = Configuration.create(this, file, fileState, config);
        ConfigurationMatcher matcher = new ConfigurationMatcher(configuration, file);
        if (fileState != null) {
            matcher.adaptConfigSelection(true);
        } else {
            matcher.findAndSetCompatibleConfig(false);
        }
        return configuration;
    }

    @NotNull
    public Configuration createSimilar(@NotNull VirtualFile file, @NotNull VirtualFile baseFile) {
        ConfigurationStateManager stateManager = this.getStateManager();
        ConfigurationFileState fileState = stateManager.getConfigurationState(baseFile);
        FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)file.getParent().getName());
        if (config == null) {
            config = new FolderConfiguration();
        }
        Configuration configuration = Configuration.create(this, file, fileState, config);
        Configuration baseConfig = this.myCache.get(file);
        if (baseConfig != null) {
            configuration.setEffectiveDevice(baseConfig.getDevice(), baseConfig.getDeviceState());
        }
        ConfigurationMatcher matcher = new ConfigurationMatcher(configuration, file);
        matcher.adaptConfigSelection(true);
        this.myCache.put(file, configuration);
        return configuration;
    }

    public ConfigurationStateManager getStateManager() {
        return ConfigurationStateManager.get(this.getModule().getProject());
    }

    @Slow
    @NotNull
    public ImmutableList<Device> getDevices() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.myModule);
        if (platform == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)platform.getSdkData().getDeviceManager().getDevices(DeviceManager.ALL_DEVICES));
    }

    @Nullable
    public Device getDeviceById(@NotNull String id) {
        return this.getDevices().stream().filter(device -> device.getId().equals(id)).findFirst().orElse(null);
    }

    @Nullable
    public Device createDeviceForAvd(@NotNull AvdInfo avd) {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.myModule);
        if (platform == null) {
            return null;
        }
        Device modelDevice = platform.getSdkData().getDeviceManager().getDevice(avd.getDeviceName(), avd.getDeviceManufacturer());
        if (modelDevice == null) {
            return null;
        }
        String avdName = avd.getName();
        Device.Builder builder = new Device.Builder(modelDevice);
        builder.setName(avdName);
        builder.setId("_android_virtual_device_id_" + avdName);
        return builder.build();
    }

    public static boolean isAvdDevice(@NotNull Device device) {
        return device.getId().startsWith("_android_virtual_device_id_");
    }

    @NotNull
    public IAndroidTarget[] getTargets() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.getModule());
        if (platform != null) {
            AndroidSdkData sdkData = platform.getSdkData();
            return sdkData.getTargets();
        }
        return new IAndroidTarget[0];
    }

    public static boolean isLayoutLibTarget(@NotNull IAndroidTarget target) {
        return target.isPlatform() && target.hasRenderingLibrary();
    }

    @Nullable
    public IAndroidTarget getHighestApiTarget() {
        IAndroidTarget[] targetList = this.getTargets();
        for (int i2 = targetList.length - 1; i2 >= 0; --i2) {
            IAndroidTarget target = targetList[i2];
            if (!ConfigurationManager.isLayoutLibTarget(target) || !ConfigurationManager.isLayoutLibSupported(target)) continue;
            return target;
        }
        return null;
    }

    private static boolean isLayoutLibSupported(IAndroidTarget target) {
        if (target instanceof PlatformTarget) {
            int layoutlibVersion = ((PlatformTarget)target).getLayoutlibApi();
            return layoutlibVersion <= 17;
        }
        return false;
    }

    @NotNull
    public String computePreferredTheme(@NotNull Configuration configuration) {
        MergedManifestSnapshot manifest = MergedManifestManager.getSnapshot(this.getModule());
        String activity = configuration.getActivity();
        if (activity != null) {
            String theme;
            ActivityAttributesSnapshot attributes;
            String activityFqcn = activity;
            if (activity.startsWith(".")) {
                String pkg = StringUtil.notNullize((String)manifest.getPackage());
                activityFqcn = pkg + activity;
            }
            if ((attributes = manifest.getActivityAttributes(activityFqcn)) != null && (theme = attributes.getTheme()) != null && theme.startsWith("@")) {
                return theme;
            }
            attributes = manifest.getActivityAttributes(activity);
            if (attributes != null && (theme = attributes.getTheme()) != null && theme.startsWith("@")) {
                return theme;
            }
        }
        return manifest.getDefaultTheme(configuration.getTarget(), configuration.getScreenSize(), configuration.getDevice());
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public Project getProject() {
        return this.getModule().getProject();
    }

    public void dispose() {
        this.getModule().putUserData(KEY, null);
    }

    @Nullable
    public Device getDefaultDevice() {
        ImmutableList<Device> devices;
        if (this.myDefaultDevice == null && !(devices = this.getDevices()).isEmpty()) {
            Device device = (Device)devices.get(0);
            for (Device d : devices) {
                String id = d.getId();
                if (id.equals("pixel")) {
                    device = d;
                    break;
                }
                if (!id.equals("Galaxy Nexus")) continue;
                device = d;
            }
            this.myDefaultDevice = device;
        }
        return this.myDefaultDevice;
    }

    @Nullable
    public IAndroidTarget getDefaultTarget() {
        return this.getHighestApiTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ImmutableList<Locale> getLocales() {
        LocalResourceRepository projectResources = ResourceRepositoryManager.getProjectResources(this.getModule());
        assert (projectResources != null);
        Object object = this.myLocalesLock;
        synchronized (object) {
            if (projectResources.getModificationCount() == this.myLocalesCacheStamp) {
                return this.myLocales;
            }
        }
        long modificationCount = projectResources.getModificationCount();
        ImmutableList locales = (ImmutableList)ResourceRepositoryUtil.getLocales((ResourceRepository)projectResources).stream().map(Locale::create).collect(ImmutableList.toImmutableList());
        Object object2 = this.myLocalesLock;
        synchronized (object2) {
            this.myLocales = locales;
            this.myLocalesCacheStamp = modificationCount;
            return this.myLocales;
        }
    }

    @Nullable
    public IAndroidTarget getProjectTarget() {
        AndroidPlatform platform = AndroidPlatform.getInstance(this.getModule());
        return platform != null ? platform.getTarget() : null;
    }

    @NotNull
    public Locale getLocale() {
        if (this.myLocale == null) {
            String localeString = this.getStateManager().getProjectState().getLocale();
            this.myLocale = localeString != null ? ConfigurationProjectState.fromLocaleString(localeString) : Locale.ANY;
        }
        return this.myLocale;
    }

    public void setLocale(@NotNull Locale locale) {
        if (!locale.equals(this.myLocale)) {
            this.myLocale = locale;
            ++this.myStateVersion;
            this.getStateManager().getProjectState().setLocale(ConfigurationProjectState.toLocaleString(locale));
            for (Configuration configuration : this.myCache.values()) {
                configuration.updated(16);
            }
        }
    }

    public List<Device> getRecentDevices() {
        List<String> deviceIds = this.getStateManager().getProjectState().getDeviceIds();
        if (deviceIds.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList devices = Lists.newArrayListWithExpectedSize((int)deviceIds.size());
        ListIterator<String> iterator = deviceIds.listIterator();
        while (iterator.hasNext()) {
            String id = iterator.next();
            Device device = this.getDeviceById(id);
            if (device != null) {
                devices.add(device);
                continue;
            }
            iterator.remove();
        }
        return devices;
    }

    public void selectDevice(@NotNull Device device) {
        String id = device.getId();
        List<String> deviceIds = this.getStateManager().getProjectState().getDeviceIds();
        deviceIds.remove(id);
        deviceIds.add(0, id);
        while (deviceIds.size() > 10) {
            deviceIds.remove(deviceIds.size() - 1);
        }
        ++this.myStateVersion;
        for (Configuration configuration : this.myCache.values()) {
            boolean updateTheme = false;
            String theme = configuration.getTheme();
            if (theme.startsWith("@android:style/")) {
                updateTheme = true;
                configuration.startBulkEditing();
                configuration.setTheme(null);
            }
            configuration.updated(2);
            if (!updateTheme) continue;
            configuration.finishBulkEditing();
        }
    }

    @Nullable
    public IAndroidTarget getTarget() {
        if (this.myTarget == null) {
            ConfigurationProjectState projectState = this.getStateManager().getProjectState();
            if (projectState.isPickTarget()) {
                this.myTarget = this.getDefaultTarget();
            } else {
                String targetString = projectState.getTarget();
                this.myTarget = ConfigurationProjectState.fromTargetString(this, targetString);
                if (this.myTarget == null) {
                    this.myTarget = this.getDefaultTarget();
                }
            }
            return this.myTarget;
        }
        return this.myTarget;
    }

    @Nullable
    public IAndroidTarget getTarget(int min) {
        IAndroidTarget target = this.getTarget();
        if (target != null && target.getVersion().getApiLevel() >= min) {
            return target;
        }
        IAndroidTarget[] targetList = this.getTargets();
        for (int i2 = targetList.length - 1; i2 >= 0; --i2) {
            target = targetList[i2];
            if (!ConfigurationManager.isLayoutLibTarget(target) || target.getVersion().getFeatureLevel() < min || !ConfigurationManager.isLayoutLibSupported(target)) continue;
            return target;
        }
        return null;
    }

    public void setTarget(@Nullable IAndroidTarget target) {
        if (target != this.myTarget) {
            AndroidTargetData targetData;
            if (this.myTarget != null && (targetData = AndroidTargetData.getTargetData(this.myTarget, this.getModule())) != null) {
                targetData.clearLayoutBitmapCache(this.getModule());
            }
            this.myTarget = target;
            if (target != null) {
                this.getStateManager().getProjectState().setTarget(ConfigurationProjectState.toTargetString(target));
                ++this.myStateVersion;
                for (Configuration configuration : this.myCache.values()) {
                    configuration.updated(32);
                }
            }
        }
    }

    public int getStateVersion() {
        return this.myStateVersion;
    }

    public ResourceResolverCache getResolverCache() {
        if (this.myResolverCache == null) {
            this.myResolverCache = new ResourceResolverCache(this);
        }
        return this.myResolverCache;
    }
}

