/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationProjectState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="AndroidLayouts", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ConfigurationStateManager
implements PersistentStateComponent<State> {
    private final Map<VirtualFile, ConfigurationFileState> myFileToState = new HashMap();
    private ConfigurationProjectState myProjectState = new ConfigurationProjectState();

    @NotNull
    public static ConfigurationStateManager get(@NotNull Project project) {
        return (ConfigurationStateManager)ServiceManager.getService((Project)project, ConfigurationStateManager.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ConfigurationFileState getConfigurationState(@NotNull VirtualFile file) {
        Map<VirtualFile, ConfigurationFileState> map2 = this.myFileToState;
        synchronized (map2) {
            return this.myFileToState.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigurationState(@NotNull VirtualFile file, @NotNull ConfigurationFileState state) {
        Map<VirtualFile, ConfigurationFileState> map2 = this.myFileToState;
        synchronized (map2) {
            this.myFileToState.put(file, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigurationState(@NotNull VirtualFile file) {
        Map<VirtualFile, ConfigurationFileState> map2 = this.myFileToState;
        synchronized (map2) {
            this.myFileToState.remove(file);
        }
    }

    @NotNull
    public ConfigurationProjectState getProjectState() {
        return this.myProjectState;
    }

    void setProjectState(@NotNull ConfigurationProjectState projectState) {
        this.myProjectState = projectState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        HashMap urlToState = new HashMap();
        Map<VirtualFile, ConfigurationFileState> map2 = this.myFileToState;
        synchronized (map2) {
            for (Map.Entry<VirtualFile, ConfigurationFileState> entry : this.myFileToState.entrySet()) {
                urlToState.put(entry.getKey().getUrl(), entry.getValue());
            }
        }
        State state = new State();
        state.setUrlToStateMap((Map<String, ConfigurationFileState>)urlToState);
        state.setProjectState(this.myProjectState);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull State state) {
        this.myProjectState = state.getProjectState();
        Map<VirtualFile, ConfigurationFileState> map2 = this.myFileToState;
        synchronized (map2) {
            this.myFileToState.clear();
            for (Map.Entry<String, ConfigurationFileState> entry : state.getUrlToStateMap().entrySet()) {
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(entry.getKey());
                if (file == null) continue;
                this.myFileToState.put(file, entry.getValue());
            }
        }
    }

    public static class State {
        private ConfigurationProjectState myProjectState;
        private Map<String, ConfigurationFileState> myUrlToStateMap = new HashMap();

        @Tag(value="shared")
        @Property(surroundWithTag=false)
        public ConfigurationProjectState getProjectState() {
            return this.myProjectState;
        }

        public void setProjectState(ConfigurationProjectState projectState) {
            this.myProjectState = projectState;
        }

        @XMap(propertyElementName="layouts", keyAttributeName="url", entryTagName="layout")
        public Map<String, ConfigurationFileState> getUrlToStateMap() {
            return this.myUrlToStateMap;
        }

        public void setUrlToStateMap(Map<String, ConfigurationFileState> urlToState) {
            this.myUrlToStateMap = urlToState;
        }
    }
}

