/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.DeviceGroup;
import com.android.tools.idea.configurations.DeviceUtils;
import com.android.tools.idea.device.DeviceArtPainter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.android.actions.RunAndroidAvdManagerAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceMenuAction
extends DropDownAction {
    private static final boolean LIST_RECENT_DEVICES = false;
    private final ConfigurationHolder myRenderContext;

    public DeviceMenuAction(@NotNull ConfigurationHolder renderContext) {
        super("", "Device for Preview", StudioIcons.LayoutEditor.Toolbar.VIRTUAL_DEVICES);
        this.myRenderContext = renderContext;
        Presentation presentation = this.getTemplatePresentation();
        this.updatePresentation(presentation);
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            Device device = configuration.getDevice();
            String label = DeviceMenuAction.getDeviceLabel(device, true);
            presentation.setText(label, false);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    public void nextDevice(AnActionEvent e) {
        Configuration config = this.myRenderContext.getConfiguration();
        if (config == null) {
            return;
        }
        Device current = config.getDevice();
        if (current == null) {
            return;
        }
        AnAction[] action2 = this.getChildren(null);
        List actions2 = Arrays.stream(action2).filter(a -> a instanceof DeviceAction).map(a -> (DeviceAction)a).collect(Collectors.toList());
        Optional<DeviceAction> currentActions = actions2.stream().filter(a -> a.getDevice() == current).findFirst();
        if (currentActions.isPresent()) {
            int index = actions2.indexOf(currentActions.get());
            DeviceAction nextAction = (DeviceAction)actions2.get((index + 1) % actions2.size());
            nextAction.actionPerformed(e);
        }
    }

    public static String getDeviceLabel(@Nullable Device device, boolean brief) {
        if (device == null) {
            return "";
        }
        String name = device.getDisplayName();
        if (brief) {
            int end;
            int begin;
            int nexus = name.indexOf("Nexus");
            if (nexus != -1 && (begin = name.indexOf(40)) != -1 && (end = name.indexOf(41, ++begin)) != -1) {
                if (name.equals("Nexus 7 (2012)")) {
                    return "Nexus 7";
                }
                return name.substring(begin, end).trim();
            }
            String skipPrefix = "Android ";
            name = StringUtil.trimStart((String)name, (String)skipPrefix);
        }
        return name;
    }

    private static Icon getDeviceClassIcon(@Nullable Device device) {
        if (device != null) {
            if (HardwareConfigHelper.isWear((Device)device)) {
                return StudioIcons.LayoutEditor.Toolbar.DEVICE_WEAR;
            }
            if (HardwareConfigHelper.isTv((Device)device)) {
                return StudioIcons.LayoutEditor.Toolbar.DEVICE_TV;
            }
            if (DeviceArtPainter.isTablet((Device)device)) {
                return StudioIcons.LayoutEditor.Toolbar.DEVICE_TABLET;
            }
        }
        return StudioIcons.LayoutEditor.Toolbar.DEVICE_PHONE;
    }

    protected boolean hasDropDownArrow() {
        return this.myRenderContext.getConfiguration() != null;
    }

    protected boolean updateActions() {
        this.removeAll();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return true;
        }
        Device current = configuration.getDevice();
        ConfigurationManager configurationManager = configuration.getConfigurationManager();
        Map<DeviceGroup, List<Device>> groupedDevices = DeviceUtils.getSuitableDevices(configuration);
        this.addDeviceSection(groupedDevices, DeviceGroup.NEXUS_XL, current);
        this.addDeviceSection(groupedDevices, DeviceGroup.NEXUS_TABLET, current);
        this.addDeviceSection(groupedDevices, DeviceGroup.WEAR, current);
        this.addDeviceSection(groupedDevices, DeviceGroup.TV, current);
        this.addCustomDeviceSection(current);
        this.addAvdDeviceSection(DeviceUtils.getAvdDevices(configuration), current);
        this.addGenericDeviceSection(groupedDevices.getOrDefault((Object)DeviceGroup.GENERIC, Collections.emptyList()), current);
        this.add((AnAction)new RunAndroidAvdManagerAction("Add Device Definition..."));
        return true;
    }

    private void addDeviceSection(@NotNull Map<DeviceGroup, List<Device>> groupedDevices, @NotNull DeviceGroup group, @Nullable Device current) {
        List devices = groupedDevices.getOrDefault((Object)group, Collections.emptyList());
        if (!devices.isEmpty()) {
            this.add(new DeviceCategory(DeviceMenuAction.getGroupTitle(group), null, DeviceMenuAction.getDeviceClassIcon((Device)devices.get(0))));
            for (Device device : devices) {
                String label = this.getLabel(device, HardwareConfigHelper.isNexus((Device)device));
                this.add(new SetDeviceAction(this.myRenderContext, label, device, null, current == device));
            }
            this.addSeparator();
        }
    }

    @NotNull
    private static String getGroupTitle(@NotNull DeviceGroup group) {
        switch (group) {
            case NEXUS: 
            case NEXUS_XL: {
                return "Phone";
            }
            case NEXUS_TABLET: {
                return "Tablet";
            }
            case WEAR: {
                return "Wear";
            }
            case TV: {
                return "TV";
            }
            case GENERIC: {
                return "Generic";
            }
            case OTHER: {
                return "Other";
            }
        }
        return "Device";
    }

    private void addCustomDeviceSection(@Nullable Device currentDevice) {
        this.add(new SetCustomDeviceAction(this.myRenderContext, currentDevice));
        this.addSeparator();
    }

    private void addAvdDeviceSection(@NotNull List<Device> devices, @Nullable Device current) {
        if (!devices.isEmpty()) {
            this.add(new DeviceCategory("Virtual Device", null, StudioIcons.LayoutEditor.Toolbar.VIRTUAL_DEVICES));
            for (Device device : devices) {
                boolean selected = current != null && current.getId().equals(device.getId());
                String avdDisplayName = "AVD: " + device.getDisplayName();
                this.add(new SetAvdAction(this.myRenderContext, device, avdDisplayName, selected));
            }
            this.addSeparator();
        }
    }

    private void addGenericDeviceSection(@NotNull List<Device> devices, @Nullable Device current) {
        if (!devices.isEmpty()) {
            DefaultActionGroup genericGroup = new DefaultActionGroup("_Generic Phones and Tablets", true);
            for (Device device : devices) {
                String label = this.getLabel(device, HardwareConfigHelper.isNexus((Device)device));
                genericGroup.add((AnAction)new SetDeviceAction(this.myRenderContext, label, device, null, current == device));
            }
            this.add((AnAction)genericGroup);
        }
    }

    private String getLabel(Device device, boolean isNexus) {
        VirtualFile better;
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && (better = ConfigurationMatcher.getBetterMatch(configuration, device, null, null, null)) != null) {
            return ConfigurationAction.getBetterMatchLabel(device.getDisplayName(), better, configuration.getFile());
        }
        return isNexus ? HardwareConfigHelper.getNexusMenuLabel((Device)device) : HardwareConfigHelper.getGenericLabel((Device)device);
    }

    private class SetAvdAction
    extends ConfigurationAction {
        @NotNull
        private final Device myAvdDevice;

        public SetAvdAction(@NotNull ConfigurationHolder renderContext, @NotNull Device avdDevice, String displayName, boolean select2) {
            super(renderContext, displayName);
            this.myAvdDevice = avdDevice;
            this.getTemplatePresentation().putClientProperty("selected", (Object)select2);
        }

        @Override
        protected void updatePresentation(@NotNull Presentation presentation) {
            DeviceMenuAction.this.updatePresentation(presentation);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            configuration.setEffectiveDevice(this.myAvdDevice, this.myAvdDevice.getDefaultState());
        }
    }

    private class SetCustomDeviceAction
    extends DeviceAction {
        private static final String CUSTOM_DEVICE_NAME = "Custom";
        @Nullable
        private final Device myDevice;
        @Nullable
        private Device myCustomDevice;

        public SetCustomDeviceAction(@Nullable ConfigurationHolder renderContext, Device device) {
            super(renderContext, CUSTOM_DEVICE_NAME);
            this.myDevice = device;
            if (this.myDevice != null && CUSTOM_DEVICE_NAME.equals(this.myDevice.getId())) {
                this.getTemplatePresentation().putClientProperty("selected", (Object)true);
            }
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (this.myDevice != null) {
                Device.Builder customBuilder = new Device.Builder(this.myDevice);
                customBuilder.setTagId(this.myDevice.getTagId());
                customBuilder.setName(CUSTOM_DEVICE_NAME);
                customBuilder.setId(CUSTOM_DEVICE_NAME);
                this.myCustomDevice = customBuilder.build();
                configuration.setEffectiveDevice(this.myCustomDevice, this.myDevice.getDefaultState());
            }
        }

        @Override
        @Nullable
        public Device getDevice() {
            return this.myCustomDevice;
        }
    }

    private class SetDeviceAction
    extends DeviceAction {
        private final Device myDevice;

        public SetDeviceAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @Nullable Device device, Icon defaultIcon, boolean select2) {
            super(renderContext, null);
            this.myDevice = device;
            this.getTemplatePresentation().setText(title, false);
            if (select2) {
                this.getTemplatePresentation().putClientProperty("selected", (Object)true);
            } else if (ConfigurationAction.isBetterMatchLabel(title)) {
                this.getTemplatePresentation().setIcon(ConfigurationAction.getBetterMatchIcon());
            } else if (defaultIcon != null) {
                this.getTemplatePresentation().setIcon(defaultIcon);
            }
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            String name;
            VirtualFile file;
            String newState;
            Device prevDevice = configuration.getDevice();
            State prevState = configuration.getDeviceState();
            String string = newState = prevState != null ? prevState.getName() : null;
            if (prevDevice != null && prevState != null && prevState.isDefaultState() && !this.myDevice.getDefaultState().getName().equals(prevState.getName()) && configuration.getEditedConfig().getScreenOrientationQualifier() == null && (file = configuration.getFile()) != null && ConfigurationMatcher.getBetterMatch(configuration, this.myDevice, name = this.myDevice.getDefaultState().getName(), null, null) == null) {
                newState = name;
            }
            if (newState != null) {
                configuration.setDeviceStateName(newState);
            }
            if (commit) {
                configuration.getConfigurationManager().selectDevice(this.myDevice);
            } else {
                configuration.setDevice(this.myDevice, true);
            }
        }

        @Override
        @NotNull
        public Device getDevice() {
            return this.myDevice;
        }
    }

    protected abstract class DeviceAction
    extends ConfigurationAction {
        DeviceAction(@Nullable ConfigurationHolder renderContext, String title) {
            super(renderContext, title);
        }

        @Override
        protected final void updatePresentation(@NotNull Presentation presentation) {
            DeviceMenuAction.this.updatePresentation(presentation);
        }

        @Nullable
        public abstract Device getDevice();
    }

    private static final class DeviceCategory
    extends AnAction {
        private Icon myIcon;

        public DeviceCategory(@Nullable String text, @Nullable String description, @Nullable Icon icon2) {
            super(text, description, null);
            this.myIcon = icon2;
            Presentation p = this.getTemplatePresentation();
            p.setDisabledIcon(this.myIcon);
            p.setEnabled(false);
        }

        public void actionPerformed(AnActionEvent e) {
        }
    }
}

