/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.resources.Density;
import com.android.resources.NightMode;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.NestedConfiguration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.Locale;
import com.google.common.collect.ImmutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaryingConfiguration
extends NestedConfiguration {
    private int myVariation;
    private int myVariationCount;
    private int myAlternate;
    private Device myPrevParentDevice;
    private Device myPrevDevice;

    private VaryingConfiguration(@NotNull Configuration configuration) {
        super(configuration);
    }

    @NotNull
    public static VaryingConfiguration create(@NotNull Configuration parent) {
        return new VaryingConfiguration(parent);
    }

    @NotNull
    public static VaryingConfiguration create(@NotNull VaryingConfiguration other, @NotNull Configuration parent) {
        VaryingConfiguration configuration = new VaryingConfiguration(parent);
        configuration.startBulkEditing();
        VaryingConfiguration.initFrom(configuration, other, other);
        configuration.myAlternate = other.myAlternate;
        configuration.myVariation = other.myVariation;
        configuration.myVariationCount = other.myVariationCount;
        configuration.finishBulkEditing();
        return configuration;
    }

    public int getAlternateFlags() {
        return this.myAlternate;
    }

    @Override
    protected void syncFolderConfig() {
        super.syncFolderConfig();
        this.updateDisplayName();
    }

    public void setVariation(int variation) {
        this.myVariation = variation;
        this.myVariationCount = Math.max(this.myVariationCount, variation + 1);
    }

    public void setVariationCount(int count) {
        this.myVariationCount = count;
    }

    public void updateDisplayName() {
        this.setDisplayName(this.computeDisplayName());
    }

    @Override
    @NotNull
    public Locale getLocale() {
        if (this.isOverridingLocale()) {
            return super.getLocale();
        }
        Locale locale = this.myParent.getLocale();
        if (this.isAlternatingLocale()) {
            ImmutableList<Locale> locales = this.getConfigurationManager().getLocales();
            for (Locale l : locales) {
                if (l.equals(locale)) continue;
                locale = l;
                break;
            }
        }
        return locale;
    }

    @Override
    @Nullable
    public IAndroidTarget getTarget() {
        ConfigurationManager manager;
        IAndroidTarget[] targets;
        if (this.isOverridingTarget()) {
            return super.getTarget();
        }
        IAndroidTarget target = this.myParent.getTarget();
        if (this.isAlternatingTarget() && target != null && (targets = (manager = this.getConfigurationManager()).getTargets()).length > 0) {
            IAndroidTarget mostRecent = manager.getHighestApiTarget();
            if (target.equals(mostRecent)) {
                AndroidModuleInfo info = AndroidModuleInfo.getInstance(manager.getModule());
                if (info != null) {
                    int minSdkVersion2 = info.getMinSdkVersion().getFeatureLevel();
                    for (IAndroidTarget t : targets) {
                        if (t.getVersion().getFeatureLevel() < minSdkVersion2 || !ConfigurationManager.isLayoutLibTarget(t)) continue;
                        target = t;
                        break;
                    }
                }
            } else {
                target = mostRecent;
            }
        }
        return target;
    }

    @Override
    @Nullable
    public Device getDevice() {
        if (this.isOverridingDevice()) {
            return super.getDevice();
        }
        Device device = this.myParent.getDevice();
        if (this.isAlternatingDevice() && device != null) {
            if (device == this.myPrevParentDevice) {
                return this.myPrevDevice;
            }
            this.myPrevParentDevice = device;
            ImmutableList<Device> devices = this.getConfigurationManager().getDevices();
            boolean isTv = HardwareConfigHelper.isTv((Device)device);
            boolean isWear = HardwareConfigHelper.isWear((Device)device);
            double smallest = 100.0;
            double biggest = 1.0;
            for (Device d : devices) {
                double size = VaryingConfiguration.getScreenSize(d);
                if (size < 0.0 || isTv != HardwareConfigHelper.isTv((Device)d) || isWear != HardwareConfigHelper.isWear((Device)d)) continue;
                if (size >= biggest) {
                    biggest = size;
                }
                if (!(size <= smallest)) continue;
                smallest = size;
            }
            int bucketCount = this.myVariationCount + 1;
            double inchesPerBucket = (biggest - smallest) / (double)bucketCount;
            double overriddenSize = VaryingConfiguration.getScreenSize(device);
            int overriddenBucket = (int)((overriddenSize - smallest) / inchesPerBucket);
            int bucket = this.myVariation < overriddenBucket ? this.myVariation : this.myVariation + 1;
            double from = inchesPerBucket * (double)bucket + smallest;
            double to = from + inchesPerBucket;
            if (biggest - to < 0.1) {
                to = biggest + 0.1;
            }
            boolean canScaleNinePatch = this.supports(10);
            for (Device d : devices) {
                Density density;
                double size;
                if (isTv != HardwareConfigHelper.isTv((Device)d) || isWear != HardwareConfigHelper.isWear((Device)d) || !((size = VaryingConfiguration.getScreenSize(d)) >= from) || !(size < to) || !canScaleNinePatch && ((density = VaryingConfiguration.getDensity(d)) == null || !density.isRecommended() || density == Density.LOW)) continue;
                device = d;
                break;
            }
            this.myPrevDevice = device;
        }
        return device;
    }

    @Nullable
    private static Density getDensity(@NotNull Device device) {
        Hardware hardware = device.getDefaultHardware();
        Screen screen = hardware.getScreen();
        if (screen != null) {
            return screen.getPixelDensity();
        }
        return null;
    }

    private static double getScreenSize(@NotNull Device device) {
        Hardware hardware = device.getDefaultHardware();
        Screen screen = hardware.getScreen();
        if (screen != null) {
            return screen.getDiagonalLength();
        }
        return -1.0;
    }

    @Override
    @Nullable
    public State getDeviceState() {
        Device device;
        if (this.isOverridingDeviceState()) {
            return super.getDeviceState();
        }
        State state = this.myParent.getDeviceState();
        if (this.isAlternatingDeviceState() && state != null) {
            State next = this.getNextDeviceState(state);
            if (next != null) {
                return next;
            }
            return state;
        }
        if ((this.isAlternatingDevice() || this.isOverridingDevice()) && state != null && (device = this.getDevice()) != null) {
            return device.getState(state.getName());
        }
        return state;
    }

    @Override
    @NotNull
    public NightMode getNightMode() {
        if (this.isOverridingNightMode()) {
            return super.getNightMode();
        }
        NightMode nightMode = this.myParent.getNightMode();
        if (this.isAlternatingNightMode()) {
            nightMode = nightMode == NightMode.NIGHT ? NightMode.NOTNIGHT : NightMode.NIGHT;
        }
        return nightMode;
    }

    @Override
    @NotNull
    public UiMode getUiMode() {
        if (this.isOverridingUiMode()) {
            return super.getUiMode();
        }
        UiMode uiMode = this.myParent.getUiMode();
        if (this.isAlternatingUiMode()) {
            UiMode[] values = UiMode.values();
            uiMode = values[(uiMode.ordinal() + 1) % values.length];
        }
        return uiMode;
    }

    @Override
    @Nullable
    public String computeDisplayName() {
        return VaryingConfiguration.computeDisplayName(this.getOverrideFlags() | this.myAlternate, this);
    }

    public void setAlternateLocale(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x10) : (this.myAlternate &= 0xFFFFFFEF);
    }

    public final boolean isAlternatingLocale() {
        return (this.myAlternate & 0x10) != 0;
    }

    public void setAlternateTarget(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x20) : (this.myAlternate &= 0xFFFFFFDF);
    }

    public final boolean isAlternatingTarget() {
        return (this.myAlternate & 0x20) != 0;
    }

    public void setAlternateDevice(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 2) : (this.myAlternate &= 0xFFFFFFFD);
    }

    public final boolean isAlternatingDevice() {
        return (this.myAlternate & 2) != 0;
    }

    public void setAlternateDeviceState(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 4) : (this.myAlternate &= 0xFFFFFFFB);
    }

    public final boolean isAlternatingDeviceState() {
        return (this.myAlternate & 4) != 0;
    }

    public void setAlternateNightMode(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x40) : (this.myAlternate &= 0xFFFFFFBF);
    }

    public final boolean isAlternatingNightMode() {
        return (this.myAlternate & 0x40) != 0;
    }

    public void setAlternateUiMode(boolean alternate) {
        this.myAlternate = alternate ? (this.myAlternate |= 0x80) : (this.myAlternate &= 0xFFFFFF7F);
    }

    public final boolean isAlternatingUiMode() {
        return (this.myAlternate & 0x80) != 0;
    }

    @Override
    public boolean changed(int flags) {
        this.updated(flags);
        return true;
    }
}

