/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.connection.assistant.actions;

import com.android.ddmlib.AdbDevice;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.connection.assistant.actions.ConnectionAssistantSection;
import com.android.tools.idea.connection.assistant.actions.DeviceCrossReference;
import com.android.tools.idea.connection.assistant.actions.DeviceSummary;
import com.android.tools.idea.connection.assistant.actions.DeviceSummaryKt$WhenMappings;
import com.android.tools.usb.UsbDevice;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0004"}, d2={"summarize", "Lcom/android/tools/idea/connection/assistant/actions/DeviceSummary;", "crossReference", "Lcom/android/tools/idea/connection/assistant/actions/DeviceCrossReference;", "connection-assistant"})
public final class DeviceSummaryKt {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final DeviceSummary summarize(@NotNull DeviceCrossReference crossReference) {
        String string;
        IDevice device = (IDevice)CollectionsKt.firstOrNull(crossReference.getDdmsDevices());
        String label = null;
        if (device != null) {
            string = device.getName();
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            label = string2;
        } else if (!crossReference.getAdbDevice().isEmpty()) {
            string = ((AdbDevice)CollectionsKt.first(crossReference.getAdbDevice())).getSerial();
            String string3 = string;
            if (string3 == null) {
                string3 = "";
            }
            label = string3;
        } else {
            label = !crossReference.getUsbDevice().isEmpty() ? ((UsbDevice)CollectionsKt.first(crossReference.getUsbDevice())).getName() : "Unknown device";
        }
        ConnectionAssistantSection section = null;
        String errorMessage = null;
        if (device != null) {
            IDevice.DeviceState devState = device.getState();
            AdbDevice adbDevice = (AdbDevice)CollectionsKt.firstOrNull(crossReference.getAdbDevice());
            if (adbDevice != null && adbDevice.getState() != devState) {
                section = ConnectionAssistantSection.POSSIBLE_PROBLEM;
                StringBuilder stringBuilder = new StringBuilder().append("ADB reports that the device is in the '");
                Object object = adbDevice.getState();
                if (object == null || (object = object.getState()) == null) {
                    object = "unknown";
                }
                StringBuilder stringBuilder2 = stringBuilder.append((String)object).append("' state but Android Studio reports").append(" that it is in the '");
                Object object2 = devState;
                if (object2 == null || (object2 = object2.getState()) == null) {
                    object2 = "unknown";
                }
                errorMessage = stringBuilder2.append((String)object2).append("' state").toString();
                return new DeviceSummary(label, device, section, errorMessage);
            }
            IDevice.DeviceState deviceState = devState;
            if (deviceState != null) {
                switch (DeviceSummaryKt$WhenMappings.$EnumSwitchMapping$0[deviceState.ordinal()]) {
                    case 1: {
                        section = ConnectionAssistantSection.WORKING;
                        return new DeviceSummary(label, device, section, errorMessage);
                    }
                    case 2: {
                        section = ConnectionAssistantSection.POSSIBLE_PROBLEM;
                        errorMessage = "Device is waiting for you to grant permission for USB debugging";
                        return new DeviceSummary(label, device, section, errorMessage);
                    }
                }
            }
            section = ConnectionAssistantSection.POSSIBLE_PROBLEM;
            StringBuilder stringBuilder = new StringBuilder().append("Device is currently in the ");
            Object object = device.getState();
            if (object == null || (object = object.getState()) == null) {
                object = "unknown";
            }
            errorMessage = stringBuilder.append((String)object).append(" state").toString();
            return new DeviceSummary(label, device, section, errorMessage);
        }
        if (!crossReference.getAdbDevice().isEmpty()) {
            section = ConnectionAssistantSection.POSSIBLE_PROBLEM;
            errorMessage = "Device was detected by ADB but not Android Studio.";
            return new DeviceSummary(label, device, section, errorMessage);
        }
        section = ConnectionAssistantSection.OTHER_USB;
        return new DeviceSummary(label, device, section, errorMessage);
    }
}

