/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BrUtil {
    @NotNull
    private static Logger getLog() {
        return Logger.getInstance(BrUtil.class);
    }

    @NotNull
    public static Set<String> collectIds(@NotNull Collection<? extends PsiModifierListOwner> psiElements) {
        HashSet<String> properties = new HashSet<String>();
        for (PsiModifierListOwner psiModifierListOwner : psiElements) {
            String key = null;
            if (psiModifierListOwner instanceof PsiField) {
                key = BrUtil.stripPrefixFromField((PsiField)psiModifierListOwner);
            } else if (psiModifierListOwner instanceof PsiMethod) {
                key = BrUtil.stripPrefixFromMethod((PsiMethod)psiModifierListOwner);
            }
            if (key == null) continue;
            properties.add(key);
        }
        return properties;
    }

    @Nullable
    private static String stripPrefixFromMethod(@NotNull PsiMethod psiMethod) {
        CharSequence propertyName;
        String name = psiMethod.getName();
        if (BrUtil.isGetter(psiMethod) || BrUtil.isSetter(psiMethod)) {
            propertyName = name.subSequence(3, name.length());
        } else if (BrUtil.isBooleanGetter(psiMethod)) {
            propertyName = name.subSequence(2, name.length());
        } else {
            BrUtil.getLog().warn("@Bindable associated with a method must follow JavaBeans convention: " + psiMethod.getName());
            return null;
        }
        char firstChar = propertyName.charAt(0);
        return String.valueOf(Character.toLowerCase(firstChar)) + propertyName.subSequence(1, propertyName.length());
    }

    public static boolean isGetter(@NotNull PsiMethod psiMethod) {
        return BrUtil.matchesMethodPattern(psiMethod, "get", 0, type -> !PsiType.VOID.equals(type));
    }

    public static boolean isBooleanGetter(@NotNull PsiMethod psiMethod) {
        return BrUtil.matchesMethodPattern(psiMethod, "is", 0, type -> PsiType.BOOLEAN.equals(type));
    }

    public static boolean isSetter(@NotNull PsiMethod psiMethod) {
        return BrUtil.matchesMethodPattern(psiMethod, "set", 1, type -> PsiType.VOID.equals(type));
    }

    private static boolean matchesMethodPattern(@NotNull PsiMethod psiMethod, @NotNull String prefix, int parameterCount, @NotNull Predicate<PsiType> returnTypePredicate) {
        String name = psiMethod.getName();
        return BrUtil.isPrefix(name, prefix) && Character.isJavaIdentifierStart(name.charAt(prefix.length())) && psiMethod.getParameterList().getParametersCount() == parameterCount && returnTypePredicate.test(psiMethod.getReturnType());
    }

    @NotNull
    private static String stripPrefixFromField(@NotNull PsiField psiField) {
        String fieldName = psiField.getName();
        assert (fieldName != null);
        return BrUtil.stripPrefixFromField(fieldName);
    }

    private static boolean isPrefix(@NotNull CharSequence sequence, @NotNull String prefix) {
        boolean prefixes = false;
        if (sequence.length() > prefix.length()) {
            int count = prefix.length();
            prefixes = true;
            for (int i2 = 0; i2 < count; ++i2) {
                if (sequence.charAt(i2) == prefix.charAt(i2)) continue;
                prefixes = false;
                break;
            }
        }
        return prefixes;
    }

    @NotNull
    private static String stripPrefixFromField(@NotNull String name) {
        if (name.length() >= 2) {
            char firstChar = name.charAt(0);
            char secondChar = name.charAt(1);
            if (name.length() > 2 && firstChar == 'm' && secondChar == '_') {
                char thirdChar = name.charAt(2);
                if (Character.isJavaIdentifierStart(thirdChar)) {
                    return String.valueOf(Character.toLowerCase(thirdChar)) + name.subSequence(3, name.length());
                }
            } else if (firstChar == 'm' && Character.isUpperCase(secondChar) || firstChar == '_' && Character.isJavaIdentifierStart(secondChar)) {
                return String.valueOf(Character.toLowerCase(secondChar)) + name.subSequence(2, name.length());
            }
        }
        return name;
    }
}

