/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.databinding.DataBindingSupport;
import com.android.tools.idea.lang.databinding.DataBindingExpressionSupport;
import com.android.tools.idea.lang.databinding.DataBindingExpressionUtil;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.res.DataBindingLayoutInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.List;
import org.jetbrains.android.dom.layout.Import;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataBindingUtil {
    public static final String BR = "BR";
    private static List<String> VIEW_PACKAGE_ELEMENTS = ImmutableList.of((Object)"View", (Object)"ViewGroup", (Object)"TextureView", (Object)"SurfaceView");

    @Nullable
    static DataBindingSupport getDataBindingSupport() {
        List extensionList = DataBindingSupport.EP_NAME.getExtensionList();
        return extensionList.isEmpty() ? null : (DataBindingSupport)extensionList.get(0);
    }

    public static boolean isDataBindingEnabled(@NotNull AndroidFacet facet) {
        return DataBindingUtil.getDataBindingMode(facet) != DataBindingMode.NONE;
    }

    @NotNull
    public static DataBindingMode getDataBindingMode(@NotNull AndroidFacet facet) {
        DataBindingSupport support = DataBindingUtil.getDataBindingSupport();
        return support == null ? DataBindingMode.NONE : support.getDataBindingMode(facet);
    }

    @NotNull
    public static ModificationTracker getDataBindingEnabledTracker() {
        DataBindingSupport support = DataBindingUtil.getDataBindingSupport();
        return support == null ? () -> 0L : support.getDataBindingEnabledTracker();
    }

    @Nullable
    public static PsiType parsePsiType(@NotNull String typeStr, @NotNull AndroidFacet facet, @Nullable PsiElement context) {
        return DataBindingUtil.parsePsiType(typeStr, facet.getModule().getProject(), context);
    }

    @Nullable
    public static PsiType parsePsiType(@NotNull String typeStr, @NotNull Project project, @Nullable PsiElement context) {
        PsiElementFactory instance = PsiElementFactory.SERVICE.getInstance((Project)project);
        try {
            PsiType type = instance.createTypeFromText(typeStr, context);
            if (type instanceof PsiClassReferenceType && ((PsiClassReferenceType)type).getClassName() == null) {
                return null;
            }
            return type;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    public static PsiType resolveViewPsiType(@NotNull DataBindingLayoutInfo.ViewWithId viewWithId, @NotNull AndroidFacet facet) {
        String viewClassName = DataBindingUtil.getViewClassName(viewWithId.tag, facet);
        if (StringUtil.isNotEmpty((String)viewClassName)) {
            return DataBindingUtil.parsePsiType(viewClassName, facet, null);
        }
        return null;
    }

    @Nullable
    private static String getViewClassName(@NotNull XmlTag tag, @NotNull AndroidFacet facet) {
        String elementName = DataBindingUtil.getViewName(tag);
        if (elementName != null && elementName.indexOf(46) == -1) {
            if (VIEW_PACKAGE_ELEMENTS.contains(elementName)) {
                return "android.view." + elementName;
            }
            if ("WebView".equals(elementName)) {
                return "android.webkit." + elementName;
            }
            if ("merge".equals(elementName)) {
                return DataBindingUtil.getViewClassNameFromMergeTag(tag, facet);
            }
            if ("include".equals(elementName)) {
                return DataBindingUtil.getViewClassNameFromIncludeTag(tag, facet);
            }
            if ("ViewStub".equals(elementName)) {
                DataBindingMode mode = DataBindingUtil.getDataBindingMode(facet);
                return mode.viewStubProxy;
            }
            return "android.widget." + elementName;
        }
        return elementName;
    }

    @NotNull
    private static String getViewClassNameFromIncludeTag(@NotNull XmlTag tag, @NotNull AndroidFacet facet) {
        String reference2 = DataBindingUtil.getViewClassNameFromLayoutAttribute(tag, facet);
        return reference2 == null ? "android.view.View" : reference2;
    }

    @Nullable
    private static String getViewClassNameFromMergeTag(@NotNull XmlTag tag, @NotNull AndroidFacet facet) {
        return DataBindingUtil.getViewClassNameFromLayoutAttribute(tag, facet);
    }

    @Nullable
    private static String getViewClassNameFromLayoutAttribute(@NotNull XmlTag tag, @NotNull AndroidFacet facet) {
        String layout2 = tag.getAttributeValue("layout");
        if (layout2 == null) {
            return null;
        }
        LocalResourceRepository moduleResources = ResourceRepositoryManager.getInstance(facet).getExistingAppResources();
        if (moduleResources == null) {
            return null;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)layout2);
        if (resourceUrl == null || resourceUrl.type != ResourceType.LAYOUT) {
            return null;
        }
        DataBindingLayoutInfo info = moduleResources.getDataBindingLayoutInfo(resourceUrl.name);
        if (info == null) {
            return null;
        }
        return info.getQualifiedName();
    }

    @Nullable
    private static String getViewName(@NotNull XmlTag tag) {
        String viewName = tag.getName();
        if ("view".equals(viewName)) {
            viewName = tag.getAttributeValue("class", "http://schemas.android.com/apk/res/android");
        }
        return viewName;
    }

    @NotNull
    public static String convertToJavaClassName(@NotNull String name) {
        int dotIndex = name.indexOf(46);
        if (dotIndex >= 0) {
            name = name.substring(0, dotIndex);
        }
        String[] split = name.split("[_-]");
        StringBuilder out = new StringBuilder();
        for (String section : split) {
            out.append(StringUtil.capitalize((String)section));
        }
        return out.toString();
    }

    @NotNull
    public static String convertToJavaFieldName(@NotNull String name) {
        int dotIndex = name.indexOf(46);
        if (dotIndex >= 0) {
            name = name.substring(0, dotIndex);
        }
        String[] split = name.split("[_-]");
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (String section : split) {
            if (first) {
                first = false;
                out.append(section);
                continue;
            }
            out.append(StringUtil.capitalize((String)section));
        }
        return out.toString();
    }

    @NotNull
    public static String getBrQualifiedName(@NotNull AndroidFacet facet) {
        return DataBindingUtil.getGeneratedPackageName(facet) + "." + BR;
    }

    @Nullable
    public static String getGeneratedPackageName(@NotNull AndroidFacet facet) {
        return MergedManifestManager.getSnapshot(facet).getPackage();
    }

    @Nullable
    public static String getBindingExprDefault(@NotNull XmlAttribute psiAttribute) {
        DataBindingExpressionSupport expressionSupport = DataBindingExpressionUtil.getDataBindingExpressionSupport();
        if (expressionSupport != null) {
            return expressionSupport.getBindingExprDefault(psiAttribute);
        }
        return null;
    }

    @Nullable
    public static String getBindingExprDefault(@NotNull String expression) {
        DataBindingExpressionSupport expressionSupport = DataBindingExpressionUtil.getDataBindingExpressionSupport();
        if (expressionSupport != null) {
            return expressionSupport.getBindingExprDefault(expression);
        }
        return null;
    }

    public static boolean isBindingExpression(@NotNull String string) {
        return string.startsWith("@{") || string.startsWith("@={");
    }

    @Nullable
    public static String getAlias(@NotNull Import anImport) {
        XmlAttributeValue value2;
        GenericAttributeValue<PsiElement> type;
        String aliasValue = null;
        String typeValue = null;
        GenericAttributeValue<String> alias = anImport.getAlias();
        if (alias != null && alias.getXmlAttributeValue() != null) {
            aliasValue = alias.getXmlAttributeValue().getValue();
        }
        if ((type = anImport.getType()) != null && (value2 = type.getXmlAttributeValue()) != null) {
            typeValue = value2.getValue();
        }
        return DataBindingUtil.getAlias(typeValue, aliasValue);
    }

    @Nullable
    public static String getAlias(@NotNull PsiDataBindingResourceItem anImport) {
        return DataBindingUtil.getAlias(anImport.getTypeDeclaration(), anImport.getExtra("alias"));
    }

    @Nullable
    private static String getAlias(@Nullable String type, @Nullable String alias) {
        int d;
        if (alias != null || type == null) {
            return alias;
        }
        int i2 = type.lastIndexOf(46);
        int n = i2 = i2 > (d = type.lastIndexOf(36)) ? i2 : d;
        if (i2 < 0) {
            return type;
        }
        return type.length() > i2 + 1 ? type.substring(i2 + 1) : null;
    }

    @Nullable
    public static String getQualifiedType(final @Nullable String nameOrAlias, final @Nullable DataBindingLayoutInfo dataBindingLayoutInfo, final boolean qualifyJavaLang) {
        class UnresolvedClassNameException
        extends RuntimeException {
            UnresolvedClassNameException() {
            }
        }
        PsiType psiType;
        if (nameOrAlias == null || dataBindingLayoutInfo == null) {
            return nameOrAlias;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)dataBindingLayoutInfo.getProject());
        final PsiJavaParserFacade parser = psiFacade.getParserFacade();
        try {
            psiType = parser.createTypeFromText(nameOrAlias, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        if (psiType instanceof PsiPrimitiveType) {
            return nameOrAlias;
        }
        final StringBuilder result2 = new StringBuilder();
        final int[] offset = new int[1];
        try {
            psiType.accept((PsiTypeVisitor)new ClassReferenceVisitor(){

                @Override
                public void visitClassReference(@NotNull PsiClassReferenceType classReference) {
                    String className;
                    PsiJavaCodeReferenceElement reference2 = classReference.getReference();
                    int nameOffset = reference2.getTextRange().getStartOffset();
                    while (offset[0] < nameOffset) {
                        int n = offset[0];
                        offset[0] = n + 1;
                        result2.append(nameOrAlias.charAt(n));
                    }
                    String string = className = reference2.isQualified() ? reference2.getQualifiedName() : reference2.getReferenceName();
                    if (className != null) {
                        int nameLength = className.length();
                        className = DataBindingUtil.resolveImport(className, dataBindingLayoutInfo);
                        if (qualifyJavaLang && className.indexOf(46) < 0 && (className = DataBindingUtil.qualifyClassName(className, parser)) == null) {
                            throw new UnresolvedClassNameException();
                        }
                        result2.append(className);
                        offset[0] = offset[0] + nameLength;
                    }
                }
            });
        }
        catch (UnresolvedClassNameException e) {
            return null;
        }
        while (offset[0] < nameOrAlias.length()) {
            int n = offset[0];
            offset[0] = n + 1;
            result2.append(nameOrAlias.charAt(n));
        }
        return result2.toString();
    }

    @Nullable
    private static String qualifyClassName(@NotNull String className, @NotNull PsiJavaParserFacade parser) {
        PsiType psiType = parser.createTypeFromText(className, null);
        if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass == null) {
                return null;
            }
            String name = psiClass.getQualifiedName();
            if (name != null) {
                return name;
            }
        }
        return className;
    }

    @NotNull
    public static String resolveImport(@NotNull String className, @Nullable DataBindingLayoutInfo dataBindingLayoutInfo) {
        int dotOffset;
        String firstSegment;
        String importedType;
        if (dataBindingLayoutInfo != null && (importedType = dataBindingLayoutInfo.resolveImport(firstSegment = (dotOffset = className.indexOf(46)) >= 0 ? className.substring(0, dotOffset) : className)) != null) {
            return dotOffset >= 0 ? importedType + className.substring(dotOffset) : importedType;
        }
        return className;
    }

    public static abstract class ClassReferenceVisitor
    extends PsiTypeVisitor<Void> {
        @Nullable
        public final Void visitClassType(@NotNull PsiClassType classType) {
            PsiType[] parameters2;
            if (classType instanceof PsiClassReferenceType) {
                this.visitClassReference((PsiClassReferenceType)classType);
            }
            for (PsiType parameter : parameters2 = classType.getParameters()) {
                parameter.accept((PsiTypeVisitor)this);
            }
            return null;
        }

        @Nullable
        public final Void visitArrayType(@NotNull PsiArrayType arrayType) {
            PsiType type = arrayType.getComponentType();
            type.accept((PsiTypeVisitor)this);
            return null;
        }

        public abstract void visitClassReference(@NotNull PsiClassReferenceType var1);
    }
}

