/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding;

import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.databinding.DataBindingModeTrackingService;
import com.android.tools.idea.databinding.psiclass.LightBrClass;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDataBinding {
    @Nullable
    private LightBrClass myLightBrClass;
    @NotNull
    private DataBindingMode myDataBindingMode = DataBindingMode.NONE;
    private Module myModule;

    @NotNull
    public static ModuleDataBinding getInstance(@NotNull AndroidFacet facet) {
        ModuleDataBinding dataBinding = (ModuleDataBinding)ModuleServiceManager.getService((Module)facet.getModule(), ModuleDataBinding.class);
        assert (dataBinding != null);
        return dataBinding;
    }

    private ModuleDataBinding(Module module) {
        this.myModule = module;
        MessageBusConnection connection = module.getMessageBus().connect((Disposable)module);
        connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void facetConfigurationChanged(@NotNull Facet facet) {
                if (facet.getModule() == ModuleDataBinding.this.myModule) {
                    ModuleDataBinding.this.syncWithConfiguration();
                }
            }
        });
        this.syncWithConfiguration();
    }

    private void syncWithConfiguration() {
        AndroidModel androidModel;
        AndroidFacet facet = AndroidFacet.getInstance(this.myModule);
        if (facet != null && (androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel()) != null) {
            this.setMode(androidModel.getDataBindingMode());
        }
    }

    public void setMode(@NotNull DataBindingMode mode) {
        if (this.myDataBindingMode != mode) {
            this.myDataBindingMode = mode;
            DataBindingModeTrackingService.getInstance().incrementModificationCount();
        }
    }

    @NotNull
    public DataBindingMode getDataBindingMode() {
        return this.myDataBindingMode;
    }

    public boolean isEnabled() {
        return this.myDataBindingMode != DataBindingMode.NONE;
    }

    public void setLightBrClass(@NotNull LightBrClass lightBrClass) {
        this.myLightBrClass = lightBrClass;
    }

    @Nullable
    public LightBrClass getLightBrClass() {
        return this.myLightBrClass;
    }
}

