/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.cache;

import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceCacheValueProvider<T>
implements CachedValueProvider<T>,
ModificationTracker {
    ModificationTracker[] myAdditionalTrackers;
    private ModificationTracker myTracker = new ModificationTracker(){
        private long myLastVersion = -1L;
        private long myVersion = 0L;

        public long getModificationCount() {
            long version2;
            LocalResourceRepository moduleResources = ResourceRepositoryManager.getInstance(ResourceCacheValueProvider.this.myFacet).getExistingModuleResources();
            long l = version2 = moduleResources == null ? Integer.MIN_VALUE : moduleResources.getModificationCount();
            if (version2 != this.myLastVersion) {
                this.myLastVersion = version2;
                ++this.myVersion;
            }
            return this.myVersion;
        }
    };
    private final AndroidFacet myFacet;
    private final Object myComputeLock;

    public ResourceCacheValueProvider(@NotNull AndroidFacet facet, @Nullable Object computeLock, ModificationTracker ... additionalTrackers) {
        this.myFacet = facet;
        this.myComputeLock = computeLock;
        this.myAdditionalTrackers = additionalTrackers;
    }

    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    public long getModificationCount() {
        return this.myTracker.getModificationCount();
    }

    @NotNull
    public final CachedValueProvider.Result<T> compute() {
        if (ResourceRepositoryManager.getInstance(this.myFacet).getExistingModuleResources() == null) {
            return CachedValueProvider.Result.create(this.defaultValue(), (Object[])new Object[]{this.myTracker, this.myAdditionalTrackers});
        }
        return CachedValueProvider.Result.create(this.computeWithLock(), (Object[])new Object[]{this.myTracker, this.myAdditionalTrackers});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T computeWithLock() {
        if (this.myComputeLock == null) {
            return this.doCompute();
        }
        Object object = this.myComputeLock;
        synchronized (object) {
            return this.doCompute();
        }
    }

    protected abstract T doCompute();

    protected abstract T defaultValue();
}

