/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.finders;

import com.android.tools.idea.databinding.DataBindingProjectComponent;
import com.android.tools.idea.databinding.cache.ProjectResourceCachedValueProvider;
import com.android.tools.idea.databinding.cache.ResourceCacheValueProvider;
import com.android.tools.idea.res.DataBindingLayoutInfo;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataBindingPackageFinder
extends PsiElementFinder {
    private final DataBindingProjectComponent myComponent;
    private final CachedValue<Map<String, PsiPackage>> myPackageCache;

    public DataBindingPackageFinder(DataBindingProjectComponent component) {
        this.myComponent = component;
        this.myPackageCache = CachedValuesManager.getManager((Project)this.myComponent.getProject()).createCachedValue((CachedValueProvider)new ProjectResourceCachedValueProvider<Map<String, PsiPackage>, Set<String>>(this.myComponent, new ModificationTracker[0]){

            @Override
            @NotNull
            protected Map<String, PsiPackage> merge(List<Set<String>> results) {
                HashMap merged = Maps.newHashMap();
                for (Set<String> result2 : results) {
                    for (String qualifiedPackage : result2) {
                        if (merged.containsKey(qualifiedPackage)) continue;
                        merged.put(qualifiedPackage, DataBindingPackageFinder.this.myComponent.getOrCreateDataBindingPsiPackage(qualifiedPackage));
                    }
                }
                return merged;
            }

            @Override
            protected ResourceCacheValueProvider<Set<String>> createCacheProvider(AndroidFacet facet) {
                return new ResourceCacheValueProvider<Set<String>>(facet, null, new ModificationTracker[0]){

                    @Override
                    protected Set<String> doCompute() {
                        LocalResourceRepository moduleResources = ResourceRepositoryManager.getModuleResources(this.getFacet());
                        Map<String, DataBindingLayoutInfo> dataBindingResourceFiles = moduleResources.getDataBindingResourceFiles();
                        if (dataBindingResourceFiles == null) {
                            return Collections.emptySet();
                        }
                        HashSet result2 = Sets.newHashSet();
                        for (DataBindingLayoutInfo info : dataBindingResourceFiles.values()) {
                            result2.add(info.getPackageName());
                        }
                        return result2;
                    }

                    @Override
                    protected Set<String> defaultValue() {
                        return Collections.emptySet();
                    }
                };
            }
        }, false);
    }

    @Nullable
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        return null;
    }

    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        return PsiClass.EMPTY_ARRAY;
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        return (PsiPackage)((Map)this.myPackageCache.getValue()).get(qualifiedName);
    }
}

