/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.psiclass;

import com.android.ide.common.resources.DataBindingResourceType;
import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.databinding.DataBindingUtil;
import com.android.tools.idea.databinding.ModuleDataBinding;
import com.android.tools.idea.databinding.cache.ResourceCacheValueProvider;
import com.android.tools.idea.databinding.psiclass.DeprecatableLightMethodBuilder;
import com.android.tools.idea.res.DataBindingLayoutInfo;
import com.android.tools.idea.res.PsiDataBindingResourceItem;
import com.google.common.collect.ImmutableSet;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightField;
import com.intellij.psi.impl.light.LightFieldBuilder;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightBindingClass
extends AndroidLightClassBase {
    private static final int STATIC_METHOD_COUNT = 6;
    private DataBindingLayoutInfo myInfo;
    private CachedValue<PsiMethod[]> myPsiMethodsCache;
    private CachedValue<PsiField[]> myPsiFieldsCache;
    private PsiReferenceList myExtendsList;
    private PsiClassType[] myExtendsListTypes;
    private final AndroidFacet myFacet;
    private PsiFile myVirtualPsiFile;
    private final DataBindingMode myMode;
    private final Object myLock = new Object();

    public LightBindingClass(AndroidFacet facet, @NotNull PsiManager psiManager, @NotNull DataBindingLayoutInfo info) {
        super(psiManager, (Collection<String>)ImmutableSet.of((Object)"public", (Object)"final"));
        this.myInfo = info;
        this.myFacet = facet;
        this.myVirtualPsiFile = info.getPsiFile();
        this.myMode = ModuleDataBinding.getInstance(facet).getDataBindingMode();
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)info.getProject());
        this.myPsiMethodsCache = cachedValuesManager.createCachedValue((CachedValueProvider)new ResourceCacheValueProvider<PsiMethod[]>(facet, this.myLock, new ModificationTracker[0]){

            @Override
            protected PsiMethod[] doCompute() {
                Map<String, PsiDataBindingResourceItem> variables = LightBindingClass.this.myInfo.getItems(DataBindingResourceType.VARIABLE);
                ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(variables.size() * 2 + 6);
                DataBindingLayoutInfo mergedInfo = LightBindingClass.this.myInfo.getMergedInfo();
                if (mergedInfo == null) {
                    for (PsiDataBindingResourceItem variable : variables.values()) {
                        LightBindingClass.this.createVariableMethods(variable, methods, true);
                    }
                    PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance((Project)LightBindingClass.this.myInfo.getProject());
                    LightBindingClass.this.createStaticMethods(factory.createType((PsiClass)LightBindingClass.this), methods);
                } else {
                    for (PsiDataBindingResourceItem variable : mergedInfo.getItems(DataBindingResourceType.VARIABLE).values()) {
                        LightBindingClass.this.createVariableMethods(variable, methods, false);
                    }
                }
                PsiMethod constructor = LightBindingClass.this.createConstructor();
                methods.add(constructor);
                return methods.toArray(PsiMethod.EMPTY_ARRAY);
            }

            @Override
            protected PsiMethod[] defaultValue() {
                return PsiMethod.EMPTY_ARRAY;
            }
        }, false);
        this.myPsiFieldsCache = cachedValuesManager.createCachedValue((CachedValueProvider)new ResourceCacheValueProvider<PsiField[]>(facet, this.myLock, new ModificationTracker[0]){

            @Override
            protected PsiField[] doCompute() {
                if (LightBindingClass.this.myInfo.getMergedInfo() != null) {
                    return PsiField.EMPTY_ARRAY;
                }
                List<DataBindingLayoutInfo.ViewWithId> viewsWithIds = LightBindingClass.this.myInfo.getViewsWithIds();
                PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance((Project)LightBindingClass.this.myInfo.getProject());
                PsiField[] result2 = new PsiField[viewsWithIds.size()];
                int i2 = 0;
                int unresolved = 0;
                for (DataBindingLayoutInfo.ViewWithId viewWithId : viewsWithIds) {
                    PsiField psiField = LightBindingClass.this.createPsiField(viewWithId);
                    if (psiField == null) {
                        ++unresolved;
                        continue;
                    }
                    result2[i2++] = psiField;
                }
                if (unresolved > 0) {
                    PsiField[] validResult = new PsiField[i2];
                    System.arraycopy(result2, 0, validResult, 0, i2);
                    return validResult;
                }
                return result2;
            }

            @Override
            protected PsiField[] defaultValue() {
                return PsiField.EMPTY_ARRAY;
            }
        }, false);
        this.setModuleInfo(facet.getModule(), false);
    }

    @NotNull
    private PsiMethod createConstructor() {
        LightMethodBuilder constructor = new LightMethodBuilder((PsiClass)this, (Language)JavaLanguage.INSTANCE);
        constructor.setConstructor(true);
        constructor.addModifier("private");
        return constructor;
    }

    @Nullable
    public String getQualifiedName() {
        return this.myInfo.getQualifiedName();
    }

    @Nullable
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        return (PsiField[])this.myPsiFieldsCache.getValue();
    }

    @Override
    @NotNull
    public PsiField[] getAllFields() {
        return this.getFields();
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        return (PsiMethod[])this.myPsiMethodsCache.getValue();
    }

    @Override
    public PsiClass getSuperClass() {
        DataBindingLayoutInfo mergedInfo = this.myInfo.getMergedInfo();
        String superClassName = mergedInfo == null ? this.myMode.viewDataBinding : mergedInfo.getQualifiedName();
        return JavaPsiFacade.getInstance((Project)this.myInfo.getProject()).findClass(superClassName, this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(false));
    }

    @Override
    public PsiReferenceList getExtendsList() {
        if (this.myExtendsList == null) {
            PsiElementFactory factory = PsiElementFactory.SERVICE.getInstance((Project)this.myInfo.getProject());
            PsiJavaCodeReferenceElement referenceElementByType = factory.createReferenceElementByType(this.getExtendsListTypes()[0]);
            this.myExtendsList = factory.createReferenceList(new PsiJavaCodeReferenceElement[]{referenceElementByType});
        }
        return this.myExtendsList;
    }

    @Override
    @NotNull
    public PsiClassType[] getSuperTypes() {
        return this.getExtendsListTypes();
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        if (this.myExtendsListTypes == null) {
            DataBindingLayoutInfo mergedInfo = this.myInfo.getMergedInfo();
            String superClassName = mergedInfo == null ? this.myMode.viewDataBinding : mergedInfo.getQualifiedName();
            this.myExtendsListTypes = new PsiClassType[]{PsiType.getTypeByName((String)superClassName, (Project)this.myInfo.getProject(), (GlobalSearchScope)this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(false))};
        }
        return this.myExtendsListTypes;
    }

    @Override
    @NotNull
    public PsiMethod[] getAllMethods() {
        return this.getMethods();
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsByName(@NonNls String name, boolean checkBases) {
        ArrayList<PsiMethod> matched = null;
        for (PsiMethod method : this.getMethods()) {
            if (!name.equals(method.getName())) continue;
            if (matched == null) {
                matched = new ArrayList<PsiMethod>();
            }
            matched.add(method);
        }
        return matched == null ? PsiMethod.EMPTY_ARRAY : matched.toArray(PsiMethod.EMPTY_ARRAY);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        boolean continueProcessing = super.processDeclarations(processor, state, lastParent, place);
        if (!continueProcessing) {
            return false;
        }
        Map<String, PsiDataBindingResourceItem> imports = this.myInfo.getItems(DataBindingResourceType.IMPORT);
        if (imports.isEmpty()) {
            return true;
        }
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (classHint != null && classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            String name = nameHint != null ? nameHint.getName(state) : null;
            for (PsiDataBindingResourceItem imp : imports.values()) {
                String qName;
                String alias = imp.getExtra("alias");
                if (alias != null || (qName = imp.getExtra("type")) == null || name != null && !qName.endsWith("" + name)) continue;
                Module module = this.myInfo.getModule();
                if (module == null) {
                    return true;
                }
                PsiClass aClass = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).findClass(qName, module.getModuleWithDependenciesAndLibrariesScope(true));
                if (aClass == null || processor.execute((PsiElement)aClass, state)) continue;
                return false;
            }
        }
        return true;
    }

    private void createVariableMethods(@NotNull PsiDataBindingResourceItem item, @NotNull List<PsiMethod> outPsiMethods, boolean addGetter) {
        PsiManager psiManager = this.getManager();
        String typeName = item.getExtra("type");
        String variableType = DataBindingUtil.getQualifiedType(typeName, this.myInfo, true);
        if (variableType == null) {
            return;
        }
        PsiType type = DataBindingUtil.parsePsiType(variableType, this.myFacet, (PsiElement)this);
        if (type == null) {
            return;
        }
        String javaName = DataBindingUtil.convertToJavaFieldName(item.getName());
        String capitalizedName = StringUtil.capitalize((String)javaName);
        DeprecatableLightMethodBuilder setter = this.createPublicMethod("set" + capitalizedName, (PsiType)PsiType.VOID);
        setter.addParameter(javaName, type);
        if (this.myInfo.isMerged()) {
            setter.addModifier("abstract");
        }
        outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)item.getXmlTag(), psiManager, (PsiMethod)setter, this, (Language)JavaLanguage.INSTANCE));
        if (addGetter) {
            DeprecatableLightMethodBuilder getter = this.createPublicMethod("get" + capitalizedName, type);
            outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)item.getXmlTag(), psiManager, (PsiMethod)getter, this, (Language)JavaLanguage.INSTANCE));
        }
    }

    private void createStaticMethods(@NotNull PsiClassType ownerType, @NotNull List<PsiMethod> outPsiMethods) {
        PsiMethod[] methods;
        Project project = this.myInfo.getProject();
        Module module = this.myFacet.getModule();
        PsiClassType viewGroupType = PsiType.getTypeByName((String)"android.view.ViewGroup", (Project)project, (GlobalSearchScope)module.getModuleWithDependenciesAndLibrariesScope(true));
        PsiClassType layoutInflaterType = PsiType.getTypeByName((String)"android.view.LayoutInflater", (Project)project, (GlobalSearchScope)module.getModuleWithDependenciesAndLibrariesScope(true));
        PsiClassType dataBindingComponent = PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)module.getModuleWithDependenciesAndLibrariesScope(true));
        PsiClassType viewType = PsiType.getTypeByName((String)"android.view.View", (Project)project, (GlobalSearchScope)module.getModuleWithDependenciesAndLibrariesScope(true));
        DeprecatableLightMethodBuilder inflate4Arg = this.createPublicStaticMethod("inflate", (PsiType)ownerType);
        inflate4Arg.addParameter("inflater", (PsiType)layoutInflaterType);
        inflate4Arg.addParameter("root", (PsiType)viewGroupType);
        inflate4Arg.addParameter("attachToRoot", (PsiType)PsiType.BOOLEAN);
        inflate4Arg.addParameter("bindingComponent", (PsiType)dataBindingComponent);
        inflate4Arg.setDeprecated(true);
        DeprecatableLightMethodBuilder inflate3Arg = this.createPublicStaticMethod("inflate", (PsiType)ownerType);
        inflate3Arg.addParameter("inflater", (PsiType)layoutInflaterType);
        inflate3Arg.addParameter("root", (PsiType)viewGroupType);
        inflate3Arg.addParameter("attachToRoot", (PsiType)PsiType.BOOLEAN);
        DeprecatableLightMethodBuilder inflate2Arg = this.createPublicStaticMethod("inflate", (PsiType)ownerType);
        inflate2Arg.addParameter("inflater", (PsiType)layoutInflaterType);
        inflate2Arg.addParameter("bindingComponent", (PsiType)dataBindingComponent);
        inflate2Arg.setDeprecated(true);
        DeprecatableLightMethodBuilder inflate1Arg = this.createPublicStaticMethod("inflate", (PsiType)ownerType);
        inflate1Arg.addParameter("inflater", (PsiType)layoutInflaterType);
        DeprecatableLightMethodBuilder bind2 = this.createPublicStaticMethod("bind", (PsiType)ownerType);
        bind2.addParameter("view", (PsiType)viewType);
        DeprecatableLightMethodBuilder bindWithComponent = this.createPublicStaticMethod("bind", (PsiType)ownerType);
        bindWithComponent.addParameter("view", (PsiType)viewType);
        bindWithComponent.addParameter("bindingComponent", (PsiType)dataBindingComponent);
        bindWithComponent.setDeprecated(true);
        PsiManager psiManager = this.getManager();
        for (PsiMethod method : methods = new PsiMethod[]{inflate1Arg, inflate2Arg, inflate3Arg, inflate4Arg, bind2, bindWithComponent}) {
            outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)this.myInfo.getPsiFile(), psiManager, method, this, (Language)JavaLanguage.INSTANCE));
        }
    }

    @NotNull
    private DeprecatableLightMethodBuilder createPublicStaticMethod(@NotNull String name, @NotNull PsiType returnType) {
        DeprecatableLightMethodBuilder method = this.createPublicMethod(name, returnType);
        method.addModifier("static");
        return method;
    }

    @NotNull
    private DeprecatableLightMethodBuilder createPublicMethod(@NotNull String name, @NotNull PsiType returnType) {
        DeprecatableLightMethodBuilder method = new DeprecatableLightMethodBuilder(this.getManager(), (Language)JavaLanguage.INSTANCE, name);
        method.setContainingClass(this);
        method.setMethodReturnType(returnType);
        method.addModifier("public");
        return method;
    }

    @Nullable
    private PsiField createPsiField(@NotNull DataBindingLayoutInfo.ViewWithId viewWithId) {
        PsiType type = DataBindingUtil.resolveViewPsiType(viewWithId, this.myFacet);
        if (type == null) {
            return null;
        }
        LightFieldBuilder field2 = new LightFieldBuilder(viewWithId.name, type, (PsiElement)viewWithId.tag);
        field2.setModifiers(new String[]{"public", "final"});
        return new LightDataBindingField(viewWithId, PsiManager.getInstance((Project)this.myInfo.getProject()), (PsiField)field2, this);
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        return this.myInfo.getNavigationElement();
    }

    public String getName() {
        return this.myInfo.getClassName();
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return this.myVirtualPsiFile;
    }

    public boolean isValid() {
        return true;
    }

    public static class LightDataBindingField
    extends LightField {
        private final DataBindingLayoutInfo.ViewWithId myViewWithId;

        public LightDataBindingField(DataBindingLayoutInfo.ViewWithId viewWithId, @NotNull PsiManager manager, @NotNull PsiField field2, @NotNull PsiClass containingClass) {
            super(manager, field2, containingClass);
            this.myViewWithId = viewWithId;
        }

        @Nullable
        public PsiFile getContainingFile() {
            PsiClass containingClass = super.getContainingClass();
            return containingClass == null ? null : containingClass.getContainingFile();
        }

        public TextRange getTextRange() {
            return TextRange.EMPTY_RANGE;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            return this.myViewWithId.tag;
        }

        @NotNull
        public PsiElement setName(@NotNull String name) {
            return this;
        }
    }

    public static class LightDataBindingMethod
    extends LightMethod {
        private PsiElement myNavigationElement;

        public LightDataBindingMethod(@NotNull PsiElement navigationElement, @NotNull PsiManager manager, @NotNull PsiMethod method, @NotNull PsiClass containingClass, @NotNull Language language) {
            super(manager, method, containingClass, language);
            this.myNavigationElement = navigationElement;
        }

        public TextRange getTextRange() {
            return TextRange.EMPTY_RANGE;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            return this.myNavigationElement;
        }

        public PsiIdentifier getNameIdentifier() {
            return new LightIdentifier(this.getManager(), this.getName());
        }
    }
}

