/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.psiclass;

import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.databinding.ModuleDataBinding;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightBindingComponentClass
extends AndroidLightClassBase
implements ModificationTracker {
    private final AndroidFacet myFacet;
    private CachedValue<PsiMethod[]> myMethodCache;
    private PsiFile myContainingFile;
    private final DataBindingMode myMode;

    public LightBindingComponentClass(@NotNull PsiManager psiManager, AndroidFacet facet) {
        super(psiManager, (Collection<String>)ImmutableSet.of((Object)"public"));
        this.myMode = ModuleDataBinding.getInstance(facet).getDataBindingMode();
        this.myFacet = facet;
        this.myMethodCache = CachedValuesManager.getManager((Project)facet.getModule().getProject()).createCachedValue(() -> {
            Project project = facet.getModule().getProject();
            HashMap instanceAdapterClasses = Maps.newHashMap();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myFacet.getModule().getProject());
            PsiClass aClass = facade.findClass(this.myMode.bindingAdapter, this.myFacet.getModule().getModuleWithDependenciesAndLibrariesScope(false));
            if (aClass == null) {
                return CachedValueProvider.Result.create((Object)PsiMethod.EMPTY_ARRAY, (Object[])new Object[]{this.myManager.getModificationTracker().getJavaStructureModificationTracker()});
            }
            Collection psiElements = AnnotatedElementsSearch.searchElements((PsiClass)aClass, (SearchScope)this.myFacet.getModule().getModuleScope(), (Class[])new Class[]{PsiMethod.class}).findAll();
            int methodCount = 0;
            for (PsiModifierListOwner owner : psiElements) {
                PsiClass containingClass;
                if (!(owner instanceof PsiMethod) || owner.hasModifierProperty("static") || (containingClass = ((PsiMethod)owner).getContainingClass()) == null) continue;
                String className = containingClass.getName();
                TreeSet<String> set = (TreeSet<String>)instanceAdapterClasses.get(className);
                if (set == null) {
                    set = new TreeSet<String>();
                    instanceAdapterClasses.put(className, set);
                }
                if (!set.add(containingClass.getQualifiedName())) continue;
                ++methodCount;
            }
            if (methodCount == 0) {
                return CachedValueProvider.Result.create((Object)PsiMethod.EMPTY_ARRAY, (Object[])new Object[]{this.myManager.getModificationTracker().getJavaStructureModificationTracker()});
            }
            PsiElementFactory elementFactory = PsiElementFactory.SERVICE.getInstance((Project)project);
            PsiMethod[] result2 = new PsiMethod[methodCount];
            int methodIndex = 0;
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            for (Map.Entry methods : instanceAdapterClasses.entrySet()) {
                if (((Set)methods.getValue()).size() == 1) {
                    result2[methodIndex] = this.createPsiMethod(elementFactory, "get" + (String)methods.getKey(), (String)Iterables.getFirst((Iterable)((Iterable)methods.getValue()), (Object)""), project, scope);
                    ++methodIndex;
                    continue;
                }
                int suffix = 1;
                for (String item : (Set)methods.getValue()) {
                    String name = "get" + (String)methods.getKey() + suffix;
                    result2[methodIndex] = this.createPsiMethod(elementFactory, name, item, project, scope);
                    ++suffix;
                    ++methodIndex;
                }
            }
            return CachedValueProvider.Result.create((Object)result2, (Object[])new Object[]{this.myManager.getModificationTracker().getJavaStructureModificationTracker()});
        }, false);
        this.setModuleInfo(facet.getModule(), false);
    }

    @Override
    public boolean isInterface() {
        return true;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    private PsiMethod createPsiMethod(PsiElementFactory factory, String name, String type, Project project, GlobalSearchScope scope) {
        PsiMethod method = factory.createMethod(name, (PsiType)PsiType.getTypeByName((String)type, (Project)project, (GlobalSearchScope)scope));
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)true);
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"abstract", (boolean)true);
        return new LightMethod(PsiManager.getInstance((Project)project), method, (PsiClass)this);
    }

    @Nullable
    public String getQualifiedName() {
        return this.myMode.dataBindingComponent;
    }

    public String getName() {
        return "DataBindingComponent";
    }

    @Nullable
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        return PsiField.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiField[] getAllFields() {
        return this.getFields();
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        return (PsiMethod[])this.myMethodCache.getValue();
    }

    @Override
    @NotNull
    public PsiMethod[] getAllMethods() {
        return this.getMethods();
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsByName(@NonNls String name, boolean checkBases) {
        ArrayList result2 = Lists.newArrayList();
        for (PsiMethod method : (PsiMethod[])this.myMethodCache.getValue()) {
            if (!method.getName().equals(name)) continue;
            result2.add(method);
        }
        return result2.isEmpty() ? PsiMethod.EMPTY_ARRAY : result2.toArray(PsiMethod.EMPTY_ARRAY);
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        if (this.myContainingFile == null) {
            String packageName = this.myMode.packageName;
            if (packageName.endsWith(".")) {
                packageName = packageName.substring(0, packageName.length() - 1);
            }
            this.myContainingFile = PsiFileFactory.getInstance((Project)this.myFacet.getModule().getProject()).createFileFromText("DataBindingComponent.java", (Language)JavaLanguage.INSTANCE, (CharSequence)("package " + packageName + ";\npublic interface DataBindingComponent {}"), false, true, true);
        }
        return this.myContainingFile;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return new LightIdentifier(this.getManager(), this.getName());
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiFile containingFile = this.getContainingFile();
        return containingFile == null ? super.getNavigationElement() : containingFile;
    }

    public long getModificationCount() {
        return 0L;
    }
}

