/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.ClientCellRenderer;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DevicePanel
implements AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IClientChangeListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(DevicePanel.class);
    private final DeviceContext myDeviceContext;
    @Nullable
    private AndroidDebugBridge myBridge;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, String> myPreferredClients;
    private boolean myIgnoringActionEvents;
    private DeviceComboBox myDeviceCombo;
    private JComboBox<Client> myProcessComboBox;
    private final NullableLazyValue<String> myCandidateClientName = new NullableLazyValue<String>(){

        @Nullable
        protected String compute() {
            return DevicePanel.this.getApplicationName();
        }
    };

    public DevicePanel(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        this(project, deviceContext, new MyDeviceComboBox(), new MyProcessComboBox());
    }

    DevicePanel(@NotNull Project project, @NotNull DeviceContext deviceContext, @NotNull DeviceComboBox deviceComboBox, @NotNull ComboBox<Client> processComboBox) {
        this.myProject = project;
        this.myDeviceContext = deviceContext;
        this.myPreferredClients = new HashMap<String, String>();
        this.initializeDeviceCombo(deviceComboBox);
        this.initializeProcessComboBox(processComboBox);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        Disposer.register((Disposable)this.myProject, (Disposable)this);
    }

    private void initializeDeviceCombo(@NotNull DeviceComboBox deviceComboBox) {
        deviceComboBox.initRenderer(new MyFutureCallback());
        deviceComboBox.addActionListener(event -> {
            if (this.myIgnoringActionEvents) {
                return;
            }
            this.updateProcessComboBox();
            Object device = this.myDeviceCombo.getSelectedItem();
            this.myDeviceContext.fireDeviceSelected(device instanceof IDevice ? (IDevice)device : null);
        });
        this.myDeviceCombo = deviceComboBox;
    }

    private void initializeProcessComboBox(@NotNull ComboBox<Client> processComboBox) {
        processComboBox.setName("Processes");
        AccessibleContextUtil.setName(processComboBox, (String)"Processes");
        processComboBox.addActionListener(event -> {
            if (this.myIgnoringActionEvents) {
                return;
            }
            Client client = (Client)this.myProcessComboBox.getSelectedItem();
            if (client != null) {
                this.myPreferredClients.put(client.getDevice().getName(), client.getClientData().getClientDescription());
            }
            this.myDeviceContext.fireClientSelected(client);
        });
        this.myProcessComboBox = processComboBox;
    }

    @NotNull
    public JComboBox<IDevice> getDeviceComboBox() {
        return this.myDeviceCombo;
    }

    public void selectDevice(IDevice device) {
        this.myDeviceCombo.setSelectedItem(device);
    }

    @NotNull
    public Component getClientComboBox() {
        return this.myProcessComboBox;
    }

    public void selectClient(Client client) {
        this.myProcessComboBox.setSelectedItem(client);
    }

    @Nullable
    private String getApplicationName() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String pkg;
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(module);
            if (moduleInfo == null || (pkg = moduleInfo.getPackage()) == null) continue;
            return pkg;
        }
        return null;
    }

    public void dispose() {
        if (this.myBridge != null) {
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
            AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
            this.myBridge = null;
        }
        if (this.myDeviceCombo != null) {
            Disposer.dispose((Disposable)this.myDeviceCombo);
            this.myDeviceCombo = null;
        }
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> UIUtil.invokeLaterIfNeeded(() -> {
            this.myBridge = bridge;
            this.updateDeviceCombo();
        }));
    }

    void setBridge(@NotNull AndroidDebugBridge bridge) {
        this.myBridge = bridge;
    }

    public void deviceConnected(@NotNull IDevice device) {
        LOG.info("Device connected: " + device.getName());
        UIUtil.invokeLaterIfNeeded(this::updateDeviceCombo);
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        LOG.info("Device disconnected: " + device.getName());
        UIUtil.invokeLaterIfNeeded(this::updateDeviceCombo);
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        UIUtil.invokeLaterIfNeeded(() -> this.deviceChangedImpl(device, changeMask));
    }

    void deviceChangedImpl(@NotNull IDevice device, int changeMask) {
        if ((changeMask & 2) != 0) {
            this.updateProcessComboBox();
        } else if ((changeMask & 1) != 0) {
            this.updateDeviceCombo();
        }
        this.myDeviceContext.fireDeviceChanged(device, changeMask);
    }

    public void clientChanged(@NotNull Client client, int changeMask) {
        if ((changeMask & 1) != 0) {
            ApplicationManager.getApplication().invokeLater(this::updateProcessComboBox);
        }
    }

    void updateDeviceCombo() {
        if (this.myBridge == null) {
            return;
        }
        this.myIgnoringActionEvents = true;
        IDevice selectedDevice = (IDevice)this.myDeviceCombo.getSelectedItem();
        this.myDeviceCombo.removeAllItems();
        List<IDevice> devices = Arrays.asList(this.myBridge.getDevices());
        devices.forEach(device -> this.myDeviceCombo.addItem(device));
        this.myDeviceCombo.setSerialNumbersVisible(DeviceRenderer.shouldShowSerialNumbers(devices));
        Optional<IDevice> optionalDevice = IntStream.range(0, this.myDeviceCombo.getItemCount()).mapToObj(i2 -> (IDevice)this.myDeviceCombo.getItemAt(i2)).filter(device -> DevicePanel.equals(device, selectedDevice)).findFirst();
        if (optionalDevice.isPresent()) {
            IDevice device2 = optionalDevice.get();
            this.myDeviceCombo.setSelectedItem(device2);
            this.myDeviceContext.fireDeviceSelected(device2);
        } else if (selectedDevice != null) {
            this.myDeviceCombo.addItem(selectedDevice);
            this.myDeviceCombo.setSelectedItem(selectedDevice);
            this.myDeviceContext.fireDeviceSelected(selectedDevice);
        }
        this.updateProcessComboBox();
        this.myIgnoringActionEvents = false;
    }

    private static boolean equals(@NotNull IDevice device1, @Nullable IDevice device2) {
        if (device2 == null) {
            return false;
        }
        boolean device1Emulator = device1.isEmulator();
        if (device1Emulator != device2.isEmulator()) {
            return false;
        }
        if (device1Emulator) {
            return Objects.equals(device1.getAvdName(), device2.getAvdName());
        }
        return device1.getSerialNumber().equals(device2.getSerialNumber());
    }

    private void updateProcessComboBox() {
        if (this.myDeviceCombo == null) {
            return;
        }
        this.myIgnoringActionEvents = true;
        IDevice device = (IDevice)this.myDeviceCombo.getSelectedItem();
        Client selected = (Client)this.myProcessComboBox.getSelectedItem();
        Client toSelect = null;
        boolean update2 = true;
        this.myProcessComboBox.removeAllItems();
        if (device != null) {
            boolean selectedClientDied;
            Client preferredClient;
            String preferred = this.getPreferredClient(device.getName());
            if (preferred != null && (preferredClient = device.getClient(preferred)) != null) {
                toSelect = preferredClient;
            }
            ArrayList clients = Lists.newArrayList((Object[])device.getClients());
            boolean bl = selectedClientDied = selected != null && selected.getDevice() == device && !clients.contains(selected);
            if (selectedClientDied) {
                if (toSelect == null) {
                    toSelect = selected;
                }
                clients.add(selected);
            }
            clients.sort(new ClientCellRenderer.ClientComparator());
            for (Client client : clients) {
                this.myProcessComboBox.addItem(client);
            }
            this.myProcessComboBox.setSelectedItem(toSelect);
            update2 = toSelect != selected;
        }
        this.myIgnoringActionEvents = false;
        if (update2) {
            this.myDeviceContext.fireClientSelected((Client)this.myProcessComboBox.getSelectedItem());
        }
    }

    void setIgnoringActionEvents(boolean ignoringActionEvents) {
        this.myIgnoringActionEvents = ignoringActionEvents;
    }

    @Nullable
    private String getPreferredClient(@NotNull String device) {
        String client = this.myPreferredClients.get(device);
        return client == null ? (String)this.myCandidateClientName.getValue() : client;
    }

    void putPreferredClient(@NotNull String device, @NotNull String client) {
        this.myPreferredClients.put(device, client);
    }

    private static final class MyProcessComboBox
    extends ComboBox<Client> {
        private MyProcessComboBox() {
            this.setRenderer((ListCellRenderer)((Object)new ClientCellRenderer("No debuggable processes")));
        }
    }

    private final class MyFutureCallback
    implements FutureCallback<DeviceNameProperties> {
        private MyFutureCallback() {
        }

        public void onSuccess(@Nullable DeviceNameProperties properties) {
            DevicePanel.this.updateDeviceCombo();
        }

        public void onFailure(@NotNull Throwable throwable) {
            LOG.warn("Error retrieving device name properties", throwable);
        }
    }

    private static final class MyDeviceComboBox
    extends DeviceComboBox {
        private DeviceNamePropertiesFetcher myFetcher;
        private DeviceRenderer.DeviceComboBoxRenderer myRenderer;

        private MyDeviceComboBox() {
        }

        @Override
        void initRenderer(@NotNull FutureCallback<DeviceNameProperties> callback2) {
            this.myFetcher = new DeviceNamePropertiesFetcher(callback2, this);
            this.myRenderer = new DeviceRenderer.DeviceComboBoxRenderer("No connected devices", false, this.myFetcher);
            this.setRenderer((ListCellRenderer)((Object)this.myRenderer));
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myFetcher);
        }

        @Override
        void setSerialNumbersVisible(boolean visible) {
            this.myRenderer.setShowSerial(visible);
        }
    }

    static abstract class DeviceComboBox
    extends ComboBox<IDevice>
    implements Disposable {
        DeviceComboBox() {
            AccessibleContextUtil.setName((Component)((Object)this), (String)"Devices");
        }

        abstract void initRenderer(@NotNull FutureCallback<DeviceNameProperties> var1);

        abstract void setSerialNumbersVisible(boolean var1);
    }
}

