/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.IDevice;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DevicePropertyUtil {
    private static final Set<String> ourManufacturerNameIsAcronym = ImmutableSet.of((Object)"ASUS", (Object)"HTC", (Object)"LG", (Object)"LGE", (Object)"ZTE");

    static String fixManufacturerName(@NotNull String manufacturer) {
        String allCaps = manufacturer.toUpperCase(Locale.US);
        return ourManufacturerNameIsAcronym.contains(allCaps) ? allCaps : StringUtil.capitalizeWords((String)manufacturer, (boolean)true);
    }

    @NotNull
    public static String getManufacturer(@NotNull IDevice d, @NotNull String unknown) {
        return DevicePropertyUtil.getManufacturer(d.getProperty("ro.product.manufacturer"), d.isEmulator(), unknown);
    }

    @NotNull
    public static String getManufacturer(@Nullable String manufacturer, boolean isEmulator, @NotNull String unknown) {
        if (isEmulator && "unknown".equals(manufacturer)) {
            manufacturer = unknown;
        }
        return manufacturer != null ? DevicePropertyUtil.fixManufacturerName(manufacturer) : unknown;
    }

    @NotNull
    public static String getModel(@NotNull IDevice d, @NotNull String unknown) {
        return DevicePropertyUtil.getModel(d.getProperty("ro.product.model"), unknown);
    }

    @NotNull
    public static String getModel(@Nullable String model2, @NotNull String unknown) {
        return model2 != null ? StringUtil.capitalizeWords((String)model2, (boolean)true) : unknown;
    }

    @NotNull
    public static String getBuild(@NotNull IDevice d) {
        return DevicePropertyUtil.getBuild(d.getProperty("ro.build.version.release"), d.getProperty("ro.build.version.codename"), d.getProperty("ro.build.version.sdk"));
    }

    @NotNull
    public static String getBuild(@Nullable String buildVersion, @Nullable String codeName, @Nullable String apiLevel) {
        String apiString;
        StringBuilder sb = new StringBuilder(20);
        if (buildVersion != null) {
            sb.append("Android ");
            sb.append(buildVersion);
        }
        String string = apiString = codeName == null || codeName.equals("REL") ? apiLevel : codeName;
        if (apiString != null) {
            sb.append(String.format(", API %1$s", apiString));
        }
        return sb.toString();
    }
}

