/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.IDevice;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesProvider;
import com.android.tools.idea.ddms.DeviceNameRendererEx;
import com.android.tools.idea.ddms.DevicePropertyUtil;
import com.google.common.collect.Sets;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import icons.AndroidIcons;
import icons.StudioIcons;
import java.util.HashSet;
import java.util.List;
import javax.swing.JList;
import javax.swing.JTable;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceRenderer {
    private DeviceRenderer() {
    }

    public static void renderDeviceName(@NotNull IDevice d, @NotNull DeviceNameProperties deviceProperties, @NotNull ColoredTextContainer component, boolean showSerialNumber) {
        DeviceRenderer.renderDeviceName(d, deviceProperties, component, showSerialNumber, null);
    }

    public static void renderDeviceName(@NotNull IDevice d, @NotNull DeviceNameProperties deviceNameProperties, @NotNull ColoredTextContainer component, boolean showSerialNumber, @Nullable AvdManager avdManager) {
        component.setIcon(d.isEmulator() ? AndroidIcons.Ddms.Emulator2 : StudioIcons.DeviceExplorer.PHYSICAL_DEVICE_PHONE);
        String name = d.isEmulator() ? DeviceRenderer.getEmulatorDeviceName(d, avdManager) : DeviceRenderer.getDeviceName(deviceNameProperties);
        component.append(name, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        IDevice.DeviceState deviceState = d.getState();
        if (deviceState != IDevice.DeviceState.ONLINE) {
            String state = String.format("%1$s [%2$s] ", d.getSerialNumber(), d.getState());
            component.append(state, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        } else if (showSerialNumber) {
            String state = String.format("%1$s ", d.getSerialNumber());
            component.append(state, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
        if (deviceState != IDevice.DeviceState.DISCONNECTED && deviceState != IDevice.DeviceState.OFFLINE) {
            component.append(DevicePropertyUtil.getBuild(deviceNameProperties.getBuildVersion(), null, deviceNameProperties.getApiLevel()), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @NotNull
    private static String getEmulatorDeviceName(@NotNull IDevice d, @Nullable AvdManager avdManager) {
        AvdInfo info;
        String avdName = d.getAvdName();
        if (avdManager != null && (info = avdManager.getAvd(avdName, true)) != null) {
            avdName = (String)info.getProperties().get("avd.ini.displayname");
        }
        if (avdName == null) {
            avdName = d.getSerialNumber();
        }
        return String.format("%1$s %2$s ", AndroidBundle.message("android.emulator", new Object[0]), avdName);
    }

    @NotNull
    private static String getDeviceName(@NotNull DeviceNameProperties deviceNameProperties) {
        return String.format("%1$s %2$s ", DevicePropertyUtil.getManufacturer(deviceNameProperties.getManufacturer(), false, ""), DevicePropertyUtil.getModel(deviceNameProperties.getModel(), ""));
    }

    @NotNull
    private static String getDeviceName(@NotNull IDevice d) {
        return String.format("%1$s %2$s ", DevicePropertyUtil.getManufacturer(d, ""), DevicePropertyUtil.getModel(d, ""));
    }

    public static boolean shouldShowSerialNumbers(@NotNull List<IDevice> devices) {
        HashSet myNames = Sets.newHashSet();
        for (IDevice currentDevice : devices) {
            if (currentDevice.isEmulator()) continue;
            String currentName = DeviceRenderer.getDeviceName(currentDevice);
            if (myNames.contains(currentName)) {
                return true;
            }
            myNames.add(currentName);
        }
        return false;
    }

    public static class DeviceNameRenderer
    extends ColoredTableCellRenderer {
        private static final ExtensionPointName<DeviceNameRendererEx> EP_NAME = ExtensionPointName.create((String)"com.android.run.deviceNameRenderer");
        private final DeviceNameRendererEx[] myRenderers = (DeviceNameRendererEx[])EP_NAME.getExtensions();
        private final AvdManager myAvdManager;
        private final DeviceNamePropertiesProvider myDeviceNamePropertiesProvider;

        public DeviceNameRenderer(@Nullable AvdManager avdManager, @NotNull DeviceNamePropertiesProvider deviceNamePropertiesProvider) {
            this.myAvdManager = avdManager;
            this.myDeviceNamePropertiesProvider = deviceNamePropertiesProvider;
        }

        protected void customizeCellRenderer(JTable table2, Object value2, boolean selected, boolean hasFocus, int row, int column) {
            if (!(value2 instanceof IDevice)) {
                return;
            }
            IDevice device = (IDevice)value2;
            for (DeviceNameRendererEx renderer : this.myRenderers) {
                if (!renderer.isApplicable(device)) continue;
                renderer.render(device, (ColoredTextContainer)this);
                return;
            }
            DeviceRenderer.renderDeviceName(device, this.myDeviceNamePropertiesProvider.get(device), (ColoredTextContainer)this, false, this.myAvdManager);
        }
    }

    static final class DeviceComboBoxRenderer
    extends ColoredListCellRenderer<IDevice> {
        @NotNull
        private String myEmptyText;
        private boolean myShowSerial;
        private DeviceNamePropertiesProvider myDeviceNamePropertiesProvider;

        public DeviceComboBoxRenderer(@NotNull String emptyText, boolean showSerial, @NotNull DeviceNamePropertiesProvider deviceNamePropertiesProvider) {
            this.myEmptyText = emptyText;
            this.myShowSerial = showSerial;
            this.myDeviceNamePropertiesProvider = deviceNamePropertiesProvider;
        }

        public void setShowSerial(boolean showSerial) {
            this.myShowSerial = showSerial;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends IDevice> list, IDevice value2, int index, boolean selected, boolean focused) {
            if (value2 == null) {
                this.append(this.myEmptyText, SimpleTextAttributes.ERROR_ATTRIBUTES);
                return;
            }
            DeviceRenderer.renderDeviceName(value2, this.myDeviceNamePropertiesProvider.get(value2), (ColoredTextContainer)this, this.myShowSerial);
        }
    }
}

