/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.actions.PullRecordingTask;
import com.android.tools.idea.ddms.actions.ScreenRecorderAction;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ScreenRecorderTask
extends Task.Modal {
    private static final CharSequence MEDIA_UNSUPPORTED_ERROR = "-1010";
    private final IDevice myDevice;
    private final CountDownLatch myCompletionLatch;
    private final CollectingOutputReceiver myReceiver;
    private final Path mHostTmpFileName;

    public ScreenRecorderTask(@NotNull Project project, @NotNull IDevice device, @NotNull CountDownLatch completionLatch, @NotNull CollectingOutputReceiver receiver, @Nullable Path hostTmpFileName) {
        super(project, "Screen Recorder", true);
        this.myDevice = device;
        this.myCompletionLatch = completionLatch;
        this.myReceiver = receiver;
        this.mHostTmpFileName = hostTmpFileName;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        int elapsedTime = 0;
        indicator.setIndeterminate(true);
        block2: while (true) {
            try {
                while (!this.myCompletionLatch.await(1L, TimeUnit.SECONDS)) {
                    indicator.setText(String.format(Locale.US, "Recording...%1$d %2$s elapsed", ++elapsedTime, StringUtil.pluralize((String)"second", (int)elapsedTime)));
                    EmulatorConsole console = null;
                    if (this.mHostTmpFileName != null && (console = EmulatorConsole.getConsole((IDevice)this.myDevice)) == null) {
                        indicator.cancel();
                    }
                    if (!indicator.isCanceled() && elapsedTime < 180) continue;
                    if (this.mHostTmpFileName != null) {
                        if (console != null) {
                            console.stopScreenRecording();
                        }
                    } else {
                        this.myReceiver.cancel();
                    }
                    indicator.setText("Stopping...");
                    this.myCompletionLatch.await(1L, TimeUnit.SECONDS);
                    break block2;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void onFinished() {
        if (this.mHostTmpFileName != null) {
            this.pullEmulatorRecording();
        } else {
            this.pullRecording();
        }
    }

    private void pullEmulatorRecording() {
        VirtualFile baseDir;
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor("Save As", "", new String[]{"webm"});
        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, this.myProject);
        VirtualFileWrapper fileWrapper = saveFileDialog.save(baseDir = VfsUtil.getUserHomeDir(), ScreenRecorderTask.getDefaultFileName(".webm"));
        if (fileWrapper == null) {
            return;
        }
        try {
            assert (this.mHostTmpFileName != null);
            Files.copy(this.mHostTmpFileName, fileWrapper.getFile().toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            ScreenRecorderAction.showError(this.myProject, "Unable to copy file to destination", e);
        }
    }

    private void pullRecording() {
        VirtualFile baseDir;
        if (this.myReceiver.getOutput().contains(MEDIA_UNSUPPORTED_ERROR)) {
            Messages.showErrorDialog((String)this.myReceiver.getOutput(), (String)"Screen Recorder Error");
            return;
        }
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor("Save As", "", new String[]{"mp4"});
        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, this.myProject);
        VirtualFileWrapper fileWrapper = saveFileDialog.save(baseDir = VfsUtil.getUserHomeDir(), ScreenRecorderTask.getDefaultFileName(".mp4"));
        if (fileWrapper == null) {
            return;
        }
        File f = fileWrapper.getFile();
        new PullRecordingTask(this.myProject, this.myDevice, f.getAbsolutePath()).queue();
    }

    private static String getDefaultFileName(String extension) {
        Calendar now = Calendar.getInstance();
        String fileName = "device-%tF-%tH%tM%tS";
        return String.format(Locale.US, SystemInfo.isMac ? fileName + extension : fileName, now, now, now, now);
    }
}

