/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.SdkConstants;
import com.android.tools.idea.debug.AndroidResolveHelper;
import com.android.tools.idea.debug.ResourceIdResolver;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.google.common.util.concurrent.Atomics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationsRenderer {
    @NotNull
    public static Result render(@Nullable ResourceIdResolver resolver, @NotNull PsiAnnotation annotation, int value2) {
        String qualifiedName = AnnotationsRenderer.getQualifiedName(annotation);
        if (qualifiedName == null) {
            return AnnotationsRenderer.renderUnknown(null, value2);
        }
        if (ResourceEvaluator.COLOR_INT_ANNOTATION.isEquals(qualifiedName)) {
            return AnnotationsRenderer.renderColorInt(value2);
        }
        if (qualifiedName.endsWith("Res")) {
            return AnnotationsRenderer.renderResourceRefAnnotation(resolver, value2, qualifiedName);
        }
        if (SdkConstants.INT_DEF_ANNOTATION.isEquals(qualifiedName)) {
            return AnnotationsRenderer.renderIntDefAnnotation(annotation, value2);
        }
        return AnnotationsRenderer.renderUnknown(qualifiedName, value2);
    }

    @NotNull
    private static Result renderIntDefAnnotation(final @NotNull PsiAnnotation annotation, int value2) {
        final AtomicReference valuesRef = Atomics.newReference();
        ApplicationManager.getApplication().runReadAction(new Runnable(){

            @Override
            public void run() {
                valuesRef.set(AndroidResolveHelper.resolveIntDef(annotation));
            }
        });
        AndroidResolveHelper.IntDefResolution intDef = (AndroidResolveHelper.IntDefResolution)valuesRef.get();
        if (intDef.valuesMap == null) {
            AnnotationsRenderer.renderUnknown("IntDef", value2);
        }
        return new Result(String.format(Locale.US, "0x%1$08x {%2$s}", value2, AnnotationsRenderer.renderIntDef(value2, intDef)), null);
    }

    @NotNull
    static String renderIntDef(int value2, AndroidResolveHelper.IntDefResolution intDef) {
        if (intDef.valuesMap == null) {
            return "";
        }
        if (!intDef.canBeOred) {
            String name = intDef.valuesMap.get(value2);
            return StringUtil.notNullize((String)name);
        }
        StringBuilder sb = new StringBuilder(20);
        for (Map.Entry<Integer, String> entry : intDef.valuesMap.entrySet()) {
            int key = entry.getKey();
            if ((value2 & key) == 0) continue;
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    @NotNull
    private static Result renderResourceRefAnnotation(@Nullable ResourceIdResolver resolver, int value2, String qualifiedName) {
        String androidRes = null;
        if (resolver != null) {
            androidRes = resolver.getAndroidResourceName(value2);
        }
        if (androidRes == null) {
            return AnnotationsRenderer.renderUnknown(qualifiedName, value2);
        }
        String result2 = String.format(Locale.US, "0x%1$08x {%2$s}", value2, androidRes);
        return new Result(result2, null);
    }

    @NotNull
    private static Result renderColorInt(int value2) {
        int alpha = value2 >>> 24;
        boolean hasAlpha = alpha != 0;
        Color color = new Color(value2, hasAlpha);
        String result2 = String.format(Locale.US, "0x%1$08x {a=%2$02d r=%3$02d g=%4$02d b=%5$02d}", value2, color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
        return new Result(result2, (Icon)JBUI.scale((JBUI.JBIcon)new ColorIcon(16, 12, color, true)));
    }

    @NotNull
    private static Result renderUnknown(@Nullable String annotationName, int value2) {
        return new Result(String.format("0x%1$08x {@%2$s ?}", value2, annotationName == null ? "" : AnnotationsRenderer.getSimpleClassName(annotationName)), null);
    }

    @Nullable
    private static String getQualifiedName(final PsiAnnotation annotation) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return annotation.getQualifiedName();
            }
        });
    }

    private static String getSimpleClassName(@NotNull String fqcn) {
        int index = fqcn.lastIndexOf(46);
        return index < fqcn.length() - 1 ? fqcn.substring(index + 1) : fqcn;
    }

    public static class Result {
        @NotNull
        public final String label;
        @Nullable
        public final Icon icon;

        public Result(@NotNull String label, @Nullable Icon icon2) {
            this.label = label;
            this.icon = icon2;
        }
    }
}

