/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class DesugarUtils {
    @NotNull
    public static List<ClassPrepareRequest> addExtraPrepareRequestsIfNeeded(@NotNull DebugProcess debugProcess, final @NotNull ClassPrepareRequestor requestor, final @NotNull SourcePosition position, @NotNull List<ClassPrepareRequest> requests) {
        return (List)ReadAction.compute(() -> {
            PsiMethod methodHolder;
            PsiClass classHolder = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)position.getElementAt(), PsiClass.class);
            if (classHolder != null && classHolder.isInterface() && (methodHolder = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)position.getElementAt(), PsiMethod.class)) != null && methodHolder.getBody() != null) {
                String classPattern = classHolder.getQualifiedName() + "$*";
                ClassPrepareRequestor trampolinePrepareRequestor = new ClassPrepareRequestor(){

                    public void processClassPrepare(DebugProcess debuggerProcess, ReferenceType referenceType) {
                        List locationsOfPosition;
                        try {
                            locationsOfPosition = debuggerProcess.getPositionManager().locationsOfLine(referenceType, position);
                        }
                        catch (NoDataException e) {
                            locationsOfPosition = Collections.emptyList();
                        }
                        if (!locationsOfPosition.isEmpty()) {
                            requestor.processClassPrepare(debuggerProcess, referenceType);
                        }
                    }
                };
                ClassPrepareRequest request = debugProcess.getRequestsManager().createClassPrepareRequest(trampolinePrepareRequestor, classPattern);
                if (request != null) {
                    requests.add(request);
                }
            }
            return requests;
        });
    }

    @NotNull
    public static List<ReferenceType> addExtraClassesIfNeeded(@NotNull DebugProcess debugProcess, @NotNull SourcePosition position, @NotNull List<ReferenceType> types, @NotNull PositionManager positionManager) throws NoDataException {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)debugProcess.getProject());
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)debugProcess.getProject());
        List candidatesForDesugaringCompanion = types.stream().filter(type -> (Boolean)ReadAction.compute(() -> {
            PsiClass psiClass = javaPsiFacade.findClass(type.name(), globalSearchScope);
            return psiClass != null && DesugarUtils.canBeTransformedForDesugaring(psiClass);
        })).collect(Collectors.toList());
        if (candidatesForDesugaringCompanion.isEmpty()) {
            return types;
        }
        ArrayList<ReferenceType> newReferenceTypes = new ArrayList<ReferenceType>(types);
        List allLoadedTypes = debugProcess.getVirtualMachineProxy().allClasses();
        for (ReferenceType candidateType : candidatesForDesugaringCompanion) {
            String innerClassNamePrefix = candidateType.name() + "$";
            for (ReferenceType type2 : allLoadedTypes) {
                if (!type2.name().startsWith(innerClassNamePrefix) || positionManager.locationsOfLine(type2, position).isEmpty()) continue;
                newReferenceTypes.add(type2);
            }
        }
        return newReferenceTypes;
    }

    private static boolean canBeTransformedForDesugaring(@NotNull PsiClass psiClass) {
        if (!psiClass.isInterface()) {
            return false;
        }
        return StreamEx.of((Object[])psiClass.getMethods()).anyMatch(m -> m.getBody() != null);
    }
}

