/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.tools.idea.debug.ResourceIdResolver;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicResourceIdResolver
implements ResourceIdResolver {
    private static final Logger LOG = Logger.getInstance(DynamicResourceIdResolver.class);
    private final EvaluationContext myContext;
    private final ResourceIdResolver myDelegate;

    public DynamicResourceIdResolver(@NotNull EvaluationContext context, @NotNull ResourceIdResolver delegate) {
        this.myContext = context;
        this.myDelegate = delegate;
    }

    @Override
    @Nullable
    public String getAndroidResourceName(int resId) {
        ReferenceType resourcesClassType;
        Method getResourceNameMethod;
        String id = this.myDelegate.getAndroidResourceName(resId);
        if (id != null) {
            return id;
        }
        DebugProcess debugProcess = this.myContext.getDebugProcess();
        VirtualMachineProxyImpl vmProxy = (VirtualMachineProxyImpl)debugProcess.getVirtualMachineProxy();
        List classes = vmProxy.classesByName("android.content.res.Resources");
        if (classes.isEmpty()) {
            LOG.warn("android.content.res.Resources class not loaded?");
            return null;
        }
        if (classes.size() != 1) {
            LOG.warn("Expected a single Resource class loaded, but found " + classes.size());
        }
        if ((getResourceNameMethod = DebuggerUtils.findMethod((ReferenceType)(resourcesClassType = (ReferenceType)classes.get(0)), (String)"getResourceName", (String)"(I)Ljava/lang/String;")) == null) {
            LOG.warn("Unable to locate getResourceName(int id) in class " + resourcesClassType.name());
            return null;
        }
        List<ObjectReference> instances = resourcesClassType.instances(10L);
        if (instances.isEmpty()) {
            LOG.warn("No instances of Resource class found");
            return null;
        }
        List<Value> args = Collections.singletonList(DebuggerUtilsEx.createValue((VirtualMachineProxyImpl)vmProxy, (String)"int", (long)resId));
        for (ObjectReference ref : instances) {
            try {
                Value value2 = debugProcess.invokeMethod(this.myContext, ref, getResourceNameMethod, args);
                if (!(value2 instanceof StringReference)) continue;
                StringReference nameRef = (StringReference)value2;
                return nameRef.value();
            }
            catch (EvaluateException e) {
                ObjectReference exception = e.getExceptionFromTargetVM();
                if (exception != null && DebuggerUtils.instanceOf((Type)exception.type(), (String)"android.content.res.Resources$NotFoundException")) continue;
                LOG.warn("Unexpected error while invoking Resources.getResourceName()", (Throwable)e);
            }
        }
        return null;
    }
}

