/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.deploy;

import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.DeploymentService;
import com.android.tools.idea.run.deployable.DeployableProvider;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxDeployableProvider;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxTargetProvider;
import com.android.tools.idea.run.editor.ChooserDeployableProvider;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.ShowChooserTargetProvider;
import com.android.tools.idea.run.ui.ApplyChangesAction;
import com.android.tools.idea.run.ui.CodeSwapAction;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployActionsInitializer {
    public static void installActions() {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction runnerActions = actionManager.getAction("RunnerActions");
        DefaultActionGroup ag = (DefaultActionGroup)runnerActions;
        PluginId androidPluginId = PluginId.findId((String[])new String[]{"org.jetbrains.android"});
        ApplyChangesAction applyChanges2 = new ApplyChangesAction();
        actionManager.registerAction("android.deploy.ApplyChanges", (AnAction)applyChanges2, androidPluginId);
        ag.add((AnAction)applyChanges2, new Constraints(Anchor.AFTER, "Run"));
        CodeSwapAction codeSwap = new CodeSwapAction();
        actionManager.registerAction("android.deploy.CodeSwap", (AnAction)codeSwap, androidPluginId);
        ag.add((AnAction)codeSwap, new Constraints(Anchor.AFTER, "android.deploy.ApplyChanges"));
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)ApplicationManager.getApplication()).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(final @NotNull Project project) {
                MessageBusConnection projectConnection = project.getMessageBus().connect((Disposable)project);
                projectConnection.subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

                    public void runConfigurationSelected() {
                        DeployActionsInitializer.updateDeployableProvider(project, RunManager.getInstance((Project)project).getSelectedConfiguration());
                    }

                    public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings, @Nullable String existingId) {
                        this.runConfigurationChanged(settings);
                    }

                    public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                        if (settings.getConfiguration() == RunManager.getInstance((Project)project).getSelectedConfiguration()) {
                            DeployActionsInitializer.updateDeployableProvider(project, settings);
                        }
                    }

                    public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                        if (settings.getConfiguration() == RunManager.getInstance((Project)project).getSelectedConfiguration()) {
                            DeployActionsInitializer.updateDeployableProvider(project, null);
                        }
                    }
                });
                projectConnection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

                    public void beforeFacetRemoved(@NotNull Facet facet) {
                        RunnerAndConfigurationSettings selectedConfiguration = RunManager.getInstance((Project)project).getSelectedConfiguration();
                        if (facet instanceof AndroidFacet && facet.getModule() == DeployActionsInitializer.getModule(DeployActionsInitializer.getAndroidRunConfigurationbase(selectedConfiguration))) {
                            DeployActionsInitializer.updateDeployableProvider(project, null);
                        }
                    }

                    public void facetAdded(@NotNull Facet facet) {
                        RunnerAndConfigurationSettings selectedConfiguration = RunManager.getInstance((Project)project).getSelectedConfiguration();
                        if (facet instanceof AndroidFacet && facet.getModule() == DeployActionsInitializer.getModule(DeployActionsInitializer.getAndroidRunConfigurationbase(selectedConfiguration))) {
                            DeployActionsInitializer.updateDeployableProvider(project, selectedConfiguration);
                        }
                    }
                });
                DeployActionsInitializer.updateDeployableProvider(project, RunManager.getInstance((Project)project).getSelectedConfiguration());
            }
        });
    }

    @Contract(value="null -> null")
    @Nullable
    private static AndroidRunConfigurationBase getAndroidRunConfigurationbase(@Nullable RunnerAndConfigurationSettings configSettings) {
        if (configSettings == null) {
            return null;
        }
        RunConfiguration config = configSettings.getConfiguration();
        if (!(config instanceof AndroidRunConfigurationBase)) {
            return null;
        }
        return (AndroidRunConfigurationBase)config;
    }

    @Contract(value="null -> null")
    @Nullable
    private static Module getModule(@Nullable AndroidRunConfigurationBase androidRunConfigurationBase) {
        return androidRunConfigurationBase == null ? null : ((JavaRunConfigurationModule)androidRunConfigurationBase.getConfigurationModule()).getModule();
    }

    @Contract(value="null -> null")
    @Nullable
    private static DeployableProvider getDeployTargetProvider(@Nullable RunnerAndConfigurationSettings configSettings) {
        AndroidRunConfigurationBase androidRunConfig = DeployActionsInitializer.getAndroidRunConfigurationbase(configSettings);
        Module module = DeployActionsInitializer.getModule(androidRunConfig);
        if (module == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        if (facet.isDisposed()) {
            Logger.getInstance(DeployActionsInitializer.class).warn("Facet is disposed for the selected configuration.");
            return null;
        }
        DeployTargetProvider currentTargetProvider = androidRunConfig.getDeployTargetContext().getCurrentDeployTargetProvider();
        if (currentTargetProvider instanceof ShowChooserTargetProvider) {
            return new ChooserDeployableProvider(androidRunConfig, facet, (ShowChooserTargetProvider)currentTargetProvider);
        }
        if (currentTargetProvider instanceof DeviceAndSnapshotComboBoxTargetProvider) {
            ApplicationIdProvider applicationIdProvider = androidRunConfig.getApplicationIdProvider(facet);
            return new DeviceAndSnapshotComboBoxDeployableProvider(module.getProject(), applicationIdProvider);
        }
        return null;
    }

    private static boolean canOverrideDeployableProvider(@Nullable DeployableProvider provider) {
        return provider == null || provider instanceof ChooserDeployableProvider || provider instanceof DeviceAndSnapshotComboBoxDeployableProvider;
    }

    private static void updateDeployableProvider(@NotNull Project project, @Nullable RunnerAndConfigurationSettings configSettings) {
        DeploymentService deploymentService = DeploymentService.getInstance(project);
        if (DeployActionsInitializer.canOverrideDeployableProvider(deploymentService.getDeployableProvider())) {
            deploymentService.setDeployableProvider(DeployActionsInitializer.getDeployTargetProvider(configSettings));
        }
    }
}

