/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.deploy;

import com.android.tools.idea.deploy.DeploymentConfiguration;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class DeploymentConfigurable
implements Configurable,
Configurable.NoScroll {
    private final DeploymentConfiguration myConfiguration;
    private JPanel myContentPanel;
    private JBCheckBox myRunAfterApplyChanges;
    private JBCheckBox myRunAfterApplyCodeChanges;

    public DeploymentConfigurable() {
        this.$$$setupUI$$$();
        this.myConfiguration = DeploymentConfiguration.getInstance();
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return "Deployment";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myContentPanel;
    }

    public boolean isModified() {
        return this.myConfiguration.APPLY_CHANGES_FALLBACK_TO_RUN != this.myRunAfterApplyChanges.isSelected() || this.myConfiguration.APPLY_CODE_CHANGES_FALLBACK_TO_RUN != this.myRunAfterApplyCodeChanges.isSelected();
    }

    public void apply() throws ConfigurationException {
        this.myConfiguration.APPLY_CHANGES_FALLBACK_TO_RUN = this.myRunAfterApplyChanges.isSelected();
        this.myConfiguration.APPLY_CODE_CHANGES_FALLBACK_TO_RUN = this.myRunAfterApplyCodeChanges.isSelected();
    }

    public void reset() {
        this.myRunAfterApplyChanges.setSelected(this.myConfiguration.APPLY_CHANGES_FALLBACK_TO_RUN);
        this.myRunAfterApplyCodeChanges.setSelected(this.myConfiguration.APPLY_CODE_CHANGES_FALLBACK_TO_RUN);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel;
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRunAfterApplyChanges = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Automatically perform \"Run\" when Apply Changes fails");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myRunAfterApplyCodeChanges = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Automatically perform \"Run\" when Apply Code Changes fails");
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Enabling these options trigger an automatic rerun of your app only if there is an incompatible change when using Apply Changes.");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("In some cases, when Apply Changes or Apply Code Changes succeeds, you might need to manually restart your app to see your changes.");
        jPanel.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("For example, to see changes you made in your Activity's onCreate() method.");
        jPanel.add((Component)jBLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

