/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics;

import com.android.annotations.concurrency.Slow;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.diagnostics.AndroidStudioSystemHealthMonitor;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.GradleBuildListener;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.WindowsDefenderStatus;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowsPerformanceHintsChecker {
    private static final Logger LOG = Logger.getInstance(WindowsPerformanceHintsChecker.class);
    private static final String ANTIVIRUS_NOTIFICATION_LAST_SHOWN_TIME_KEY = "antivirus.scan.notification.last.shown.time";
    private static final Duration ANTIVIRUS_MIN_INTERVAL_BETWEEN_NOTIFICATIONS = Duration.ofDays(1L);
    private static final Pattern WINDOWS_ENV_VAR_PATTERN = Pattern.compile("%([^%]+?)%");
    private static final Pattern WINDOWS_DEFENDER_WILDCARD_PATTERN = Pattern.compile("[?*]");
    private static final int POWERSHELL_COMMAND_TIMEOUT_MS = 10000;
    private static final int MAX_POWERSHELL_STDERR_LENGTH = 500;
    private AndroidStudioSystemHealthMonitor systemHealthMonitor = AndroidStudioSystemHealthMonitor.getInstance();

    public void run() {
        if (SystemInfo.isWindows && (((Boolean)StudioFlags.ANTIVIRUS_METRICS_ENABLED.get()).booleanValue() || ((Boolean)StudioFlags.ANTIVIRUS_NOTIFICATION_ENABLED.get()).booleanValue())) {
            final Application application = ApplicationManager.getApplication();
            application.getMessageBus().connect((Disposable)application).subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectOpened(final @NotNull Project project) {
                    application.executeOnPooledThread(() -> WindowsPerformanceHintsChecker.this.checkWindowsDefender(project, false));
                    GradleBuildState.subscribe(project, new GradleBuildListener(){

                        @Override
                        public void buildExecutorCreated(@NotNull GradleBuildInvoker.Request request) {
                        }

                        @Override
                        public void buildStarted(@NotNull BuildContext context) {
                        }

                        @Override
                        public void buildFinished(@NotNull BuildStatus status, @Nullable BuildContext context) {
                            BuildMode mode;
                            BuildMode buildMode = mode = context != null ? context.getBuildMode() : null;
                            if (status == BuildStatus.SUCCESS && (mode == BuildMode.ASSEMBLE || mode == BuildMode.ASSEMBLE_TRANSLATE || mode == BuildMode.REBUILD || mode == BuildMode.BUNDLE || mode == BuildMode.APK_FROM_BUNDLE)) {
                                application.executeOnPooledThread(() -> WindowsPerformanceHintsChecker.this.checkWindowsDefender(project, true));
                            }
                        }
                    });
                }
            });
        }
    }

    @Slow
    private void checkWindowsDefender(@NotNull Project project, boolean showNotification2) {
        switch (WindowsPerformanceHintsChecker.getRealtimeScanningEnabled()) {
            case SCANNING_ENABLED: {
                WindowsDefenderStatus.Status overallStatus;
                List<Pattern> excludedPatterns = WindowsPerformanceHintsChecker.getExcludedPatterns();
                if (excludedPatterns == null) {
                    WindowsPerformanceHintsChecker.logWindowsDefenderStatus(WindowsDefenderStatus.Status.UNKNOWN_STATUS, false, project);
                    break;
                }
                Map<Path, Boolean> pathStatuses = WindowsPerformanceHintsChecker.checkPathsExcluded(WindowsPerformanceHintsChecker.getImportantPaths(project), excludedPatterns);
                if (pathStatuses.containsValue(Boolean.FALSE)) {
                    if (showNotification2 && ((Boolean)StudioFlags.ANTIVIRUS_NOTIFICATION_ENABLED.get()).booleanValue() && !WindowsPerformanceHintsChecker.shownRecently()) {
                        this.showAntivirusNotification(project, WindowsPerformanceHintsChecker.getNotificationTextForNonExcludedPaths(pathStatuses));
                        WindowsPerformanceHintsChecker.setLastShownTime();
                    }
                    overallStatus = pathStatuses.containsValue(Boolean.TRUE) ? WindowsDefenderStatus.Status.SOME_EXCLUDED : WindowsDefenderStatus.Status.NONE_EXCLUDED;
                } else {
                    overallStatus = WindowsDefenderStatus.Status.ALL_EXCLUDED;
                }
                String projectDir = project.getBasePath();
                boolean projectPathExcluded = false;
                if (projectDir != null) {
                    projectPathExcluded = pathStatuses.getOrDefault(Paths.get(projectDir, new String[0]), false);
                }
                WindowsPerformanceHintsChecker.logWindowsDefenderStatus(overallStatus, projectPathExcluded, project);
                break;
            }
            case SCANNING_DISABLED: {
                WindowsPerformanceHintsChecker.logWindowsDefenderStatus(WindowsDefenderStatus.Status.SCANNING_DISABLED, true, project);
                break;
            }
            case ERROR: {
                WindowsPerformanceHintsChecker.logWindowsDefenderStatus(WindowsDefenderStatus.Status.UNKNOWN_STATUS, false, project);
            }
        }
    }

    private void showAntivirusNotification(@NotNull Project project, @NotNull String pathDetails) {
        final String key = "virus.scanning.warn.message";
        boolean ignored = false;
        final PropertiesComponent applicationProperties = PropertiesComponent.getInstance();
        final PropertiesComponent projectProperties = PropertiesComponent.getInstance((Project)project);
        if (applicationProperties != null) {
            ignored = applicationProperties.isValueSet("ignore." + key);
        }
        if (projectProperties != null) {
            ignored |= projectProperties.isValueSet("ignore." + key);
        }
        LOG.info("issue detected: " + key + (ignored ? " (ignored)" : ""));
        if (ignored) {
            return;
        }
        AndroidStudioSystemHealthMonitor androidStudioSystemHealthMonitor = this.systemHealthMonitor;
        androidStudioSystemHealthMonitor.getClass();
        AndroidStudioSystemHealthMonitor.MyNotification notification = androidStudioSystemHealthMonitor.new AndroidStudioSystemHealthMonitor.MyNotification(AndroidBundle.message(key, pathDetails));
        notification.addAction((AnAction)new NotificationAction(AndroidBundle.message("virus.scanning.dont.show.again", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                notification.expire();
                if (applicationProperties != null) {
                    applicationProperties.setValue("ignore." + key, "true");
                }
            }
        });
        notification.addAction((AnAction)new NotificationAction(AndroidBundle.message("virus.scanning.dont.show.again.this.project", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                notification.expire();
                if (projectProperties != null) {
                    projectProperties.setValue("ignore." + key, "true");
                }
            }
        });
        notification.addAction((AnAction)AndroidStudioSystemHealthMonitor.detailsAction("https://d.android.com/r/studio-ui/antivirus-check"));
        notification.setImportant(true);
        ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)notification));
    }

    private static boolean shownRecently() {
        if ("true".equals(System.getProperty("disable.antivirus.notification.rate.limit"))) {
            return false;
        }
        String lastShownTime = PropertiesComponent.getInstance().getValue(ANTIVIRUS_NOTIFICATION_LAST_SHOWN_TIME_KEY);
        if (lastShownTime == null) {
            return false;
        }
        try {
            Instant lastShown = Instant.parse(lastShownTime);
            return lastShown.plus(ANTIVIRUS_MIN_INTERVAL_BETWEEN_NOTIFICATIONS).isAfter(Instant.now());
        }
        catch (DateTimeException e) {
            WindowsPerformanceHintsChecker.setLastShownTime();
            return false;
        }
    }

    private static void setLastShownTime() {
        PropertiesComponent.getInstance().setValue(ANTIVIRUS_NOTIFICATION_LAST_SHOWN_TIME_KEY, Instant.now().toString());
    }

    private static void logWindowsDefenderStatus(WindowsDefenderStatus.Status status, boolean projectDirExcluded, @NotNull Project project) {
        LOG.info("Windows Defender status: " + status + "; projectDirExcluded? " + projectDirExcluded);
        if (((Boolean)StudioFlags.ANTIVIRUS_METRICS_ENABLED.get()).booleanValue() && !ApplicationManager.getApplication().isInternal() && StatisticsUploadAssistant.isSendAllowed()) {
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.WINDOWS_DEFENDER_STATUS).setWindowsDefenderStatus(WindowsDefenderStatus.newBuilder().setProjectDirExcluded(projectDirExcluded).setStatus(status)), project));
        }
    }

    @Slow
    @Nullable
    private static List<Pattern> getExcludedPatterns() {
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"powershell", "-inputformat", "none", "-outputformat", "text", "-NonInteractive", "-Command", "Get-MpPreference | select -ExpandProperty \"ExclusionPath\""}), (int)10000);
            if (output.getExitCode() == 0) {
                return output.getStdoutLines(true).stream().map(path -> WindowsPerformanceHintsChecker.wildcardsToRegex(WindowsPerformanceHintsChecker.expandEnvVars(path))).collect(Collectors.toList());
            }
            LOG.warn("Windows Defender exclusion path check exited with status " + output.getExitCode() + ": " + StringUtil.first((String)output.getStderr(), (int)500, (boolean)false));
        }
        catch (ExecutionException e) {
            LOG.warn("Windows Defender exclusion path check failed", (Throwable)e);
        }
        return null;
    }

    @Slow
    @NotNull
    private static RealtimeScanningStatus getRealtimeScanningEnabled() {
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"powershell", "-inputformat", "none", "-outputformat", "text", "-NonInteractive", "-Command", "Get-MpPreference | select -ExpandProperty \"DisableRealtimeMonitoring\""}), (int)10000);
            if (output.getExitCode() == 0) {
                if (output.getStdout().startsWith("False")) {
                    return RealtimeScanningStatus.SCANNING_ENABLED;
                }
                return RealtimeScanningStatus.SCANNING_DISABLED;
            }
            LOG.warn("Windows Defender realtime scanning status check exited with status " + output.getExitCode() + ": " + StringUtil.first((String)output.getStderr(), (int)500, (boolean)false));
        }
        catch (ExecutionException e) {
            LOG.warn("Windows Defender realtime scanning status check failed", (Throwable)e);
        }
        return RealtimeScanningStatus.ERROR;
    }

    @NotNull
    private static List<Path> getImportantPaths(@NotNull Project project) {
        String homeDir = System.getProperty("user.home");
        String gradleUserHome = System.getenv("GRADLE_USER_HOME");
        String projectDir = project.getBasePath();
        ArrayList<Path> paths2 = new ArrayList<Path>();
        if (projectDir != null) {
            paths2.add(Paths.get(projectDir, new String[0]));
        }
        paths2.add(Paths.get(PathManager.getSystemPath(), new String[0]));
        if (gradleUserHome != null) {
            paths2.add(Paths.get(gradleUserHome, new String[0]));
        } else {
            paths2.add(Paths.get(homeDir, ".gradle"));
        }
        AndroidSdkData sdkData = AndroidSdkUtils.getProjectSdkData(project);
        if (sdkData == null) {
            sdkData = AndroidSdkUtils.getFirstAndroidModuleSdkData(project);
        }
        if (sdkData != null) {
            paths2.add(Paths.get(sdkData.getLocation().getAbsolutePath(), new String[0]));
        }
        return paths2;
    }

    @NotNull
    private static String expandEnvVars(@NotNull String path) {
        Matcher m = WINDOWS_ENV_VAR_PATTERN.matcher(path);
        StringBuffer result2 = new StringBuffer();
        while (m.find()) {
            String value2 = System.getenv(m.group(1));
            if (value2 == null) continue;
            m.appendReplacement(result2, Matcher.quoteReplacement(value2));
        }
        m.appendTail(result2);
        return result2.toString();
    }

    @NotNull
    private static Pattern wildcardsToRegex(@NotNull String path) {
        Matcher m = WINDOWS_DEFENDER_WILDCARD_PATTERN.matcher(path);
        StringBuilder sb = new StringBuilder();
        int previousWildcardEnd = 0;
        while (m.find()) {
            sb.append(Pattern.quote(path.substring(previousWildcardEnd, m.start())));
            if (m.group().equals("?")) {
                sb.append("[^\\\\]");
            } else {
                sb.append("[^\\\\]*");
            }
            previousWildcardEnd = m.end();
        }
        sb.append(Pattern.quote(path.substring(previousWildcardEnd)));
        sb.append(".*");
        return Pattern.compile(sb.toString(), 2);
    }

    @NotNull
    private static Map<Path, Boolean> checkPathsExcluded(@NotNull List<Path> paths2, @NotNull List<Pattern> excludedPatterns) {
        HashMap<Path, Boolean> result2 = new HashMap<Path, Boolean>();
        for (Path path : paths2) {
            try {
                String canonical = path.toRealPath(new LinkOption[0]).toString();
                boolean found = false;
                for (Pattern pattern : excludedPatterns) {
                    if (!pattern.matcher(canonical).matches()) continue;
                    found = true;
                    result2.put(path, true);
                    break;
                }
                if (found) continue;
                result2.put(path, false);
            }
            catch (IOException e) {
                LOG.warn("Windows Defender exclusion check couldn't get real path for " + path, (Throwable)e);
            }
        }
        return result2;
    }

    @NotNull
    private static String getNotificationTextForNonExcludedPaths(@NotNull Map<Path, Boolean> pathStatuses) {
        StringBuilder sb = new StringBuilder();
        pathStatuses.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).forEach(entry -> sb.append("<br/>" + entry.getKey()));
        return sb.toString();
    }

    private static enum RealtimeScanningStatus {
        SCANNING_DISABLED,
        SCANNING_ENABLED,
        ERROR;

    }
}

