/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.idea.diagnostics.crash.BaseStudioReport;
import com.android.tools.idea.diagnostics.crash.exception.JvmCrashException;
import com.android.tools.idea.diagnostics.crash.exception.NonGracefulExitException;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class StudioCrashReport
extends BaseStudioReport {
    private final List<String> descriptions;
    private final boolean isJvmCrash;
    private final long uptimeInMs;

    private StudioCrashReport(String version2, List<String> descriptions, Map<String, String> productData, boolean isJvmCrash, long uptimeInMs) {
        super(version2, productData, "Crash");
        this.descriptions = descriptions;
        this.isJvmCrash = isJvmCrash;
        this.uptimeInMs = uptimeInMs;
    }

    @Override
    protected void serializeTo(MultipartEntityBuilder builder) {
        super.serializeTo(builder);
        builder.addTextBody("numCrashes", Integer.toString(this.descriptions.size()));
        builder.addTextBody("crashDesc", Joiner.on((String)"\n\n").join(this.descriptions));
        Exception exception = this.isJvmCrash ? new JvmCrashException() : new NonGracefulExitException();
        String[] exceptionInfoAllLines = Throwables.getStackTraceAsString((Throwable)exception).split("[\\r\\n]+");
        String exceptionInfo = Arrays.stream(exceptionInfoAllLines).limit(2L).collect(Collectors.joining("\n"));
        builder.addTextBody("exception_info", exceptionInfo);
    }

    protected void overrideDefaultParameters(Map<String, String> parameters2) {
        if (this.uptimeInMs >= 0L) {
            parameters2.put("ptime", Long.toString(this.uptimeInMs));
        }
    }

    public static class Builder
    extends CrashReport.BaseBuilder<StudioCrashReport, Builder> {
        private List<String> descriptions;
        private boolean isJvmCrash = false;
        private long uptimeInMs = -1L;

        protected Builder getThis() {
            return this;
        }

        public Builder setDescriptions(List<String> descriptions) {
            this.descriptions = descriptions;
            return this;
        }

        public Builder setIsJvmCrash(boolean isJvmCrash) {
            this.isJvmCrash = isJvmCrash;
            return this;
        }

        public Builder setUptimeInMs(long uptimeInMs) {
            this.uptimeInMs = uptimeInMs;
            return this;
        }

        public StudioCrashReport build() {
            return new StudioCrashReport(this.getVersion(), this.descriptions, this.getProductData(), this.isJvmCrash, this.uptimeInMs);
        }
    }
}

