/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.crash;

import com.android.tools.analytics.crash.CrashReport;
import com.android.tools.idea.diagnostics.crash.BaseStudioReport;
import com.android.tools.idea.diagnostics.crash.exception.NoPiiException;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.intellij.diagnostic.IdeErrorsDialog;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class StudioExceptionReport
extends BaseStudioReport {
    private static final ImmutableList<Class<? extends Throwable>> THROWABLE_CLASSES_TO_TRACK_MESSAGES = ImmutableList.of(LinkageError.class, ReflectiveOperationException.class, ArrayIndexOutOfBoundsException.class, ClassCastException.class, IndexOutOfBoundsException.class, NoPiiException.class);
    public static final String KEY_EXCEPTION_INFO = "exception_info";
    private static final String ANDROID_EXCEPTION_TEXT = "com.android.diagnostic.LoggerErrorMessage";
    private final String exceptionInfo;
    private final boolean userReported;
    private final PluginId pluginId;

    private StudioExceptionReport(String version2, String exceptionInfo, boolean userReported, PluginId pluginId, Map<String, String> productData) {
        super(version2, productData, "Exception");
        this.exceptionInfo = exceptionInfo;
        this.userReported = userReported;
        this.pluginId = pluginId;
    }

    @Override
    protected void serializeTo(MultipartEntityBuilder builder) {
        super.serializeTo(builder);
        if (this.isKotlinOnStack()) {
            builder.addTextBody("kotlinVersion", this.getKotlinPluginVersionDescription());
        }
        try {
            IdeaPluginDescriptor plugin = PluginManager.getPlugin((PluginId)this.pluginId);
            if (plugin != null) {
                String name = plugin.getName();
                String version2 = plugin.getVersion();
                builder.addTextBody("plugin.name", name);
                builder.addTextBody("plugin.version", version2);
            }
        }
        catch (Throwable ignored) {
            builder.addTextBody("plugin.name", "exceptionWhileReadingNameVersion");
        }
        builder.addTextBody("userReported", this.userReported ? "1" : "0");
        builder.addTextBody(KEY_EXCEPTION_INFO, this.exceptionInfo);
    }

    private boolean isKotlinOnStack() {
        return this.exceptionInfo.contains("\tat org.jetbrains.kotlin");
    }

    protected String getKotlinPluginVersionDescription() {
        try {
            IdeaPluginDescriptor[] pluginDescriptors = PluginManagerCore.getPlugins();
            return Arrays.stream(pluginDescriptors).filter(d -> d.getPluginId() != null && d.getPluginId().getIdString().equals("org.jetbrains.kotlin") && d.isEnabled()).findFirst().map(d -> d.getVersion()).orElse("pluginNotLoaded");
        }
        catch (Exception ignored) {
            return "exceptionWhenReadingVersion";
        }
    }

    public static Throwable getRootCause(Throwable t) {
        int depth = 0;
        while (depth++ < 20) {
            if (t.getCause() == null) {
                return t;
            }
            t = t.getCause();
        }
        return t;
    }

    public static String getDescription(Throwable t) {
        return StudioExceptionReport.getDescription(t, false);
    }

    public static String getDescription(Throwable t, boolean userReported) {
        int i2;
        if (userReported || THROWABLE_CLASSES_TO_TRACK_MESSAGES.stream().anyMatch(c -> c.isInstance(t))) {
            String traceAsString = Throwables.getStackTraceAsString((Throwable)t);
            return StudioExceptionReport.fixStackTraceStringForLoggerErrorMethod(traceAsString);
        }
        StackTraceElement[] stackTraceElements = t.getStackTrace();
        boolean exceptionFromLoggerErrorMethod = stackTraceElements != null && stackTraceElements.length >= 1 && Objects.equals(stackTraceElements[0].getMethodName(), "error") && Objects.equals(stackTraceElements[0].getClassName(), Logger.class.getName()) && Objects.equals(t.getClass(), Throwable.class);
        StringBuilder sb = new StringBuilder(256);
        sb.append(exceptionFromLoggerErrorMethod ? ANDROID_EXCEPTION_TEXT : t.getClass().getName());
        sb.append(": <elided>\n");
        int n = i2 = exceptionFromLoggerErrorMethod ? 1 : 0;
        while (i2 < stackTraceElements.length) {
            StackTraceElement el = stackTraceElements[i2];
            sb.append("\tat ");
            sb.append(el);
            sb.append('\n');
            ++i2;
        }
        return sb.toString();
    }

    private static String fixStackTraceStringForLoggerErrorMethod(String s) {
        String[] lines = s.split("\n");
        if (lines.length <= 2) {
            return s;
        }
        int indexOfFirstFrame = -1;
        for (int i2 = 1; i2 < lines.length; ++i2) {
            if (!lines[i2].startsWith("\tat ")) continue;
            indexOfFirstFrame = i2;
            break;
        }
        String throwableText = Throwable.class.getName();
        String throwableColonText = throwableText + ":";
        if (indexOfFirstFrame != -1 && (lines[0].equals(throwableText) || lines[0].startsWith(throwableColonText)) && lines[indexOfFirstFrame].startsWith("\tat " + Logger.class.getName() + ".error(")) {
            lines[0] = lines[0].equals(throwableText) ? ANDROID_EXCEPTION_TEXT : ANDROID_EXCEPTION_TEXT + lines[0].substring(throwableText.length());
            Stream<String> newLines = Stream.concat(Arrays.stream(lines).limit(indexOfFirstFrame), Arrays.stream(lines).skip(indexOfFirstFrame + 1));
            return newLines.collect(Collectors.joining("\n"));
        }
        return s;
    }

    public static class Builder
    extends CrashReport.BaseBuilder<StudioExceptionReport, Builder> {
        private String exceptionInfo;
        private boolean userReported;
        private PluginId pluginId;

        protected Builder getThis() {
            return this;
        }

        public Builder setThrowable(Throwable throwable, boolean userReported) {
            Throwable cause = StudioExceptionReport.getRootCause(throwable);
            this.exceptionInfo = StudioExceptionReport.getDescription(cause, userReported);
            this.userReported = userReported;
            this.pluginId = IdeErrorsDialog.findPluginId((Throwable)cause);
            return this;
        }

        public StudioExceptionReport build() {
            return new StudioExceptionReport(this.getVersion(), this.exceptionInfo, this.userReported, this.pluginId, this.getProductData());
        }
    }
}

