/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.error;

import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.diagnostics.crash.StudioExceptionReport;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubmitCrashReportTask
extends Task.Backgroundable {
    private final Consumer<String> myCallback;
    private final Consumer<Exception> myErrorCallback;
    private final Throwable myThrowable;
    private final Map<String, String> myParams;

    public SubmitCrashReportTask(@Nullable Project project, @NotNull String title, boolean canBeCancelled, @Nullable Throwable throwable, @NotNull Map<String, String> params, @NotNull Consumer<String> callback2, @NotNull Consumer<Exception> errorCallback) {
        super(project, title, canBeCancelled);
        this.myThrowable = throwable;
        this.myParams = params;
        this.myCallback = callback2;
        this.myErrorCallback = errorCallback;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        indicator.setIndeterminate(true);
        StudioExceptionReport report = ((StudioExceptionReport.Builder)new StudioExceptionReport.Builder().setThrowable(this.myThrowable, true).addProductData(this.getProductData())).build();
        CompletableFuture future2 = StudioCrashReporter.getInstance().submit(report, true);
        try {
            String token = (String)future2.get(20L, TimeUnit.SECONDS);
            this.myCallback.consume((Object)token);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.myErrorCallback.consume((Object)e);
        }
    }

    @NotNull
    private Map<String, String> getProductData() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        this.myParams.forEach((k, v) -> builder.put(k, (Object)StringUtil.notNullize((String)v)));
        return builder.build();
    }
}

