/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.action;

import com.android.tools.idea.diagnostics.AndroidStudioSystemHealthMonitor;
import com.android.tools.idea.diagnostics.hprof.action.AnalysisRunnable;
import com.android.tools.idea.diagnostics.hprof.action.HeapDumpSnapshotRunnable$CaptureHeapDumpTask$WhenMappings;
import com.android.tools.idea.diagnostics.hprof.action.HeapDumpSnapshotRunnable$sam$java_lang_Runnable$0;
import com.android.tools.idea.diagnostics.hprof.analysis.LiveInstanceStats;
import com.android.tools.idea.diagnostics.hprof.util.HeapDumpAnalysisNotificationGroup;
import com.android.tools.idea.diagnostics.report.HeapReportProperties;
import com.android.tools.idea.diagnostics.report.MemoryReportReason;
import com.android.tools.idea.diagnostics.report.UnanalyzedHeapReport;
import com.android.tools.idea.ui.GuiTestingService;
import com.android.utils.TraceUtils;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.FileAlreadyExistsException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0003\u000b\f\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable;", "Ljava/lang/Runnable;", "reason", "Lcom/android/tools/idea/diagnostics/report/MemoryReportReason;", "analysisOption", "Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable$AnalysisOption;", "(Lcom/android/tools/idea/diagnostics/report/MemoryReportReason;Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable$AnalysisOption;)V", "estimateRequiredFreeSpaceInMB", "", "run", "", "AnalysisOption", "CaptureHeapDumpTask", "Companion", "intellij.android.core"})
public final class HeapDumpSnapshotRunnable
implements Runnable {
    private final MemoryReportReason reason;
    private final AnalysisOption analysisOption;
    public static final int MINIMUM_USED_MEMORY_TO_CAPTURE_HEAP_DUMP_IN_MB = 800;
    @NotNull
    public static final String NEXT_CHECK_TIMESTAMP_KEY = "heap.dump.snapshot.next.check.timestamp";
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void run() {
        long estimatedRequiredMB;
        Path hprofPath;
        long spaceInMB;
        LOG.info("HeapDumpSnapshotRunnable started: reason=" + (Object)((Object)this.reason) + ", analysisOption=" + (Object)((Object)this.analysisOption));
        boolean userInvoked = this.reason.isUserInvoked();
        if (!userInvoked) {
            long currentTimestampMs;
            if (ApplicationManager.getApplication().isUnitTestMode() || GuiTestingService.getInstance().isGuiTestingMode()) {
                LOG.info("Disabled for tests.");
                return;
            }
            if (!ApplicationManager.getApplication().isEAP()) {
                LOG.info("Heap dump analysis is enabled only on EAP builds.");
                return;
            }
            if (Intrinsics.areEqual((Object)System.getProperty("sun.arch.data.model"), (Object)"64") ^ true) {
                LOG.info("Heap dump analysis supported only on 64-bit platforms.");
                return;
            }
            boolean withGC$iv = false;
            boolean $i$f$usedMemory = false;
            Runtime rt$iv = Runtime.getRuntime();
            long usedMemoryMB = (rt$iv.totalMemory() - rt$iv.freeMemory()) / (long)1000000;
            if (usedMemoryMB < (long)800) {
                LOG.info("Heap dump too small: " + usedMemoryMB + " MB < 800 MB");
                return;
            }
            long nextCheckPropertyMs = PropertiesComponent.getInstance().getOrInitLong(NEXT_CHECK_TIMESTAMP_KEY, 0L);
            if (nextCheckPropertyMs > (currentTimestampMs = System.currentTimeMillis())) {
                String nextCheckDateString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.US).format(new Date(nextCheckPropertyMs));
                LOG.info("Don't ask for snapshot until " + nextCheckDateString + '.');
                return;
            }
        }
        if (this.analysisOption == AnalysisOption.SCHEDULE_ON_NEXT_START) {
            try {
                AndroidStudioSystemHealthMonitor instance = AndroidStudioSystemHealthMonitor.getInstance();
                if (instance == null) {
                    LOG.error("Android Studio System Health Monitor not initialized.");
                    return;
                }
                boolean isHeapReportPending = instance.hasPendingHeapReport();
                if (isHeapReportPending) {
                    if (userInvoked) {
                        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                        String message2 = AndroidBundle.message("heap.dump.snapshot.already.pending", productName);
                        Messages.showErrorDialog((String)message2, (String)AndroidBundle.message("heap.dump.snapshot.title", new Object[0]));
                    }
                    LOG.info("Heap report already pending.");
                    return;
                }
            }
            catch (IOException ex) {
                if (userInvoked) {
                    String message3 = AndroidBundle.message("heap.dump.snapshot.error.check.log", new Object[0]);
                    Messages.showErrorDialog((String)message3, (String)AndroidBundle.message("heap.dump.snapshot.title", new Object[0]));
                    LOG.warn("Exception while querying for pending heap report", (Throwable)ex);
                } else {
                    LOG.info("Exception while querying for pending heap report", (Throwable)ex);
                }
                return;
            }
        }
        if ((spaceInMB = Files.getFileStore((hprofPath = AndroidStudioSystemHealthMonitor.ourHProfDatabase.createHprofTemporaryFilePath()).getParent()).getUsableSpace() / (long)1000000) < (estimatedRequiredMB = this.estimateRequiredFreeSpaceInMB())) {
            LOG.info("Not enough space for heap dump: " + spaceInMB + " MB < " + estimatedRequiredMB + " MB");
            if (userInvoked) {
                String message4 = AndroidBundle.message("heap.dump.snapshot.no.space", ((Object)hprofPath.getParent()).toString(), estimatedRequiredMB, spaceInMB);
                Messages.showErrorDialog((String)message4, (String)AndroidBundle.message("heap.dump.snapshot.title", new Object[0]));
            }
            return;
        }
        LOG.info("Capturing heap dump.");
        new CaptureHeapDumpTask(hprofPath, this.reason, this.analysisOption, userInvoked).queue();
    }

    private final long estimateRequiredFreeSpaceInMB() {
        boolean bl = false;
        long l = 100L;
        boolean $i$f$usedMemory = false;
        Runtime rt$iv = Runtime.getRuntime();
        long l2 = rt$iv.totalMemory() - rt$iv.freeMemory();
        return Math.max(l, (long)((double)l2 * 2.0) / (long)1000000);
    }

    public HeapDumpSnapshotRunnable(@NotNull MemoryReportReason reason, @NotNull AnalysisOption analysisOption) {
        this.reason = reason;
        this.analysisOption = analysisOption;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(HeapDumpSnapshotRunnable.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable$AnalysisOption;", "", "(Ljava/lang/String;I)V", "NO_ANALYSIS", "SCHEDULE_ON_NEXT_START", "IMMEDIATE", "intellij.android.core"})
    public static final class AnalysisOption
    extends Enum<AnalysisOption> {
        public static final /* enum */ AnalysisOption NO_ANALYSIS;
        public static final /* enum */ AnalysisOption SCHEDULE_ON_NEXT_START;
        public static final /* enum */ AnalysisOption IMMEDIATE;
        private static final /* synthetic */ AnalysisOption[] $VALUES;

        static {
            AnalysisOption[] analysisOptionArray = new AnalysisOption[3];
            AnalysisOption[] analysisOptionArray2 = analysisOptionArray;
            analysisOptionArray[0] = NO_ANALYSIS = new AnalysisOption();
            analysisOptionArray[1] = SCHEDULE_ON_NEXT_START = new AnalysisOption();
            analysisOptionArray[2] = IMMEDIATE = new AnalysisOption();
            $VALUES = analysisOptionArray;
        }

        public static AnalysisOption[] values() {
            return (AnalysisOption[])$VALUES.clone();
        }

        public static AnalysisOption valueOf(String string) {
            return Enum.valueOf(AnalysisOption.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable$CaptureHeapDumpTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "hprofPath", "Ljava/nio/file/Path;", "reason", "Lcom/android/tools/idea/diagnostics/report/MemoryReportReason;", "analysisOption", "Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable$AnalysisOption;", "restart", "", "(Ljava/nio/file/Path;Lcom/android/tools/idea/diagnostics/report/MemoryReportReason;Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable$AnalysisOption;Z)V", "captureSnapshot", "", "confirmRestart", "onSuccess", "onThrowable", "error", "", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.android.core"})
    public static final class CaptureHeapDumpTask
    extends Task.Modal {
        private final Path hprofPath;
        private final MemoryReportReason reason;
        private final AnalysisOption analysisOption;
        private final boolean restart;

        public void onSuccess() {
            if (this.analysisOption == AnalysisOption.SCHEDULE_ON_NEXT_START && this.restart) {
                Function0 function0 = (Function0)new Function0<Unit>(this){

                    public final void invoke() {
                        CaptureHeapDumpTask.access$confirmRestart((CaptureHeapDumpTask)((Object)this.receiver));
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(CaptureHeapDumpTask.class);
                    }

                    public final String getName() {
                        return "confirmRestart";
                    }

                    public final String getSignature() {
                        return "confirmRestart()V";
                    }
                };
                ApplicationManager.getApplication().invokeLater((Runnable)new HeapDumpSnapshotRunnable$sam$java_lang_Runnable$0(function0), ModalityState.NON_MODAL);
            }
        }

        public void onThrowable(@NotNull Throwable error) {
            LOG.error(error);
            Notification notification = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(AndroidBundle.message("heap.dump.snapshot.exception", new Object[0]), NotificationType.ERROR);
            notification.notify(null);
        }

        private final void confirmRestart() {
            String title = AndroidBundle.message("heap.dump.snapshot.restart.dialog.title", new Object[0]);
            String message2 = AndroidBundle.message("heap.dump.snapshot.restart.dialog.message", new Object[0]);
            String yesString = AndroidBundle.message("heap.dump.snapshot.restart.dialog.restart.now", new Object[0]);
            String noString = AndroidBundle.message("heap.dump.snapshot.restart.dialog.restart.later", new Object[0]);
            int result2 = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)title, (String)message2).yesText(yesString)).noText(noString)).show();
            if (result2 == 0) {
                Application application = ApplicationManager.getApplication();
                if (application == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
                }
                ApplicationEx application2 = (ApplicationEx)application;
                application2.restart(true);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void run(@NotNull ProgressIndicator indicator) {
            void liveStats;
            indicator.setIndeterminate(true);
            String productName = ApplicationNamesInfo.getInstance().getFullProductName();
            if (this.reason.isUserInvoked()) {
                indicator.setText(AndroidBundle.message("heap.dump.snapshot.indicator.text", productName));
            } else {
                indicator.setText(AndroidBundle.message("heap.dump.snapshot.indicator.low.memory.text", productName));
            }
            Thread.sleep(500L);
            this.captureSnapshot();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = "";
            ApplicationManager.getApplication().invokeAndWait(new Runnable((Ref.ObjectRef)liveStats){
                final /* synthetic */ Ref.ObjectRef $liveStats;

                public final void run() {
                    String string;
                    Ref.ObjectRef objectRef;
                    Ref.ObjectRef objectRef2 = this.$liveStats;
                    try {
                        objectRef = objectRef2;
                        string = new LiveInstanceStats().createReport();
                    }
                    catch (Error e) {
                        objectRef = objectRef2;
                        string = "Error while gathering live statistics: " + TraceUtils.getStackTrace((Throwable)e) + '\n';
                    }
                    objectRef.element = string;
                }
                {
                    this.$liveStats = objectRef;
                }
            });
            UnanalyzedHeapReport report = new UnanalyzedHeapReport(this.hprofPath, new HeapReportProperties(this.reason, (String)liveStats.element), null, 4, null);
            switch (HeapDumpSnapshotRunnable$CaptureHeapDumpTask$WhenMappings.$EnumSwitchMapping$0[this.analysisOption.ordinal()]) {
                case 1: {
                    AndroidStudioSystemHealthMonitor androidStudioSystemHealthMonitor = AndroidStudioSystemHealthMonitor.getInstance();
                    if (androidStudioSystemHealthMonitor != null) {
                        androidStudioSystemHealthMonitor.addHeapReportToDatabase(report);
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, productName){
                        final /* synthetic */ CaptureHeapDumpTask this$0;
                        final /* synthetic */ String $productName;

                        public final void run() {
                            Notification notification = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(AndroidBundle.message("heap.dump.analysis.notification.title", new Object[0]), AndroidBundle.message("heap.dump.snapshot.created", ((Object)CaptureHeapDumpTask.access$getHprofPath$p(this.this$0)).toString(), this.$productName), NotificationType.INFORMATION, null);
                            notification.notify(null);
                        }
                        {
                            this.this$0 = captureHeapDumpTask;
                            this.$productName = string;
                        }
                    });
                    break;
                }
                case 2: {
                    ApplicationManager.getApplication().invokeLater((Runnable)new AnalysisRunnable(report, true));
                    break;
                }
                case 3: {
                    Notification notification = HeapDumpAnalysisNotificationGroup.GROUP.createNotification(AndroidBundle.message("heap.dump.analysis.notification.title", new Object[0]), AndroidBundle.message("heap.dump.snapshot.created.no.analysis", ((Object)this.hprofPath).toString()), NotificationType.INFORMATION, null);
                    notification.notify(null);
                }
            }
        }

        private final void captureSnapshot() {
            if (PathKt.exists((Path)this.hprofPath)) {
                throw (Throwable)new FileAlreadyExistsException(this.hprofPath.toFile(), null, null, 6, null);
            }
            try {
                MemoryDumpHelper.captureMemoryDump((String)((Object)this.hprofPath).toString());
            }
            catch (Throwable t) {
                Files.deleteIfExists(this.hprofPath);
                throw t;
            }
        }

        public CaptureHeapDumpTask(@NotNull Path hprofPath, @NotNull MemoryReportReason reason, @NotNull AnalysisOption analysisOption, boolean restart) {
            super(null, AndroidBundle.message("heap.dump.snapshot.task.title", new Object[0]), false);
            this.hprofPath = hprofPath;
            this.reason = reason;
            this.analysisOption = analysisOption;
            this.restart = restart;
        }

        public static final /* synthetic */ void access$confirmRestart(CaptureHeapDumpTask $this) {
            $this.confirmRestart();
        }

        public static final /* synthetic */ Path access$getHprofPath$p(CaptureHeapDumpTask $this) {
            return $this.hprofPath;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/action/HeapDumpSnapshotRunnable$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "MINIMUM_USED_MEMORY_TO_CAPTURE_HEAP_DUMP_IN_MB", "", "NEXT_CHECK_TIMESTAMP_KEY", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

