/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.analysis;

import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisConfig;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisContext;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalyzeDisposer;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalyzeGraph$WhenMappings;
import com.android.tools.idea.diagnostics.hprof.analysis.GCRootPathsTree;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassStore;
import com.android.tools.idea.diagnostics.hprof.classstore.StaticField;
import com.android.tools.idea.diagnostics.hprof.histogram.Histogram;
import com.android.tools.idea.diagnostics.hprof.histogram.HistogramEntry;
import com.android.tools.idea.diagnostics.hprof.navigator.ObjectNavigator;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import com.android.tools.idea.diagnostics.hprof.util.IntList;
import com.android.tools.idea.diagnostics.hprof.util.PartialProgressIndicator;
import com.android.tools.idea.diagnostics.hprof.util.UByteList;
import com.android.tools.idea.diagnostics.hprof.visitors.HistogramVisitor;
import com.google.common.base.Stopwatch;
import com.intellij.openapi.progress.ProgressIndicator;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntProcedure;
import gnu.trove.TIntProcedure;
import gnu.trove.TLongArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0016H\u0002J\"\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0016H\u0002J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u000fH\u0002J\b\u0010\u001f\u001a\u00020\u000fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002J\b\u0010#\u001a\u00020\u001bH\u0002J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020!H\u0002J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalyzeGraph;", "", "analysisContext", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisContext;", "(Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisContext;)V", "config", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig;", "nominatedInstances", "Ljava/util/HashMap;", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "Lgnu/trove/TIntHashSet;", "Lkotlin/collections/HashMap;", "parentList", "Lcom/android/tools/idea/diagnostics/hprof/util/IntList;", "softWeakRefHistogram", "Lcom/android/tools/idea/diagnostics/hprof/histogram/Histogram;", "strongRefHistogram", "addIdToListAndSetParentIfOrphan", "", "list", "Lgnu/trove/TIntArrayList;", "id", "", "parentId", "addIdToSetIfOrphan", "set", "analyze", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getAndClearSoftWeakHistogram", "getAndClearStrongRefHistogram", "getParentIdForObjectId", "", "objectId", "prepareHistogramSection", "preparePerClassSection", "Lcom/android/tools/idea/diagnostics/hprof/util/PartialProgressIndicator;", "setParentForObjectId", "", "traverseInstanceGraph", "WalkGraphPhase", "intellij.android.core"})
public final class AnalyzeGraph {
    private Histogram strongRefHistogram;
    private Histogram softWeakRefHistogram;
    private final IntList parentList;
    private final HashMap<ClassDefinition, TIntHashSet> nominatedInstances;
    private final AnalysisConfig config;
    private final AnalysisContext analysisContext;

    private final void setParentForObjectId(long objectId, long parentId) {
        this.parentList.set((int)objectId, (int)parentId);
    }

    private final long getParentIdForObjectId(long objectId) {
        return this.parentList.get((int)objectId);
    }

    @NotNull
    public final String analyze(@NotNull ProgressIndicator progress) {
        CharSequence charSequence;
        StringBuilder stringBuilder;
        StringBuilder sb = new StringBuilder();
        Collection collection = this.analysisContext.getConfig().getPerClassOptions().getClassNames();
        boolean includePerClassSection = !collection.isEmpty();
        ProgressIndicator traverseProgress = includePerClassSection ? (ProgressIndicator)new PartialProgressIndicator(progress, 0.0, 0.5) : progress;
        this.traverseInstanceGraph(traverseProgress);
        AnalyzeDisposer analyzeDisposer = new AnalyzeDisposer(this.analysisContext);
        analyzeDisposer.computeDisposedObjectsIDs();
        AnalysisConfig.HistogramOptions histogramOptions = this.analysisContext.getConfig().getHistogramOptions();
        if (histogramOptions.getIncludeByCount() || histogramOptions.getIncludeBySize()) {
            stringBuilder = sb;
            charSequence = HeapReportUtils.INSTANCE.sectionHeader("Histogram");
            StringBuilder stringBuilder2 = stringBuilder.append((String)charSequence);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
            sb.append(this.prepareHistogramSection());
        }
        if (includePerClassSection) {
            PartialProgressIndicator perClassProgress = new PartialProgressIndicator(progress, 0.5, 0.5);
            charSequence = sb;
            String string = HeapReportUtils.INSTANCE.sectionHeader("Instances of each nominated class");
            StringBuilder stringBuilder3 = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder3);
            sb.append(this.preparePerClassSection(perClassProgress));
        }
        if (this.config.getDisposerOptions().getIncludeDisposerTree()) {
            stringBuilder = sb;
            charSequence = HeapReportUtils.INSTANCE.sectionHeader("Disposer tree");
            StringBuilder stringBuilder4 = stringBuilder.append((String)charSequence);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder4);
            sb.append(analyzeDisposer.prepareDisposerTreeSection());
        }
        if (this.config.getDisposerOptions().getIncludeDisposedObjectsSummary() || this.config.getDisposerOptions().getIncludeDisposedObjectsDetails()) {
            stringBuilder = sb;
            charSequence = HeapReportUtils.INSTANCE.sectionHeader("Disposed objects");
            StringBuilder stringBuilder5 = stringBuilder.append((String)charSequence);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder5);
            sb.append(analyzeDisposer.prepareDisposedObjectsSection());
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String preparePerClassSection(PartialProgressIndicator progress) {
        CharSequence prettyName;
        StringBuilder sb = new StringBuilder();
        Histogram histogram = this.analysisContext.getHistogram();
        AnalysisConfig.PerClassOptions perClassOptions = this.analysisContext.getConfig().getPerClassOptions();
        if (perClassOptions.getIncludeClassList()) {
            StringBuilder stringBuilder = sb;
            String string = "Nominated classes:";
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder2);
            Iterable $receiver$iv = perClassOptions.getClassNames();
            for (Object element$iv : $receiver$iv) {
                void totalInstances;
                void classDefinition;
                HistogramEntry histogramEntry;
                Object v1;
                Object object;
                Object object2;
                block7: {
                    String name = (String)element$iv;
                    boolean bl = false;
                    object = object2 = (Iterable)histogram.getEntries();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        HistogramEntry entry = (HistogramEntry)t;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)entry.getClassDefinition().getName(), (Object)name)) continue;
                        v1 = t;
                        break block7;
                    }
                    v1 = null;
                }
                if ((HistogramEntry)v1 == null) {
                    continue;
                }
                ClassDefinition classDefinition2 = histogramEntry.component1();
                long l = histogramEntry.component2();
                long totalBytes = histogramEntry.component3();
                prettyName = classDefinition.getPrettyName();
                object2 = sb;
                object = " --> [" + HeapReportUtils.INSTANCE.toShortStringAsCount((long)totalInstances) + '/' + HeapReportUtils.INSTANCE.toShortStringAsSize(totalBytes) + "] " + (String)prettyName;
                StringBuilder stringBuilder3 = ((StringBuilder)object2).append((String)object);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder3);
            }
            StringsKt.appendln((StringBuilder)sb);
        }
        ObjectNavigator nav = this.analysisContext.getNavigator();
        int counter = 0;
        List<String> nominatedClassNames = this.config.getPerClassOptions().getClassNames();
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        Iterable $receiver$iv = nominatedClassNames;
        for (Object element$iv : $receiver$iv) {
            TIntHashSet set;
            String className = (String)element$iv;
            boolean bl = false;
            ClassDefinition classDefinition = nav.getClassStore().get(className);
            if (this.nominatedInstances.get(classDefinition) == null) {
                Intrinsics.throwNpe();
            }
            progress.setFraction((double)counter / (double)this.nominatedInstances.size());
            progress.setText2("Processing: " + set.size() + ' ' + classDefinition.getPrettyName());
            stopwatch.reset().start();
            prettyName = sb;
            CharSequence charSequence = "CLASS: " + classDefinition.getPrettyName() + " (" + set.size() + " objects)";
            StringBuilder stringBuilder = ((StringBuilder)prettyName).append((String)charSequence);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            GCRootPathsTree referenceRegistry = new GCRootPathsTree(this.analysisContext, perClassOptions.getTreeDisplayOptions(), classDefinition);
            set.forEach(new TIntProcedure(referenceRegistry){
                final /* synthetic */ GCRootPathsTree $referenceRegistry;

                public final boolean execute(int objectId) {
                    this.$referenceRegistry.registerObject(objectId);
                    return true;
                }
                {
                    this.$referenceRegistry = gCRootPathsTree;
                }
            });
            set.clear();
            sb.append(referenceRegistry.printTree());
            if (this.config.getMetaInfoOptions().getInclude()) {
                charSequence = sb;
                String string = "Report for " + classDefinition.getPrettyName() + " created in " + stopwatch;
                StringBuilder stringBuilder4 = ((StringBuilder)charSequence).append(string);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder4);
            }
            StringsKt.appendln((StringBuilder)sb);
            int n = counter;
            counter = n + 1;
        }
        progress.setFraction(1.0);
        return sb.toString();
    }

    private final String prepareHistogramSection() {
        StringBuilder result2 = new StringBuilder();
        Histogram strongRefHistogram = this.getAndClearStrongRefHistogram();
        Histogram softWeakRefHistogram = this.getAndClearSoftWeakHistogram();
        Histogram histogram = this.analysisContext.getHistogram();
        AnalysisConfig.HistogramOptions histogramOptions = this.analysisContext.getConfig().getHistogramOptions();
        result2.append(Histogram.Companion.prepareMergedHistogramReport(histogram, "All", strongRefHistogram, "Strong-ref", histogramOptions));
        long unreachableObjectsCount = histogram.getInstanceCount() - strongRefHistogram.getInstanceCount() - softWeakRefHistogram.getInstanceCount();
        long unreachableObjectsSize = histogram.getBytesCount() - strongRefHistogram.getBytesCount() - softWeakRefHistogram.getBytesCount();
        StringBuilder stringBuilder = result2;
        String string = "Unreachable objects: " + HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(unreachableObjectsCount) + "  " + HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(unreachableObjectsSize);
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        return result2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String traverseInstanceGraph(ProgressIndicator progress) {
        HistogramEntry histogramEntry;
        Object object;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        void toVisit;
        Object object2;
        StringBuilder result2 = new StringBuilder();
        ObjectNavigator nav = this.analysisContext.getNavigator();
        ClassStore classStore = this.analysisContext.getClassStore();
        IntList sizesList = this.analysisContext.getSizesList();
        IntList visitedList = this.analysisContext.getVisitedList();
        UByteList refIndexList = this.analysisContext.getRefIndexList();
        Iterator<ObjectNavigator.RootObject> roots = nav.createRootsIterator();
        this.nominatedInstances.clear();
        List<String> nominatedClassNames = this.config.getPerClassOptions().getClassNames();
        Iterable $receiver$iv2 = nominatedClassNames;
        for (Object element$iv : $receiver$iv2) {
            String it = (String)element$iv;
            boolean bl = false;
            Map map2 = this.nominatedInstances;
            object2 = classStore.get(it);
            TIntHashSet tIntHashSet = new TIntHashSet();
            map2.put(object2, tIntHashSet);
        }
        progress.setText2("Collect all object roots");
        $receiver$iv2 = new Ref.ObjectRef();
        ((Ref.ObjectRef)$receiver$iv2).element = new TIntArrayList();
        TIntArrayList toVisit2 = new TIntArrayList();
        TIntHashSet rootsSet = new TIntHashSet();
        TIntHashSet frameRootsSet = new TIntHashSet();
        while (roots.hasNext()) {
            ObjectNavigator.RootObject rootObject = roots.next();
            int rootObjectId = (int)rootObject.getId();
            if (rootObject.getReason().getJavaFrame()) {
                frameRootsSet.add(rootObjectId);
                continue;
            }
            AnalyzeGraph.addIdToSetIfOrphan$default(this, rootsSet, rootObjectId, 0, 4, null);
        }
        classStore.forEachClass((Function1<? super ClassDefinition, Unit>)((Function1)new Function1<ClassDefinition, Unit>(this, rootsSet){
            final /* synthetic */ AnalyzeGraph this$0;
            final /* synthetic */ TIntHashSet $rootsSet;

            public final void invoke(@NotNull ClassDefinition classDefinition) {
                int n;
                Object[] $receiver$iv;
                AnalyzeGraph.addIdToSetIfOrphan$default(this.this$0, this.$rootsSet, (int)classDefinition.getId(), 0, 4, null);
                StaticField[] staticFieldArray = $receiver$iv = classDefinition.getStaticFields();
                int n2 = staticFieldArray.length;
                for (n = 0; n < n2; ++n) {
                    StaticField element$iv;
                    StaticField staticField = element$iv = staticFieldArray[n];
                    boolean bl = false;
                    AnalyzeGraph.addIdToSetIfOrphan$default(this.this$0, this.$rootsSet, (int)staticField.getObjectId(), 0, 4, null);
                }
                staticFieldArray = $receiver$iv = (Object[])classDefinition.getConstantFields();
                n2 = staticFieldArray.length;
                for (n = 0; n < n2; ++n) {
                    StaticField element$iv;
                    StaticField objectId = element$iv = staticFieldArray[n];
                    boolean bl = false;
                    AnalyzeGraph.addIdToSetIfOrphan$default(this.this$0, this.$rootsSet, (int)objectId, 0, 4, null);
                }
            }
            {
                this.this$0 = analyzeGraph;
                this.$rootsSet = tIntHashSet;
                super(1);
            }
        }));
        ((TIntArrayList)toVisit.element).add(rootsSet.toArray());
        rootsSet.clear();
        rootsSet.compact();
        int leafCounter = 0;
        StringBuilder rootObjectId = result2;
        object2 = "Roots count: " + ((TIntArrayList)toVisit.element).size();
        StringBuilder stringBuilder = rootObjectId.append((String)object2);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder);
        rootObjectId = result2;
        object2 = "Classes count: " + classStore.size();
        StringBuilder stringBuilder2 = rootObjectId.append((String)object2);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        progress.setText2("Traversing instance graph");
        HashMap strongRefHistogramEntries = new HashMap();
        HashMap reachableNonStrongHistogramEntries = new HashMap();
        TIntIntHashMap softReferenceIdToParentMap = new TIntIntHashMap();
        TIntIntHashMap weakReferenceIdToParentMap = new TIntIntHashMap();
        int visitedInstancesCount = 0;
        Stopwatch stopwatch = Stopwatch.createStarted();
        TLongArrayList references = new TLongArrayList();
        int visitedCount = 0;
        int strongRefVisitedCount = 0;
        int softWeakVisitedCount = 0;
        long finalizableBytes = 0L;
        long softBytes = 0L;
        long weakBytes = 0L;
        WalkGraphPhase phase = WalkGraphPhase.StrongReferencesNonLocalVariables;
        TIntArrayList cleanerObjects = new TIntArrayList();
        ClassDefinition sunMiscCleanerClass = classStore.getClassIfExists("sun.misc.Cleaner");
        ClassDefinition finalizerClass = classStore.getClassIfExists("java.lang.ref.Finalizer");
        boolean onlyStrongReferences = this.config.getTraverseOptions().getOnlyStrongReferences();
        while (!((TIntArrayList)toVisit.element).isEmpty()) {
            int n = 0;
            int n2 = ((TIntArrayList)toVisit.element).size();
            while (n < n2) {
                void i2;
                int id = ((TIntArrayList)toVisit.element).get((int)i2);
                nav.goTo(id, ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
                ClassDefinition currentObjectClass = nav.getClass();
                if ((Intrinsics.areEqual((Object)currentObjectClass, (Object)sunMiscCleanerClass) || Intrinsics.areEqual((Object)currentObjectClass, (Object)finalizerClass)) && phase.compareTo((Enum)WalkGraphPhase.CleanerFinalizerReferences) < 0) {
                    if (!onlyStrongReferences) {
                        cleanerObjects.add(id);
                    }
                } else {
                    Object object3;
                    ++visitedInstancesCount;
                    TIntHashSet tIntHashSet = this.nominatedInstances.get(currentObjectClass);
                    Boolean bl = tIntHashSet != null ? Boolean.valueOf(tIntHashSet.add(id)) : null;
                    boolean isLeaf = true;
                    nav.copyReferencesTo(references);
                    boolean currentObjectIsArray = currentObjectClass.isArray();
                    if (phase.compareTo((Enum)WalkGraphPhase.SoftReferences) < 0 && nav.getSoftReferenceId() != 0L) {
                        if (!onlyStrongReferences) {
                            softReferenceIdToParentMap.put((int)nav.getSoftReferenceId(), id);
                        }
                        references.set(nav.getSoftWeakReferenceIndex(), 0L);
                    }
                    if (phase.compareTo((Enum)WalkGraphPhase.WeakReferences) < 0 && nav.getWeakReferenceId() != 0L) {
                        if (!onlyStrongReferences) {
                            weakReferenceIdToParentMap.put((int)nav.getWeakReferenceId(), id);
                        }
                        references.set(nav.getSoftWeakReferenceIndex(), 0L);
                    }
                    int n3 = 0;
                    int n4 = references.size();
                    while (n3 < n4) {
                        void j;
                        int referenceId = (int)references.get((int)j);
                        if (this.addIdToListAndSetParentIfOrphan(toVisit2, referenceId, id)) {
                            if (!currentObjectIsArray && j <= 254) {
                                refIndexList.set(referenceId, (int)(j + true));
                            }
                            isLeaf = false;
                        }
                        ++j;
                    }
                    visitedList.set(visitedCount++, id);
                    int size = nav.getObjectSize();
                    int sizeDivBy4 = (size + 3) / 4;
                    if (sizeDivBy4 == 0) {
                        sizeDivBy4 = 1;
                    }
                    sizesList.set(id, sizeDivBy4);
                    HashMap histogramEntries = null;
                    if (phase == WalkGraphPhase.StrongReferencesNonLocalVariables || phase == WalkGraphPhase.StrongReferencesLocalVariables) {
                        histogramEntries = strongRefHistogramEntries;
                        if (isLeaf) {
                            ++leafCounter;
                        }
                        ++strongRefVisitedCount;
                    } else {
                        histogramEntries = reachableNonStrongHistogramEntries;
                        if (phase == WalkGraphPhase.CleanerFinalizerReferences) {
                            finalizableBytes += (long)size;
                        } else if (phase == WalkGraphPhase.SoftReferences) {
                            softBytes += (long)size;
                        } else {
                            boolean bl2;
                            boolean bl3 = bl2 = phase == WalkGraphPhase.WeakReferences;
                            if (_Assertions.ENABLED && !bl2) {
                                String string = "Assertion failed";
                                throw (Throwable)((Object)new AssertionError((Object)string));
                            }
                            weakBytes += (long)size;
                        }
                        ++softWeakVisitedCount;
                    }
                    Map $receiver$iv3 = histogramEntries;
                    Object value$iv = $receiver$iv3.get(currentObjectClass);
                    if (value$iv == null) {
                        boolean bl4 = false;
                        HistogramVisitor.InternalHistogramEntry answer$iv = new HistogramVisitor.InternalHistogramEntry(currentObjectClass);
                        $receiver$iv3.put(currentObjectClass, answer$iv);
                        object3 = answer$iv;
                    } else {
                        object3 = value$iv;
                    }
                    ((HistogramVisitor.InternalHistogramEntry)object3).addInstance(size);
                }
                ++i2;
            }
            progress.setFraction(1.0 * (double)visitedInstancesCount / (double)nav.getInstanceCount());
            ((TIntArrayList)toVisit.element).resetQuick();
            TIntArrayList tmp22 = (TIntArrayList)toVisit.element;
            toVisit.element = toVisit2;
            toVisit2 = tmp22;
            block11: while (((TIntArrayList)toVisit.element).size() == 0 && phase != WalkGraphPhase.Finished) {
                phase = WalkGraphPhase.values()[phase.ordinal() + 1];
                switch (AnalyzeGraph$WhenMappings.$EnumSwitchMapping$0[phase.ordinal()]) {
                    case 1: {
                        frameRootsSet.forEach(new TIntProcedure(this, (Ref.ObjectRef)toVisit){
                            final /* synthetic */ AnalyzeGraph this$0;
                            final /* synthetic */ Ref.ObjectRef $toVisit;

                            public final boolean execute(int id) {
                                AnalyzeGraph.access$addIdToListAndSetParentIfOrphan(this.this$0, (TIntArrayList)this.$toVisit.element, id, id);
                                return true;
                            }
                            {
                                this.this$0 = analyzeGraph;
                                this.$toVisit = objectRef;
                            }
                        });
                        continue block11;
                    }
                    case 2: {
                        ((TIntArrayList)toVisit.element).add(cleanerObjects.toNativeArray());
                        cleanerObjects.clear();
                        continue block11;
                    }
                    case 3: {
                        softReferenceIdToParentMap.forEachEntry(new TIntIntProcedure(this, (Ref.ObjectRef)toVisit){
                            final /* synthetic */ AnalyzeGraph this$0;
                            final /* synthetic */ Ref.ObjectRef $toVisit;

                            public final boolean execute(int softId, int parentId) {
                                AnalyzeGraph.access$addIdToListAndSetParentIfOrphan(this.this$0, (TIntArrayList)this.$toVisit.element, softId, parentId);
                                return true;
                            }
                            {
                                this.this$0 = analyzeGraph;
                                this.$toVisit = objectRef;
                            }
                        });
                        softReferenceIdToParentMap.clear();
                        softReferenceIdToParentMap.compact();
                        continue block11;
                    }
                    case 4: {
                        weakReferenceIdToParentMap.forEachEntry(new TIntIntProcedure(this, (Ref.ObjectRef)toVisit){
                            final /* synthetic */ AnalyzeGraph this$0;
                            final /* synthetic */ Ref.ObjectRef $toVisit;

                            public final boolean execute(int weakId, int parentId) {
                                AnalyzeGraph.access$addIdToListAndSetParentIfOrphan(this.this$0, (TIntArrayList)this.$toVisit.element, weakId, parentId);
                                return true;
                            }
                            {
                                this.this$0 = analyzeGraph;
                                this.$toVisit = objectRef;
                            }
                        });
                        weakReferenceIdToParentMap.clear();
                        weakReferenceIdToParentMap.compact();
                        continue block11;
                    }
                }
            }
        }
        boolean tmp22 = cleanerObjects.isEmpty();
        if (_Assertions.ENABLED && !tmp22) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        tmp22 = softReferenceIdToParentMap.isEmpty();
        if (_Assertions.ENABLED && !tmp22) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        tmp22 = weakReferenceIdToParentMap.isEmpty();
        if (_Assertions.ENABLED && !tmp22) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Object tmp22 = result2;
        String string = "Finalizable size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(finalizableBytes);
        StringBuilder stringBuilder3 = ((StringBuilder)tmp22).append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        tmp22 = result2;
        string = "Soft-reachable size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(softBytes);
        StringBuilder stringBuilder4 = ((StringBuilder)tmp22).append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        tmp22 = result2;
        string = "Weak-reachable size: " + HeapReportUtils.INSTANCE.toShortStringAsSize(weakBytes);
        StringBuilder stringBuilder5 = ((StringBuilder)tmp22).append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder5, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder5);
        tmp22 = strongRefHistogramEntries.values();
        AnalyzeGraph analyzeGraph = this;
        string = $receiver$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            HistogramVisitor.InternalHistogramEntry currentObjectIsArray = (HistogramVisitor.InternalHistogramEntry)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            histogramEntry = it.asHistogramEntry();
            object.add(histogramEntry);
        }
        object = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)object;
        destination$iv$iv = new Comparator<T>(){

            public final int compare(T a, T b) {
                HistogramEntry it = (HistogramEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTotalInstances());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                Long l = it.getTotalInstances();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        object = CollectionsKt.sortedWith((Iterable)$receiver$iv$iv, (Comparator)destination$iv$iv);
        long l = strongRefVisitedCount;
        Collection<HistogramEntry> collection = object;
        analyzeGraph.strongRefHistogram = new Histogram((List<HistogramEntry>)collection, l);
        $receiver$iv = reachableNonStrongHistogramEntries.values();
        analyzeGraph = this;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            HistogramVisitor.InternalHistogramEntry it = (HistogramVisitor.InternalHistogramEntry)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            histogramEntry = it.asHistogramEntry();
            object.add(histogramEntry);
        }
        object = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv = (Iterable)object;
        destination$iv$iv = new Comparator<T>(){

            public final int compare(T a, T b) {
                HistogramEntry it = (HistogramEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTotalInstances());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                Long l = it.getTotalInstances();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        object = CollectionsKt.sortedWith((Iterable)$receiver$iv$iv, (Comparator)destination$iv$iv);
        long l2 = softWeakVisitedCount;
        Object object4 = object;
        analyzeGraph.softWeakRefHistogram = new Histogram((List<HistogramEntry>)object4, l2);
        Stopwatch stopwatchUpdateSizes = Stopwatch.createStarted();
        for (int index = visitedCount - 1; index >= 0; --index) {
            int parentId;
            int id = visitedList.get(index);
            if (id == (parentId = this.parentList.get(id))) continue;
            IntList intList = sizesList;
            int n = parentId;
            intList.set(n, intList.get(n) + sizesList.get(id));
        }
        stopwatchUpdateSizes.stop();
        if (this.config.getMetaInfoOptions().getInclude()) {
            StringBuilder stringBuilder6 = result2;
            String string2 = "Analysis completed! Visited instances: " + visitedInstancesCount + ", time: " + stopwatch;
            StringBuilder stringBuilder7 = stringBuilder6.append(string2);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder7, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder7);
            stringBuilder6 = result2;
            string2 = "Update sizes time: " + stopwatchUpdateSizes;
            StringBuilder stringBuilder8 = stringBuilder6.append(string2);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder8, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder8);
            stringBuilder6 = result2;
            string2 = "Leaves found: " + leafCounter;
            StringBuilder stringBuilder9 = stringBuilder6.append(string2);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder9, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder9);
        }
        return result2.toString();
    }

    private final boolean addIdToListAndSetParentIfOrphan(TIntArrayList list, int id, int parentId) {
        if (id != 0 && this.getParentIdForObjectId(id) == 0L) {
            this.setParentForObjectId(id, parentId);
            list.add(id);
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean addIdToListAndSetParentIfOrphan$default(AnalyzeGraph analyzeGraph, TIntArrayList tIntArrayList, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return analyzeGraph.addIdToListAndSetParentIfOrphan(tIntArrayList, n, n2);
    }

    private final boolean addIdToSetIfOrphan(TIntHashSet set, int id, int parentId) {
        if (id != 0 && this.getParentIdForObjectId(id) == 0L && set.add(id)) {
            this.setParentForObjectId(id, parentId);
            return true;
        }
        return false;
    }

    static /* synthetic */ boolean addIdToSetIfOrphan$default(AnalyzeGraph analyzeGraph, TIntHashSet tIntHashSet, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = n;
        }
        return analyzeGraph.addIdToSetIfOrphan(tIntHashSet, n, n2);
    }

    private final Histogram getAndClearStrongRefHistogram() {
        Histogram result2 = this.strongRefHistogram;
        this.strongRefHistogram = null;
        Histogram histogram = result2;
        if (histogram == null) {
            throw (Throwable)new IllegalStateException("Graph not analyzed.");
        }
        return histogram;
    }

    private final Histogram getAndClearSoftWeakHistogram() {
        Histogram result2 = this.softWeakRefHistogram;
        this.softWeakRefHistogram = null;
        Histogram histogram = result2;
        if (histogram == null) {
            throw (Throwable)new IllegalStateException("Graph not analyzed.");
        }
        return histogram;
    }

    public AnalyzeGraph(@NotNull AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
        this.parentList = this.analysisContext.getParentList();
        this.nominatedInstances = new HashMap();
        this.config = this.analysisContext.getConfig();
    }

    public static final /* synthetic */ boolean access$addIdToListAndSetParentIfOrphan(AnalyzeGraph $this, TIntArrayList list, int id, int parentId) {
        return $this.addIdToListAndSetParentIfOrphan(list, id, parentId);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalyzeGraph$WalkGraphPhase;", "", "(Ljava/lang/String;I)V", "StrongReferencesNonLocalVariables", "StrongReferencesLocalVariables", "SoftReferences", "WeakReferences", "CleanerFinalizerReferences", "Finished", "intellij.android.core"})
    public static final class WalkGraphPhase
    extends Enum<WalkGraphPhase> {
        public static final /* enum */ WalkGraphPhase StrongReferencesNonLocalVariables;
        public static final /* enum */ WalkGraphPhase StrongReferencesLocalVariables;
        public static final /* enum */ WalkGraphPhase SoftReferences;
        public static final /* enum */ WalkGraphPhase WeakReferences;
        public static final /* enum */ WalkGraphPhase CleanerFinalizerReferences;
        public static final /* enum */ WalkGraphPhase Finished;
        private static final /* synthetic */ WalkGraphPhase[] $VALUES;

        static {
            WalkGraphPhase[] walkGraphPhaseArray = new WalkGraphPhase[6];
            WalkGraphPhase[] walkGraphPhaseArray2 = walkGraphPhaseArray;
            walkGraphPhaseArray[0] = StrongReferencesNonLocalVariables = new WalkGraphPhase();
            walkGraphPhaseArray[1] = StrongReferencesLocalVariables = new WalkGraphPhase();
            walkGraphPhaseArray[2] = SoftReferences = new WalkGraphPhase();
            walkGraphPhaseArray[3] = WeakReferences = new WalkGraphPhase();
            walkGraphPhaseArray[4] = CleanerFinalizerReferences = new WalkGraphPhase();
            walkGraphPhaseArray[5] = Finished = new WalkGraphPhase();
            $VALUES = walkGraphPhaseArray;
        }

        public static WalkGraphPhase[] values() {
            return (WalkGraphPhase[])$VALUES.clone();
        }

        public static WalkGraphPhase valueOf(String string) {
            return Enum.valueOf(WalkGraphPhase.class, string);
        }
    }
}

