/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.analysis;

import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisConfig;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisContext;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassStore;
import com.android.tools.idea.diagnostics.hprof.classstore.InstanceField;
import com.android.tools.idea.diagnostics.hprof.navigator.ObjectNavigator;
import com.android.tools.idea.diagnostics.hprof.navigator.RootReason;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import com.android.tools.idea.diagnostics.hprof.util.IntList;
import com.android.tools.idea.diagnostics.hprof.util.TruncatingPrintBuffer;
import com.android.tools.idea.diagnostics.hprof.util.UByteList;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\b\u001c\u001d\u001e\u001f !\"#B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0014J\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree;", "", "analysisContext", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisContext;", "treeDisplayOptions", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$TreeDisplayOptions;", "allObjectsOfClass", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "(Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisContext;Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$TreeDisplayOptions;Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;)V", "getAnalysisContext", "()Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisContext;", "countOfIgnoredObjects", "", "objectSizeStrategy", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "topNode", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RootNode;", "getTreeDisplayOptions", "()Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$TreeDisplayOptions;", "getDisposedDominatorNodes", "", "", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "printTree", "", "registerObject", "", "objectId", "AllObjectsSameSizeStrategy", "DirectByteBufferNativeSizeStrategy", "Edge", "Node", "ObjectSizeCalculationStrategy", "RegularNode", "RootNode", "SizeFromObjectNavigatorStrategy", "intellij.android.core"})
public final class GCRootPathsTree {
    private final RootNode topNode;
    private int countOfIgnoredObjects;
    private final ObjectSizeCalculationStrategy objectSizeStrategy;
    @NotNull
    private final AnalysisContext analysisContext;
    @NotNull
    private final AnalysisConfig.TreeDisplayOptions treeDisplayOptions;

    /*
     * WARNING - void declaration
     */
    public final void registerObject(int objectId) {
        boolean bl;
        ObjectNavigator nav = this.analysisContext.getNavigator();
        IntList parentMapping = this.analysisContext.getParentList();
        UByteList refIndexMapping = this.analysisContext.getRefIndexList();
        IntList sizesMapping = this.analysisContext.getSizesList();
        TIntHashSet disposedObjectsIDsSet = this.analysisContext.getDisposedObjectsIDs();
        TIntArrayList gcPath = new TIntArrayList();
        TIntArrayList fieldsPath = new TIntArrayList();
        int objectIterationId = objectId;
        int parentId = parentMapping.get(objectIterationId);
        fieldsPath.add(0);
        int maxTreeDepth = this.treeDisplayOptions.getMaximumTreeDepth();
        for (int count = 0; count < maxTreeDepth && parentId != objectIterationId; ++count) {
            gcPath.add(objectIterationId);
            if (this.treeDisplayOptions.getShowFieldNames()) {
                fieldsPath.add(refIndexMapping.get(objectIterationId));
            } else {
                fieldsPath.add(0);
            }
            objectIterationId = parentId;
            parentId = parentMapping.get(objectIterationId);
        }
        if (parentId != objectIterationId) {
            int n = this.countOfIgnoredObjects;
            this.countOfIgnoredObjects = n + 1;
            return;
        }
        gcPath.add(objectIterationId);
        boolean bl2 = bl = gcPath.size() == fieldsPath.size();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int size = this.objectSizeStrategy.calculateObjectSize(nav, objectId);
        Node currentNode = this.topNode;
        int n = gcPath.size() - 1;
        boolean bl3 = false;
        while (n >= 0) {
            void i2;
            int id = gcPath.get((int)i2);
            ClassDefinition classDefinition = nav.getClassForObjectId(id);
            InstanceField field2 = null;
            if (fieldsPath.get((int)i2) != 0) {
                field2 = classDefinition.getRefField(nav.getClassStore(), fieldsPath.get((int)i2) - 1);
            }
            currentNode = currentNode.addEdge(id, size, sizesMapping.get(id), classDefinition, field2, disposedObjectsIDsSet.contains(id));
            --i2;
        }
    }

    @NotNull
    public final String printTree() {
        StringBuilder result2 = new StringBuilder();
        if (this.countOfIgnoredObjects > 0) {
            result2.append("Ignored " + this.countOfIgnoredObjects + " too-deep objects\n");
        }
        Function1 rootReasonGetter2 = (Function1)new Function1<Integer, String>(this){
            final /* synthetic */ GCRootPathsTree this$0;

            @NotNull
            public final String invoke(int id) {
                Object object = this.this$0.getAnalysisContext().getNavigator().getRootReasonForObjectId(id);
                if (object == null || (object = ((RootReason)object).getDescription()) == null) {
                    object = "<Couldn't find root description>";
                }
                return object;
            }
            {
                this.this$0 = gCRootPathsTree;
                super(1);
            }
        };
        result2.append(this.topNode.createHotPathReport(this.treeDisplayOptions, (Function1<? super Integer, String>)rootReasonGetter2));
        return result2.toString();
    }

    @NotNull
    public final Map<ClassDefinition, List<RegularNode>> getDisposedDominatorNodes() {
        HashMap result2 = new HashMap();
        this.topNode.collectDisposedDominatorNodes(result2);
        return result2;
    }

    @NotNull
    public final AnalysisContext getAnalysisContext() {
        return this.analysisContext;
    }

    @NotNull
    public final AnalysisConfig.TreeDisplayOptions getTreeDisplayOptions() {
        return this.treeDisplayOptions;
    }

    public GCRootPathsTree(@NotNull AnalysisContext analysisContext, @NotNull AnalysisConfig.TreeDisplayOptions treeDisplayOptions, @Nullable ClassDefinition allObjectsOfClass) {
        this.analysisContext = analysisContext;
        this.treeDisplayOptions = treeDisplayOptions;
        this.topNode = new RootNode(this.analysisContext.getClassStore());
        this.objectSizeStrategy = ObjectSizeCalculationStrategy.Companion.getBestStrategyForClass(allObjectsOfClass);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "", "calculateObjectSize", "", "nav", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "id", "Companion", "intellij.android.core"})
    public static interface ObjectSizeCalculationStrategy {
        public static final Companion Companion = Companion.$$INSTANCE;

        public int calculateObjectSize(@NotNull ObjectNavigator var1, int var2);

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy$Companion;", "", "()V", "getBestStrategyForClass", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "intellij.android.core"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            @NotNull
            public final ObjectSizeCalculationStrategy getBestStrategyForClass(@Nullable ClassDefinition classDefinition) {
                if (classDefinition == null || classDefinition.isArray()) {
                    return new SizeFromObjectNavigatorStrategy();
                }
                if (Intrinsics.areEqual((Object)classDefinition.getName(), (Object)"java.nio.DirectByteBuffer")) {
                    return new DirectByteBufferNativeSizeStrategy(classDefinition);
                }
                return new AllObjectsSameSizeStrategy(classDefinition.getInstanceSize() + ClassDefinition.Companion.getOBJECT_PREAMBLE_SIZE());
            }

            private Companion() {
            }

            static {
                Companion companion;
                $$INSTANCE = companion = new Companion();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$AllObjectsSameSizeStrategy;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "size", "", "(I)V", "objectSize", "calculateObjectSize", "nav", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "id", "intellij.android.core"})
    private static final class AllObjectsSameSizeStrategy
    implements ObjectSizeCalculationStrategy {
        private final int objectSize;

        @Override
        public int calculateObjectSize(@NotNull ObjectNavigator nav, int id) {
            return this.objectSize;
        }

        public AllObjectsSameSizeStrategy(int size) {
            this.objectSize = size;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$SizeFromObjectNavigatorStrategy;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "()V", "calculateObjectSize", "", "nav", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "id", "intellij.android.core"})
    private static final class SizeFromObjectNavigatorStrategy
    implements ObjectSizeCalculationStrategy {
        @Override
        public int calculateObjectSize(@NotNull ObjectNavigator nav, int id) {
            nav.goTo(id, ObjectNavigator.ReferenceResolution.NO_REFERENCES);
            return nav.getObjectSize();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$DirectByteBufferNativeSizeStrategy;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$ObjectSizeCalculationStrategy;", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "(Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;)V", "calculateObjectSize", "", "nav", "Lcom/android/tools/idea/diagnostics/hprof/navigator/ObjectNavigator;", "id", "intellij.android.core"})
    private static final class DirectByteBufferNativeSizeStrategy
    implements ObjectSizeCalculationStrategy {
        private final ClassDefinition classDefinition;

        @Override
        public int calculateObjectSize(@NotNull ObjectNavigator nav, int id) {
            nav.goTo(id, ObjectNavigator.ReferenceResolution.ALL_REFERENCES);
            boolean bl = Intrinsics.areEqual((Object)nav.getClass(), (Object)this.classDefinition);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            return nav.getExtraData() + nav.getObjectSize();
        }

        public DirectByteBufferNativeSizeStrategy(@NotNull ClassDefinition classDefinition) {
            this.classDefinition = classDefinition;
            boolean bl = Intrinsics.areEqual((Object)this.classDefinition.getName(), (Object)"java.nio.DirectByteBuffer");
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J:\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH&\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Node;", "", "addEdge", "objectId", "", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "field", "Lcom/android/tools/idea/diagnostics/hprof/classstore/InstanceField;", "disposed", "", "intellij.android.core"})
    public static interface Node {
        @NotNull
        public Node addEdge(int var1, int var2, int var3, @NotNull ClassDefinition var4, @Nullable InstanceField var5, boolean var6);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "field", "Lcom/android/tools/idea/diagnostics/hprof/classstore/InstanceField;", "disposed", "", "(Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;Lcom/android/tools/idea/diagnostics/hprof/classstore/InstanceField;Z)V", "getClassDefinition", "()Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "getDisposed", "()Z", "getField", "()Lcom/android/tools/idea/diagnostics/hprof/classstore/InstanceField;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.android.core"})
    public static final class Edge {
        @NotNull
        private final ClassDefinition classDefinition;
        @Nullable
        private final InstanceField field;
        private final boolean disposed;

        @NotNull
        public final ClassDefinition getClassDefinition() {
            return this.classDefinition;
        }

        @Nullable
        public final InstanceField getField() {
            return this.field;
        }

        public final boolean getDisposed() {
            return this.disposed;
        }

        public Edge(@NotNull ClassDefinition classDefinition, @Nullable InstanceField field2, boolean disposed) {
            this.classDefinition = classDefinition;
            this.field = field2;
            this.disposed = disposed;
        }

        @NotNull
        public final ClassDefinition component1() {
            return this.classDefinition;
        }

        @Nullable
        public final InstanceField component2() {
            return this.field;
        }

        public final boolean component3() {
            return this.disposed;
        }

        @NotNull
        public final Edge copy(@NotNull ClassDefinition classDefinition, @Nullable InstanceField field2, boolean disposed) {
            return new Edge(classDefinition, field2, disposed);
        }

        @NotNull
        public static /* synthetic */ Edge copy$default(Edge edge, ClassDefinition classDefinition, InstanceField instanceField, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                classDefinition = edge.classDefinition;
            }
            if ((n & 2) != 0) {
                instanceField = edge.field;
            }
            if ((n & 4) != 0) {
                bl = edge.disposed;
            }
            return edge.copy(classDefinition, instanceField, bl);
        }

        @NotNull
        public String toString() {
            return "Edge(classDefinition=" + this.classDefinition + ", field=" + this.field + ", disposed=" + this.disposed + ")";
        }

        public int hashCode() {
            ClassDefinition classDefinition = this.classDefinition;
            InstanceField instanceField = this.field;
            int n = ((classDefinition != null ? ((Object)classDefinition).hashCode() : 0) * 31 + (instanceField != null ? instanceField.hashCode() : 0)) * 31;
            int n2 = this.disposed ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Edge)) break block3;
                    Edge edge = (Edge)object;
                    if (!Intrinsics.areEqual((Object)this.classDefinition, (Object)edge.classDefinition) || !Intrinsics.areEqual((Object)this.field, (Object)edge.field) || !(this.disposed == edge.disposed)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020%2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00000(0'R(\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Node;", "()V", "edges", "Ljava/util/HashMap;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "getEdges", "()Ljava/util/HashMap;", "setEdges", "(Ljava/util/HashMap;)V", "instances", "Lgnu/trove/TIntHashSet;", "getInstances", "()Lgnu/trove/TIntHashSet;", "pathsCount", "", "getPathsCount", "()I", "setPathsCount", "(I)V", "pathsSize", "getPathsSize", "setPathsSize", "totalSizeInDwords", "getTotalSizeInDwords", "setTotalSizeInDwords", "addEdge", "objectId", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "field", "Lcom/android/tools/idea/diagnostics/hprof/classstore/InstanceField;", "disposed", "", "collectDisposedDominatorNodes", "", "result", "", "", "intellij.android.core"})
    public static final class RegularNode
    implements Node {
        @Nullable
        private HashMap<Edge, RegularNode> edges;
        private int pathsCount;
        private int pathsSize;
        private int totalSizeInDwords;
        @NotNull
        private final TIntHashSet instances = new TIntHashSet(1);

        @Nullable
        public final HashMap<Edge, RegularNode> getEdges() {
            return this.edges;
        }

        public final void setEdges(@Nullable HashMap<Edge, RegularNode> hashMap) {
            this.edges = hashMap;
        }

        public final int getPathsCount() {
            return this.pathsCount;
        }

        public final void setPathsCount(int n) {
            this.pathsCount = n;
        }

        public final int getPathsSize() {
            return this.pathsSize;
        }

        public final void setPathsSize(int n) {
            this.pathsSize = n;
        }

        public final int getTotalSizeInDwords() {
            return this.totalSizeInDwords;
        }

        public final void setTotalSizeInDwords(int n) {
            this.totalSizeInDwords = n;
        }

        @NotNull
        public final TIntHashSet getInstances() {
            return this.instances;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Node addEdge(int objectId, int objectSize, int subgraphSizeInDwords, @NotNull ClassDefinition classDefinition, @Nullable InstanceField field2, boolean disposed) {
            Object object;
            void $receiver$iv22;
            HashMap<Edge, RegularNode> localEdges = this.edges;
            if (localEdges == null) {
                this.edges = localEdges = new HashMap(1);
            }
            Map map2 = localEdges;
            Edge key$iv = new Edge(classDefinition, field2, disposed);
            Object value$iv = $receiver$iv22.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                RegularNode answer$iv = new RegularNode();
                $receiver$iv22.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            RegularNode node = (RegularNode)object;
            int $receiver$iv22 = node.pathsCount;
            node.pathsCount = $receiver$iv22 + 1;
            node.pathsSize = (long)node.pathsSize + (long)objectSize > (long)Integer.MAX_VALUE ? Integer.MAX_VALUE : (node.pathsSize += objectSize);
            boolean added = node.instances.add(objectId);
            if (added) {
                node.totalSizeInDwords = (long)node.totalSizeInDwords + (long)subgraphSizeInDwords > (long)Integer.MAX_VALUE ? Integer.MAX_VALUE : (node.totalSizeInDwords += subgraphSizeInDwords);
            }
            return node;
        }

        /*
         * WARNING - void declaration
         */
        public final void collectDisposedDominatorNodes(@NotNull Map<ClassDefinition, List<RegularNode>> result2) {
            Collection collection;
            ArrayDeque<RegularNode> stack = new ArrayDeque<RegularNode>();
            stack.push(this);
            while (!(collection = (Collection)stack).isEmpty()) {
                Map $receiver$iv;
                RegularNode currentNode = (RegularNode)stack.pop();
                HashMap<Edge, RegularNode> hashMap = currentNode.edges;
                if (hashMap == null) continue;
                Map map2 = $receiver$iv = (Map)hashMap;
                Iterator iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry $edge_childNode = element$iv = iterator.next();
                    boolean bl = false;
                    Object object = $edge_childNode;
                    Edge edge = (Edge)object.getKey();
                    object = $edge_childNode;
                    RegularNode childNode = (RegularNode)object.getValue();
                    if (edge.getDisposed()) {
                        Object object2;
                        void $receiver$iv2;
                        object = result2;
                        ClassDefinition key$iv = edge.getClassDefinition();
                        Object value$iv = $receiver$iv2.get(key$iv);
                        if (value$iv == null) {
                            boolean bl2 = false;
                            List answer$iv = new ArrayList();
                            $receiver$iv2.put(key$iv, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = value$iv;
                        }
                        ((List)object2).add(childNode);
                        continue;
                    }
                    stack.push(childNode);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\n\u0018\u00002\u00020\u0001:\u000223B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0002J \u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001c0\u001bJ\"\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001e0\"J\u0089\u0001\u0010#\u001a\u00020\u00192\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020%0\"2\b\u0010&\u001a\u0004\u0018\u00010\u000e2\b\u0010'\u001a\u0004\u0018\u00010\u000e2\b\u0010(\u001a\u0004\u0018\u00010\u000e2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010\u000e2\u0006\u0010,\u001a\u00020\u00162\b\u0010-\u001a\u0004\u0018\u00010\u001e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010.\u001a\u0004\u0018\u00010\u001e2\u0006\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u00101R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00064"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RootNode;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Node;", "classStore", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "(Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;)V", "edges", "Lgnu/trove/TIntObjectHashMap;", "Lkotlin/Pair;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "getEdges", "()Lgnu/trove/TIntObjectHashMap;", "addEdge", "objectId", "", "objectSize", "subgraphSizeInDwords", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "field", "Lcom/android/tools/idea/diagnostics/hprof/classstore/InstanceField;", "disposed", "", "calculateTotalInstanceCount", "collectDisposedDominatorNodes", "", "result", "", "", "createHotPathReport", "", "treeDisplayOptions", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$TreeDisplayOptions;", "rootReasonGetter", "Lkotlin/Function1;", "printReportLine", "printFunc", "", "pathsCount", "percent", "instanceSize", "subgraphSize", "", "instanceCount", "lastInPath", "softWeakDescriptor", "fieldName", "indent", "text", "(Lkotlin/jvm/functions/Function1;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Long;Ljava/lang/Integer;ZLjava/lang/String;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "SoftWeakClassCache", "StackEntry", "intellij.android.core"})
    public static final class RootNode
    implements Node {
        @NotNull
        private final TIntObjectHashMap<Pair<RegularNode, Edge>> edges;
        private final ClassStore classStore;

        @NotNull
        public final TIntObjectHashMap<Pair<RegularNode, Edge>> getEdges() {
            return this.edges;
        }

        @Override
        @NotNull
        public Node addEdge(int objectId, int objectSize, int subgraphSizeInDwords, @NotNull ClassDefinition classDefinition, @Nullable InstanceField field2, boolean disposed) {
            Pair pair = (Pair)this.edges.get(objectId);
            RegularNode nullableNode = pair != null ? (RegularNode)pair.getFirst() : null;
            RegularNode node = null;
            if (nullableNode != null) {
                node = nullableNode;
            } else {
                RegularNode newNode = new RegularNode();
                Pair pair2 = new Pair((Object)newNode, (Object)new Edge(classDefinition, field2, disposed));
                newNode.getInstances().add(objectId);
                this.edges.put(objectId, (Object)pair2);
                node = newNode;
                node.setTotalSizeInDwords(subgraphSizeInDwords);
            }
            RegularNode regularNode = node;
            int n = regularNode.getPathsCount();
            regularNode.setPathsCount(n + 1);
            if ((long)node.getPathsSize() + (long)objectSize > (long)Integer.MAX_VALUE) {
                node.setPathsSize(Integer.MAX_VALUE);
            } else {
                RegularNode regularNode2 = node;
                regularNode2.setPathsSize(regularNode2.getPathsSize() + objectSize);
            }
            return node;
        }

        /*
         * WARNING - void declaration
         */
        private final int calculateTotalInstanceCount() {
            void result2;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            this.edges.forEachValue((TObjectProcedure)new TObjectProcedure<Pair<? extends RegularNode, ? extends Edge>>((Ref.IntRef)result2){
                final /* synthetic */ Ref.IntRef $result;

                public final boolean execute(Pair<RegularNode, Edge> $node_$_$) {
                    RegularNode node = (RegularNode)$node_$_$.component1();
                    this.$result.element += node.getPathsCount();
                    return true;
                }
                {
                    this.$result = intRef;
                }
            });
            return result2.element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final String createHotPathReport(@NotNull AnalysisConfig.TreeDisplayOptions treeDisplayOptions, @NotNull Function1<? super Integer, String> rootReasonGetter2) {
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            List rootList = new ArrayList();
            StringBuilder result2 = new StringBuilder();
            Function1 printFunc2 = (Function1)new Function1<String, Unit>(result2){
                final /* synthetic */ StringBuilder $result;

                public final void invoke(@NotNull String s) {
                    StringBuilder stringBuilder = this.$result;
                    StringBuilder stringBuilder2 = stringBuilder.append(s);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder2);
                }
                {
                    this.$result = stringBuilder;
                    super(1);
                }
            };
            this.edges.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<Pair<? extends RegularNode, ? extends Edge>>(rootList){
                final /* synthetic */ List $rootList;

                public final boolean execute(int objectId, Pair<RegularNode, Edge> $node_edge) {
                    RegularNode node = (RegularNode)$node_edge.component1();
                    Edge edge = (Edge)$node_edge.component2();
                    return this.$rootList.add(new Triple((Object)objectId, (Object)node, (Object)edge));
                }
                {
                    this.$rootList = list;
                }
            });
            int totalInstanceCount = this.calculateTotalInstanceCount();
            int minimumObjectsForReport = Math.min(treeDisplayOptions.getMinimumObjectCount(), (int)(Math.ceil((double)totalInstanceCount / 100.0) * (double)treeDisplayOptions.getMinimumObjectCountPercent()));
            SoftWeakClassCache softWeakClassCache = new SoftWeakClassCache(this.classStore);
            Iterable iterable = rootList;
            void var10_10 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $receiver$iv$iv$iv) {
                void $$_$_node_$_$;
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                Object t = item$iv$iv$iv;
                int index$iv$iv = n2;
                Triple triple = (Triple)element$iv$iv;
                int index = index$iv$iv;
                boolean bl = false;
                RegularNode node = (RegularNode)$$_$_node_$_$.component2();
                if (!(index < treeDisplayOptions.getMinimumPaths() || node.getPathsCount() >= minimumObjectsForReport || node.getPathsSize() >= treeDisplayOptions.getMinimumObjectSize())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            Comparator comparator2 = new Comparator<T>(){

                public final int compare(T a, T b) {
                    Triple it = (Triple)b;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(((RegularNode)it.getSecond()).getPathsSize());
                    it = (Triple)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    Integer n = ((RegularNode)it.getSecond()).getPathsSize();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            $receiver$iv = CollectionsKt.sortedWith((Iterable)$receiver$iv$iv, (Comparator)comparator2);
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void $rootObjectId_rootNode_rootEdge;
                int n;
                Object item$iv$iv$iv;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n3 = n;
                item$iv$iv$iv = (Triple)item$iv;
                int index = n3;
                boolean bl = false;
                int rootObjectId = ((Number)$rootObjectId_rootNode_rootEdge.component1()).intValue();
                RegularNode rootNode = (RegularNode)$rootObjectId_rootNode_rootEdge.component2();
                Edge rootEdge = (Edge)$rootObjectId_rootNode_rootEdge.component3();
                String rootReasonString = (String)rootReasonGetter2.invoke((Object)rootObjectId);
                int rootPercent = (int)(100.0 * (double)rootNode.getPathsCount() / (double)totalInstanceCount);
                Object object = result2;
                Object object2 = "Root " + (index + 1) + ':';
                StringBuilder stringBuilder = ((StringBuilder)object).append((String)object2);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder);
                this.printReportLine((Function1<? super String, ? extends Object>)printFunc2, rootNode.getPathsCount(), rootPercent, rootNode.getPathsSize(), (long)rootNode.getTotalSizeInDwords() * (long)4, 1, false, null, false, null, "", "ROOT: " + rootReasonString);
                object = new TruncatingPrintBuffer(treeDisplayOptions.getHeadLimit(), treeDisplayOptions.getTailLimit(), (Function1<? super String, ? extends Object>)printFunc2);
                object2 = null;
                try {
                    TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)object;
                    boolean bl2 = false;
                    ArrayDeque<StackEntry> stack = new ArrayDeque<StackEntry>();
                    stack.push(new StackEntry(rootEdge, rootNode, "", ""));
                    while (!stack.isEmpty()) {
                        void $receiver$iv$iv2;
                        Iterable $receiver$iv2;
                        HashMap<Edge, RegularNode> currentNodeEdges;
                        void indent;
                        void node;
                        void classDefinition;
                        void field2;
                        void edge;
                        Object object3 = (StackEntry)stack.pop();
                        Edge edge2 = ((StackEntry)object3).component1();
                        RegularNode regularNode = ((StackEntry)object3).component2();
                        String string = ((StackEntry)object3).component3();
                        String nextIndent = ((StackEntry)object3).component4();
                        void var33_40 = edge;
                        object3 = var33_40.component1();
                        InstanceField instanceField = var33_40.component2();
                        boolean disposed = var33_40.component3();
                        String softWeakDescriptor = field2 == null ? softWeakClassCache.getSoftWeakDescriptor((ClassDefinition)classDefinition) : null;
                        void v1 = field2;
                        this.printReportLine((Function1<? super String, ? extends Object>)((Function1)new Function1<String, Unit>(buffer){

                            public final void invoke(@NotNull String p1) {
                                ((TruncatingPrintBuffer)this.receiver).println(p1);
                            }

                            public final KDeclarationContainer getOwner() {
                                return Reflection.getOrCreateKotlinClass(TruncatingPrintBuffer.class);
                            }

                            public final String getName() {
                                return "println";
                            }

                            public final String getSignature() {
                                return "println(Ljava/lang/String;)V";
                            }
                        }), node.getPathsCount(), (int)(100.0 * (double)node.getPathsCount() / (double)totalInstanceCount), node.getPathsSize(), (long)node.getTotalSizeInDwords() * (long)4, node.getInstances().size(), node.getEdges() == null, softWeakDescriptor, disposed, v1 != null ? v1.getName() : null, (String)indent, classDefinition.getPrettyName());
                        if (node.getEdges() == null) {
                            continue;
                        }
                        Iterable iterable2 = currentNodeEdges.entrySet();
                        Iterable iterable3 = $receiver$iv2;
                        Comparator comparator3 = new Comparator<T>(){

                            public final int compare(T a, T b) {
                                Map.Entry it = (Map.Entry)b;
                                boolean bl = false;
                                Comparable comparable = Integer.valueOf(((RegularNode)it.getValue()).getPathsSize());
                                it = (Map.Entry)a;
                                Comparable comparable2 = comparable;
                                bl = false;
                                Integer n = ((RegularNode)it.getValue()).getPathsSize();
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                            }
                        };
                        $receiver$iv2 = CollectionsKt.sortedWith((Iterable)iterable3, (Comparator)comparator3);
                        iterable3 = $receiver$iv2;
                        Collection destination$iv$iv2 = new ArrayList();
                        void $receiver$iv$iv$iv2 = $receiver$iv$iv2;
                        int index$iv$iv$iv2 = 0;
                        for (Object item$iv$iv$iv2 : $receiver$iv$iv$iv2) {
                            void e;
                            void element$iv$iv;
                            int n4;
                            if ((n4 = index$iv$iv$iv2++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            int n5 = n4;
                            Object t = item$iv$iv$iv2;
                            int index$iv$iv = n5;
                            Map.Entry entry = (Map.Entry)element$iv$iv;
                            int index2 = index$iv$iv;
                            boolean bl3 = false;
                            if (!(index2 == 0 || ((RegularNode)e.getValue()).getPathsCount() >= minimumObjectsForReport || ((RegularNode)e.getValue()).getPathsSize() >= treeDisplayOptions.getMinimumObjectSize() || (long)((RegularNode)e.getValue()).getTotalSizeInDwords() * (long)4 >= treeDisplayOptions.getMinimumSubgraphSize())) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        List childrenToReport = CollectionsKt.asReversed((List)((List)destination$iv$iv2));
                        if (childrenToReport.size() == 1 && treeDisplayOptions.getSmartIndent()) {
                            stack.push(new StackEntry((Edge)((Map.Entry)childrenToReport.get(0)).getKey(), (RegularNode)((Map.Entry)childrenToReport.get(0)).getValue(), nextIndent, nextIndent));
                            continue;
                        }
                        if (nextIndent.length() >= treeDisplayOptions.getMaximumIndent()) {
                            this.printReportLine((Function1<? super String, ? extends Object>)((Function1)new Function1<String, Unit>(buffer){

                                public final void invoke(@NotNull String p1) {
                                    ((TruncatingPrintBuffer)this.receiver).println(p1);
                                }

                                public final KDeclarationContainer getOwner() {
                                    return Reflection.getOrCreateKotlinClass(TruncatingPrintBuffer.class);
                                }

                                public final String getName() {
                                    return "println";
                                }

                                public final String getSignature() {
                                    return "println(Ljava/lang/String;)V";
                                }
                            }), null, null, null, null, null, true, null, null, null, nextIndent, "\\-[...]");
                            continue;
                        }
                        $receiver$iv2 = childrenToReport;
                        int index$iv2 = 0;
                        for (Object item$iv2 : $receiver$iv2) {
                            void e;
                            int n6;
                            Object item$iv$iv$iv2;
                            if ((n6 = index$iv2++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            int n7 = n6;
                            item$iv$iv$iv2 = (Map.Entry)item$iv2;
                            int index3 = n7;
                            boolean bl4 = false;
                            if (index3 == 0) {
                                stack.push(new StackEntry((Edge)e.getKey(), (RegularNode)e.getValue(), nextIndent + "\\-", nextIndent + "  "));
                                continue;
                            }
                            stack.push(new StackEntry((Edge)e.getKey(), (RegularNode)e.getValue(), nextIndent + "+-", nextIndent + "| "));
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
            }
            return result2.toString();
        }

        private final void printReportLine(Function1<? super String, ? extends Object> printFunc2, Integer pathsCount, Integer percent, Integer instanceSize, Long subgraphSize, Integer instanceCount, boolean lastInPath, String softWeakDescriptor, Boolean disposed, String fieldName, String indent, String text) {
            Object object;
            String softWeakString;
            String disposedString;
            String fieldNameString;
            String status;
            String instanceCountString;
            String instanceSizeString;
            String percentString;
            String pathsCountString;
            block20: {
                block19: {
                    Object object2;
                    block18: {
                        block17: {
                            Object object3;
                            block16: {
                                block15: {
                                    Object object4;
                                    block14: {
                                        block13: {
                                            object4 = pathsCount;
                                            if (object4 == null) break block13;
                                            Integer n = object4;
                                            int it = ((Number)n).intValue();
                                            boolean bl = false;
                                            object4 = HeapReportUtils.INSTANCE.toShortStringAsCount(it);
                                            if (object4 != null) break block14;
                                        }
                                        object4 = "";
                                    }
                                    pathsCountString = StringsKt.padStart$default((String)object4, (int)5, (char)'\u0000', (int)2, null);
                                    object3 = percent;
                                    if (object3 == null) break block15;
                                    Integer it = object3;
                                    int it2 = ((Number)it).intValue();
                                    boolean bl = false;
                                    object3 = "" + it2 + '%';
                                    if (object3 != null) break block16;
                                }
                                object3 = "";
                            }
                            percentString = StringsKt.padStart$default((String)object3, (int)4, (char)'\u0000', (int)2, null);
                            object2 = instanceSize;
                            if (object2 == null) break block17;
                            Integer it2 = object2;
                            int it = ((Number)it2).intValue();
                            boolean bl = false;
                            object2 = HeapReportUtils.INSTANCE.toShortStringAsSize(it);
                            if (object2 != null) break block18;
                        }
                        object2 = "";
                    }
                    instanceSizeString = StringsKt.padStart$default((String)object2, (int)6, (char)'\u0000', (int)2, null);
                    Object object5 = instanceCount;
                    if (object5 == null) {
                        object5 = "";
                    }
                    instanceCountString = StringsKt.padStart$default((String)object5.toString(), (int)10, (char)'\u0000', (int)2, null);
                    status = lastInPath ? "*" : (softWeakDescriptor != null || Intrinsics.areEqual((Object)disposed, (Object)true) ? "!" : " ");
                    fieldNameString = fieldName != null ? '.' + fieldName : "";
                    disposedString = Intrinsics.areEqual((Object)disposed, (Object)true) ? " (disposed)" : "";
                    softWeakString = softWeakDescriptor != null ? " (" + softWeakDescriptor + ')' : "";
                    object = subgraphSize;
                    if (object == null) break block19;
                    Long l = object;
                    long it = ((Number)l).longValue();
                    boolean bl = false;
                    object = HeapReportUtils.INSTANCE.toShortStringAsSize(it);
                    if (object != null) break block20;
                }
                object = "";
            }
            String subgraphSizeString = StringsKt.padStart$default((String)object, (int)6, (char)'\u0000', (int)2, null);
            printFunc2.invoke((Object)('[' + pathsCountString + '/' + percentString + '/' + instanceSizeString + "] " + subgraphSizeString + ' ' + instanceCountString + ' ' + status + ' ' + indent + text + fieldNameString + disposedString + softWeakString));
        }

        public final void collectDisposedDominatorNodes(@NotNull Map<ClassDefinition, List<RegularNode>> result2) {
            this.edges.forEachValue((TObjectProcedure)new TObjectProcedure<Pair<? extends RegularNode, ? extends Edge>>(result2){
                final /* synthetic */ Map $result;

                public final boolean execute(Pair<RegularNode, Edge> $node_$_$) {
                    RegularNode node = (RegularNode)$node_$_$.component1();
                    node.collectDisposedDominatorNodes(this.$result);
                    return true;
                }
                {
                    this.$result = map2;
                }
            });
        }

        public RootNode(@NotNull ClassStore classStore) {
            this.classStore = classStore;
            this.edges = new TIntObjectHashMap();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RootNode$StackEntry;", "", "edge", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "node", "Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "indent", "", "nextIndent", "(Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;Ljava/lang/String;Ljava/lang/String;)V", "getEdge", "()Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$Edge;", "getIndent", "()Ljava/lang/String;", "getNextIndent", "getNode", "()Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RegularNode;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.core"})
        public static final class StackEntry {
            @NotNull
            private final Edge edge;
            @NotNull
            private final RegularNode node;
            @NotNull
            private final String indent;
            @NotNull
            private final String nextIndent;

            @NotNull
            public final Edge getEdge() {
                return this.edge;
            }

            @NotNull
            public final RegularNode getNode() {
                return this.node;
            }

            @NotNull
            public final String getIndent() {
                return this.indent;
            }

            @NotNull
            public final String getNextIndent() {
                return this.nextIndent;
            }

            public StackEntry(@NotNull Edge edge, @NotNull RegularNode node, @NotNull String indent, @NotNull String nextIndent) {
                this.edge = edge;
                this.node = node;
                this.indent = indent;
                this.nextIndent = nextIndent;
            }

            @NotNull
            public final Edge component1() {
                return this.edge;
            }

            @NotNull
            public final RegularNode component2() {
                return this.node;
            }

            @NotNull
            public final String component3() {
                return this.indent;
            }

            @NotNull
            public final String component4() {
                return this.nextIndent;
            }

            @NotNull
            public final StackEntry copy(@NotNull Edge edge, @NotNull RegularNode node, @NotNull String indent, @NotNull String nextIndent) {
                return new StackEntry(edge, node, indent, nextIndent);
            }

            @NotNull
            public static /* synthetic */ StackEntry copy$default(StackEntry stackEntry, Edge edge, RegularNode regularNode, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    edge = stackEntry.edge;
                }
                if ((n & 2) != 0) {
                    regularNode = stackEntry.node;
                }
                if ((n & 4) != 0) {
                    string = stackEntry.indent;
                }
                if ((n & 8) != 0) {
                    string2 = stackEntry.nextIndent;
                }
                return stackEntry.copy(edge, regularNode, string, string2);
            }

            @NotNull
            public String toString() {
                return "StackEntry(edge=" + this.edge + ", node=" + this.node + ", indent=" + this.indent + ", nextIndent=" + this.nextIndent + ")";
            }

            public int hashCode() {
                Edge edge = this.edge;
                RegularNode regularNode = this.node;
                String string = this.indent;
                String string2 = this.nextIndent;
                return (((edge != null ? ((Object)edge).hashCode() : 0) * 31 + (regularNode != null ? regularNode.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof StackEntry)) break block3;
                        StackEntry stackEntry = (StackEntry)object;
                        if (!Intrinsics.areEqual((Object)this.edge, (Object)stackEntry.edge) || !Intrinsics.areEqual((Object)this.node, (Object)stackEntry.node) || !Intrinsics.areEqual((Object)this.indent, (Object)stackEntry.indent) || !Intrinsics.areEqual((Object)this.nextIndent, (Object)stackEntry.nextIndent)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/GCRootPathsTree$RootNode$SoftWeakClassCache;", "", "classStore", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "(Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;)V", "nonSoftWeakClasses", "", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "getNonSoftWeakClasses", "()Ljava/util/Set;", "softClasses", "getSoftClasses", "weakClasses", "getWeakClasses", "getSoftWeakDescriptor", "", "classDefinition", "intellij.android.core"})
        private static final class SoftWeakClassCache {
            @NotNull
            private final Set<ClassDefinition> softClasses;
            @NotNull
            private final Set<ClassDefinition> weakClasses;
            @NotNull
            private final Set<ClassDefinition> nonSoftWeakClasses;
            private final ClassStore classStore;

            @NotNull
            public final Set<ClassDefinition> getSoftClasses() {
                return this.softClasses;
            }

            @NotNull
            public final Set<ClassDefinition> getWeakClasses() {
                return this.weakClasses;
            }

            @NotNull
            public final Set<ClassDefinition> getNonSoftWeakClasses() {
                return this.nonSoftWeakClasses;
            }

            @Nullable
            public final String getSoftWeakDescriptor(@NotNull ClassDefinition classDefinition) {
                if (this.softClasses.contains(classDefinition)) {
                    return "soft";
                }
                if (this.weakClasses.contains(classDefinition)) {
                    return "weak";
                }
                if (this.nonSoftWeakClasses.contains(classDefinition)) {
                    return null;
                }
                ClassDefinition definition = classDefinition;
                while (!this.classStore.isSoftOrWeakReferenceClass(definition)) {
                    ClassDefinition superclassDefinition = definition.getSuperClass(this.classStore);
                    if (superclassDefinition == null) {
                        this.nonSoftWeakClasses.add(classDefinition);
                        return null;
                    }
                    definition = superclassDefinition;
                }
                if (Intrinsics.areEqual((Object)definition, (Object)this.classStore.getWeakReferenceClass())) {
                    this.weakClasses.add(classDefinition);
                    return "weak";
                }
                boolean bl = Intrinsics.areEqual((Object)definition, (Object)this.classStore.getSoftReferenceClass());
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                this.softClasses.add(classDefinition);
                return "soft";
            }

            public SoftWeakClassCache(@NotNull ClassStore classStore) {
                Set set;
                this.classStore = classStore;
                SoftWeakClassCache softWeakClassCache = this;
                softWeakClassCache.softClasses = set = (Set)new LinkedHashSet();
                softWeakClassCache = this;
                softWeakClassCache.weakClasses = set = (Set)new LinkedHashSet();
                softWeakClassCache = this;
                softWeakClassCache.nonSoftWeakClasses = set = (Set)new LinkedHashSet();
            }
        }
    }
}

