/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.histogram;

import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisConfig;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassStore;
import com.android.tools.idea.diagnostics.hprof.histogram.HistogramEntry;
import com.android.tools.idea.diagnostics.hprof.parser.HProfEventBasedParser;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import com.android.tools.idea.diagnostics.hprof.util.TruncatingPrintBuffer;
import com.android.tools.idea.diagnostics.hprof.visitors.HistogramVisitor;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/histogram/Histogram;", "", "entries", "", "Lcom/android/tools/idea/diagnostics/hprof/histogram/HistogramEntry;", "instanceCount", "", "(Ljava/util/List;J)V", "bytesCount", "getBytesCount", "()J", "getEntries", "()Ljava/util/List;", "getInstanceCount", "getTotals", "Lkotlin/Pair;", "prepareReport", "", "name", "topClassCount", "", "Companion", "intellij.android.core"})
public final class Histogram {
    private final long bytesCount;
    @NotNull
    private final List<HistogramEntry> entries;
    private final long instanceCount;
    public static final Companion Companion = new Companion(null);

    private final Pair<Long, Long> getTotals() {
        long totalInstances = 0L;
        long totalBytes = 0L;
        Iterable $receiver$iv = this.entries;
        for (Object element$iv : $receiver$iv) {
            HistogramEntry it = (HistogramEntry)element$iv;
            boolean bl = false;
            totalBytes += it.getTotalBytes();
            totalInstances += it.getTotalInstances();
        }
        return new Pair((Object)totalInstances, (Object)totalBytes);
    }

    public final long getBytesCount() {
        return this.bytesCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String prepareReport(@NotNull String name, int topClassCount) {
        Object object;
        StringBuilder result2;
        StringBuilder stringBuilder = result2 = new StringBuilder();
        String string = "Histogram. Top " + topClassCount + " by instance count:";
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        Function1 appendToResult2 = (Function1)new Function1<String, Unit>(result2){
            final /* synthetic */ StringBuilder $result;

            public final void invoke(@NotNull String s) {
                StringBuilder stringBuilder = this.$result;
                StringBuilder stringBuilder2 = stringBuilder.append(s);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
            }
            {
                this.$result = stringBuilder;
                super(1);
            }
        };
        int counter = 1;
        Object object2 = new TruncatingPrintBuffer(topClassCount, 0, (Function1<? super String, ? extends Object>)appendToResult2);
        Object object3 = null;
        try {
            TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)object2;
            boolean bl = false;
            Iterable $receiver$iv = this.entries;
            for (Object element$iv : $receiver$iv) {
                HistogramEntry entry = (HistogramEntry)element$iv;
                boolean bl2 = false;
                buffer.println(Histogram.Companion.formatEntryLine(counter, entry));
                int n = counter;
                counter = n + 1;
            }
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object3 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        object2 = result2;
        object3 = Histogram.Companion.getSummaryLine(this, name);
        StringBuilder stringBuilder3 = ((StringBuilder)object2).append((String)object3);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        StringsKt.appendln((StringBuilder)result2);
        object2 = result2;
        object3 = "Top 10 by bytes count:";
        StringBuilder stringBuilder4 = ((StringBuilder)object2).append((String)object3);
        Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        Iterable $receiver$iv22 = this.entries;
        object = $receiver$iv22;
        Comparator bl = new Comparator<T>(){

            public final int compare(T a, T b) {
                HistogramEntry it = (HistogramEntry)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getTotalBytes());
                it = (HistogramEntry)a;
                Comparable comparable2 = comparable;
                bl = false;
                Long l = it.getTotalBytes();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
            }
        };
        List entriesByBytes = CollectionsKt.sortedWith((Iterable)object, (Comparator)bl);
        int $receiver$iv22 = 0;
        int n = 10;
        while ($receiver$iv22 < n) {
            void i2;
            HistogramEntry entry = (HistogramEntry)entriesByBytes.get((int)i2);
            StringBuilder stringBuilder5 = result2;
            String string2 = Histogram.Companion.formatEntryLine((int)(i2 + true), entry);
            StringBuilder stringBuilder6 = stringBuilder5.append(string2);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder6);
            ++i2;
        }
        return result2.toString();
    }

    @NotNull
    public final List<HistogramEntry> getEntries() {
        return this.entries;
    }

    public final long getInstanceCount() {
        return this.instanceCount;
    }

    public Histogram(@NotNull List<HistogramEntry> entries, long instanceCount) {
        this.entries = entries;
        this.instanceCount = instanceCount;
        this.bytesCount = ((Number)this.getTotals().getSecond()).longValue();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\nH\u0002J.\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/histogram/Histogram$Companion;", "", "()V", "create", "Lcom/android/tools/idea/diagnostics/hprof/histogram/Histogram;", "parser", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfEventBasedParser;", "classStore", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "formatEntryLine", "", "counter", "", "entry", "Lcom/android/tools/idea/diagnostics/hprof/histogram/HistogramEntry;", "formatEntryLineMerged", "entry2", "getSummaryLine", "histogram", "histogramName", "prepareMergedHistogramReport", "mainHistogram", "mainHistogramName", "secondaryHistogram", "secondaryHistogramName", "options", "Lcom/android/tools/idea/diagnostics/hprof/analysis/AnalysisConfig$HistogramOptions;", "intellij.android.core"})
    public static final class Companion {
        @NotNull
        public final Histogram create(@NotNull HProfEventBasedParser parser, @NotNull ClassStore classStore) {
            HistogramVisitor histogramVisitor = new HistogramVisitor(classStore);
            parser.accept(histogramVisitor, "histogram");
            return histogramVisitor.createHistogram();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final String prepareMergedHistogramReport(@NotNull Histogram mainHistogram, @NotNull String mainHistogramName, @NotNull Histogram secondaryHistogram, @NotNull String secondaryHistogramName, @NotNull AnalysisConfig.HistogramOptions options) {
            Object object;
            Object it;
            Object element$iv2;
            StringBuilder result2 = new StringBuilder();
            Function1 appendToResult2 = (Function1)new Function1<String, Unit>(result2){
                final /* synthetic */ StringBuilder $result;

                public final void invoke(@NotNull String s) {
                    StringBuilder stringBuilder = this.$result;
                    StringBuilder stringBuilder2 = stringBuilder.append(s);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder2);
                }
                {
                    this.$result = stringBuilder;
                    super(1);
                }
            };
            HashMap mapClassNameToEntrySecondary = new HashMap();
            Iterable $receiver$iv = secondaryHistogram.getEntries();
            for (Object element$iv2 : $receiver$iv) {
                it = (HistogramEntry)element$iv2;
                boolean bl = false;
                Map map2 = mapClassNameToEntrySecondary;
                String string = ((HistogramEntry)it).getClassDefinition().getName();
                object = it;
                map2.put(string, object);
            }
            String summary = this.getSummaryLine(mainHistogram, mainHistogramName) + '\n' + this.getSummaryLine(secondaryHistogram, secondaryHistogramName);
            if (options.getIncludeByCount()) {
                StringBuilder stringBuilder = result2;
                element$iv2 = "Histogram. Top " + options.getClassByCountLimit() + " by instance count [All-objects] [Only-strong-ref]:";
                StringBuilder stringBuilder2 = stringBuilder.append((String)element$iv2);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
                int counter = 1;
                element$iv2 = new TruncatingPrintBuffer(options.getClassByCountLimit(), 0, (Function1<? super String, ? extends Object>)appendToResult2);
                it = null;
                try {
                    TruncatingPrintBuffer buffer = (TruncatingPrintBuffer)element$iv2;
                    boolean bl = false;
                    Iterable $receiver$iv2 = mainHistogram.getEntries();
                    for (Object element$iv3 : $receiver$iv2) {
                        HistogramEntry entry = (HistogramEntry)element$iv3;
                        boolean bl2 = false;
                        HistogramEntry entry2 = (HistogramEntry)mapClassNameToEntrySecondary.get(entry.getClassDefinition().getName());
                        buffer.println(Companion.formatEntryLineMerged(counter, entry, entry2));
                        int n = counter;
                        counter = n + 1;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    it = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)element$iv2, (Throwable)it);
                }
                element$iv2 = result2;
                StringBuilder stringBuilder3 = ((StringBuilder)element$iv2).append(summary);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder3, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder3);
            }
            if (options.getIncludeBySize() && options.getIncludeByCount()) {
                StringsKt.appendln((StringBuilder)result2);
            }
            if (options.getIncludeBySize()) {
                Iterable $receiver$iv22;
                int classCountInByBytesSection = Math.min(mainHistogram.getEntries().size(), options.getClassBySizeLimit());
                element$iv2 = result2;
                it = "Top " + classCountInByBytesSection + " by size:";
                StringBuilder stringBuilder = ((StringBuilder)element$iv2).append((String)it);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder);
                Iterable iterable = $receiver$iv22 = (Iterable)mainHistogram.getEntries();
                Comparator bl = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        HistogramEntry it = (HistogramEntry)b;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(it.getTotalBytes());
                        it = (HistogramEntry)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        Long l = it.getTotalBytes();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)l);
                    }
                };
                List entriesByBytes = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)bl);
                int $receiver$iv22 = 0;
                int n = classCountInByBytesSection;
                while ($receiver$iv22 < n) {
                    void i2;
                    HistogramEntry entry = (HistogramEntry)entriesByBytes.get((int)i2);
                    HistogramEntry entry2 = (HistogramEntry)mapClassNameToEntrySecondary.get(entry.getClassDefinition().getName());
                    object = result2;
                    String string = this.formatEntryLineMerged((int)(i2 + true), entry, entry2);
                    StringBuilder stringBuilder4 = ((StringBuilder)object).append(string);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder4, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder4);
                    ++i2;
                }
                if (!options.getIncludeByCount()) {
                    StringBuilder stringBuilder5 = result2;
                    StringBuilder stringBuilder6 = stringBuilder5.append(summary);
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder6, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder6);
                }
            }
            return result2.toString();
        }

        /*
         * WARNING - void declaration
         */
        private final String getSummaryLine(Histogram histogram, String histogramName) {
            void totalInstances;
            Pair pair = histogram.getTotals();
            long l = ((Number)pair.component1()).longValue();
            long totalBytes = ((Number)pair.component2()).longValue();
            pair = StringCompanionObject.INSTANCE;
            String string = "Total - %10s: %s %s %d classes (Total instances: %d)";
            Object[] objectArray = new Object[]{histogramName, HeapReportUtils.INSTANCE.toPaddedShortStringAsCount((long)totalInstances), HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(totalBytes), histogram.getEntries().size(), histogram.getInstanceCount()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        private final String formatEntryLineMerged(int counter, HistogramEntry entry, HistogramEntry entry2) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%5d: [%s/%s] [%s/%s] %s";
            Object[] objectArray = new Object[6];
            objectArray[0] = counter;
            objectArray[1] = HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(entry.getTotalInstances());
            objectArray[2] = HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(entry.getTotalBytes());
            HistogramEntry histogramEntry = entry2;
            objectArray[3] = HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(histogramEntry != null ? histogramEntry.getTotalInstances() : 0L);
            HistogramEntry histogramEntry2 = entry2;
            objectArray[4] = HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(histogramEntry2 != null ? histogramEntry2.getTotalBytes() : 0L);
            objectArray[5] = entry.getClassDefinition().getPrettyName();
            Object[] objectArray2 = objectArray;
            String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        private final String formatEntryLine(int counter, HistogramEntry entry) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%5d: [%s/%s] %s";
            Object[] objectArray = new Object[]{counter, HeapReportUtils.INSTANCE.toPaddedShortStringAsCount(entry.getTotalInstances()), HeapReportUtils.INSTANCE.toPaddedShortStringAsSize(entry.getTotalBytes()), entry.getClassDefinition().getPrettyName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            return string2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

