/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.navigator;

import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/navigator/RootReason;", "", "description", "", "javaFrame", "", "(Ljava/lang/String;Z)V", "getDescription", "()Ljava/lang/String;", "getJavaFrame", "()Z", "Companion", "intellij.android.core"})
public final class RootReason {
    @NotNull
    private final String description;
    private final boolean javaFrame;
    @NotNull
    private static final RootReason rootUnknown;
    @NotNull
    private static final RootReason rootGlobalJNI;
    @NotNull
    private static final RootReason rootLocalJNI;
    @NotNull
    private static final RootReason rootNativeStack;
    @NotNull
    private static final RootReason rootStickyClass;
    @NotNull
    private static final RootReason rootThreadBlock;
    @NotNull
    private static final RootReason rootThreadObject;
    @NotNull
    private static final RootReason rootMonitorUsed;
    public static final Companion Companion;

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final boolean getJavaFrame() {
        return this.javaFrame;
    }

    private RootReason(String description, boolean javaFrame) {
        this.description = description;
        this.javaFrame = javaFrame;
    }

    /* synthetic */ RootReason(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }

    static {
        Companion = new Companion(null);
        rootUnknown = new RootReason("Unknown", false, 2, null);
        rootGlobalJNI = new RootReason("Global JNI", false, 2, null);
        rootLocalJNI = new RootReason("Local JNI", false, 2, null);
        rootNativeStack = new RootReason("Native stack", false, 2, null);
        rootStickyClass = new RootReason("Sticky class", false, 2, null);
        rootThreadBlock = new RootReason("Thread block", false, 2, null);
        rootThreadObject = new RootReason("Thread object", false, 2, null);
        rootMonitorUsed = new RootReason("Monitor used", false, 2, null);
    }

    public /* synthetic */ RootReason(String description, boolean javaFrame, DefaultConstructorMarker $constructor_marker) {
        this(description, javaFrame);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u001dR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/diagnostics/hprof/navigator/RootReason$Companion;", "", "()V", "rootGlobalJNI", "Lcom/android/tools/idea/diagnostics/hprof/navigator/RootReason;", "getRootGlobalJNI", "()Lcom/android/tools/idea/diagnostics/hprof/navigator/RootReason;", "rootLocalJNI", "getRootLocalJNI", "rootMonitorUsed", "getRootMonitorUsed", "rootNativeStack", "getRootNativeStack", "rootStickyClass", "getRootStickyClass", "rootThreadBlock", "getRootThreadBlock", "rootThreadObject", "getRootThreadObject", "rootUnknown", "getRootUnknown", "createClassDefinitionReason", "classDefinition", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "createConstantReferenceReason", "constantNumber", "", "createJavaFrameReason", "frameDescription", "", "createStaticFieldReferenceReason", "staticFieldName", "intellij.android.core"})
    public static final class Companion {
        @NotNull
        public final RootReason createConstantReferenceReason(@NotNull ClassDefinition classDefinition, int constantNumber) {
            return new RootReason("Class constant: " + classDefinition.getName() + ".#" + constantNumber, false, 2, null);
        }

        @NotNull
        public final RootReason createStaticFieldReferenceReason(@NotNull ClassDefinition classDefinition, @NotNull String staticFieldName) {
            return new RootReason("Static field: " + classDefinition.getName() + '.' + staticFieldName, false, 2, null);
        }

        @NotNull
        public final RootReason createClassDefinitionReason(@NotNull ClassDefinition classDefinition) {
            return new RootReason("Class definition: " + classDefinition.getName(), false, 2, null);
        }

        @NotNull
        public final RootReason createJavaFrameReason(@NotNull String frameDescription) {
            return new RootReason("Java Frame: " + frameDescription, true, null);
        }

        @NotNull
        public final RootReason getRootUnknown() {
            return rootUnknown;
        }

        @NotNull
        public final RootReason getRootGlobalJNI() {
            return rootGlobalJNI;
        }

        @NotNull
        public final RootReason getRootLocalJNI() {
            return rootLocalJNI;
        }

        @NotNull
        public final RootReason getRootNativeStack() {
            return rootNativeStack;
        }

        @NotNull
        public final RootReason getRootStickyClass() {
            return rootStickyClass;
        }

        @NotNull
        public final RootReason getRootThreadBlock() {
            return rootThreadBlock;
        }

        @NotNull
        public final RootReason getRootThreadObject() {
            return rootThreadObject;
        }

        @NotNull
        public final RootReason getRootMonitorUsed() {
            return rootMonitorUsed;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

