/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.visitors;

import com.android.tools.idea.diagnostics.hprof.classstore.ClassDefinition;
import com.android.tools.idea.diagnostics.hprof.classstore.ClassStore;
import com.android.tools.idea.diagnostics.hprof.classstore.InstanceField;
import com.android.tools.idea.diagnostics.hprof.parser.ConstantPoolEntry;
import com.android.tools.idea.diagnostics.hprof.parser.HProfEventBasedParser;
import com.android.tools.idea.diagnostics.hprof.parser.HProfVisitor;
import com.android.tools.idea.diagnostics.hprof.parser.HeapDumpRecordType;
import com.android.tools.idea.diagnostics.hprof.parser.InstanceFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.StaticFieldEntry;
import com.android.tools.idea.diagnostics.hprof.parser.Type;
import com.android.tools.idea.diagnostics.hprof.util.FileChannelBackedWriteBuffer;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 42\u00020\u0001:\u00014B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J_\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001dH\u0016\u00a2\u0006\u0002\u0010#J(\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020(H\u0016J(\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-H\u0016J(\u0010.\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u000201H\u0016J\u0014\u00102\u001a\u00020\u0013*\u00020\u000b2\u0006\u00103\u001a\u00020\rH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/visitors/CreateAuxiliaryFilesVisitor;", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfVisitor;", "auxOffsetsChannel", "Ljava/nio/channels/FileChannel;", "auxChannel", "classStore", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;", "parser", "Lcom/android/tools/idea/diagnostics/hprof/parser/HProfEventBasedParser;", "(Ljava/nio/channels/FileChannel;Ljava/nio/channels/FileChannel;Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassStore;Lcom/android/tools/idea/diagnostics/hprof/parser/HProfEventBasedParser;)V", "aux", "Lcom/android/tools/idea/diagnostics/hprof/util/FileChannelBackedWriteBuffer;", "directByteBufferCapacityOffset", "", "directByteBufferClass", "Lcom/android/tools/idea/diagnostics/hprof/classstore/ClassDefinition;", "directByteBufferFdOffset", "offsets", "postVisit", "", "preVisit", "visitClassDump", "classId", "", "stackTraceSerialNumber", "superClassId", "classloaderClassId", "instanceSize", "constants", "", "Lcom/android/tools/idea/diagnostics/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/android/tools/idea/diagnostics/hprof/parser/StaticFieldEntry;", "instanceFields", "Lcom/android/tools/idea/diagnostics/hprof/parser/InstanceFieldEntry;", "(JJJJJ[Lcom/android/tools/idea/diagnostics/hprof/parser/ConstantPoolEntry;[Lcom/android/tools/idea/diagnostics/hprof/parser/StaticFieldEntry;[Lcom/android/tools/idea/diagnostics/hprof/parser/InstanceFieldEntry;)V", "visitInstanceDump", "objectId", "classObjectId", "bytes", "Ljava/nio/ByteBuffer;", "visitObjectArrayDump", "arrayObjectId", "arrayClassObjectId", "objects", "", "visitPrimitiveArrayDump", "numberOfElements", "elementType", "Lcom/android/tools/idea/diagnostics/hprof/parser/Type;", "writeId", "id", "Companion", "intellij.android.core"})
public final class CreateAuxiliaryFilesVisitor
extends HProfVisitor {
    private FileChannelBackedWriteBuffer offsets;
    private FileChannelBackedWriteBuffer aux;
    private ClassDefinition directByteBufferClass;
    private int directByteBufferCapacityOffset;
    private int directByteBufferFdOffset;
    private final FileChannel auxOffsetsChannel;
    private final FileChannel auxChannel;
    private final ClassStore classStore;
    private final HProfEventBasedParser parser;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    public void preVisit() {
        this.disableAll();
        this.enable(HeapDumpRecordType.ClassDump);
        this.enable(HeapDumpRecordType.InstanceDump);
        this.enable(HeapDumpRecordType.ObjectArrayDump);
        this.enable(HeapDumpRecordType.PrimitiveArrayDump);
        this.offsets = new FileChannelBackedWriteBuffer(this.auxOffsetsChannel, false, 2, null);
        this.aux = new FileChannelBackedWriteBuffer(this.auxChannel, false, 2, null);
        this.directByteBufferClass = null;
        ClassDefinition dbbClass = this.classStore.getClassIfExists("java.nio.DirectByteBuffer");
        if (dbbClass != null) {
            this.directByteBufferClass = dbbClass;
            this.directByteBufferCapacityOffset = dbbClass.computeOffsetOfField("capacity", this.classStore);
            this.directByteBufferFdOffset = dbbClass.computeOffsetOfField("fd", this.classStore);
            if (this.directByteBufferCapacityOffset == -1 || this.directByteBufferFdOffset == -1) {
                LOG.error("DirectByteBuffer.capacity and/or .fd field is missing.");
            }
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer = this.offsets;
        if (fileChannelBackedWriteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        fileChannelBackedWriteBuffer.writeInt(0);
    }

    @Override
    public void postVisit() {
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer = this.aux;
        if (fileChannelBackedWriteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer.close();
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer2 = this.offsets;
        if (fileChannelBackedWriteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        fileChannelBackedWriteBuffer2.close();
    }

    @Override
    public void visitPrimitiveArrayDump(long arrayObjectId, long stackTraceSerialNumber, long numberOfElements, @NotNull Type elementType) {
        boolean bl;
        boolean bl2 = bl = arrayObjectId <= (long)Integer.MAX_VALUE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer = this.offsets;
        if (fileChannelBackedWriteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        boolean bl3 = bl = fileChannelBackedWriteBuffer.position() / 4 == (int)arrayObjectId;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer2 = this.offsets;
        if (fileChannelBackedWriteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer3 = this.aux;
        if (fileChannelBackedWriteBuffer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer2.writeInt(fileChannelBackedWriteBuffer3.position());
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer4 = this.aux;
        if (fileChannelBackedWriteBuffer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        ClassDefinition classDefinition = this.classStore.getClassForPrimitiveArray(elementType);
        if (classDefinition == null) {
            Intrinsics.throwNpe();
        }
        this.writeId(fileChannelBackedWriteBuffer4, (int)classDefinition.getId());
        boolean bl4 = bl = numberOfElements <= (long)Integer.MAX_VALUE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer5 = this.aux;
        if (fileChannelBackedWriteBuffer5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer5.writeNonNegativeLEB128Int((int)numberOfElements);
    }

    @Override
    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        boolean bl;
        boolean bl2 = bl = classId <= (long)Integer.MAX_VALUE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer = this.offsets;
        if (fileChannelBackedWriteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        boolean bl3 = bl = fileChannelBackedWriteBuffer.position() / 4 == (int)classId;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer2 = this.offsets;
        if (fileChannelBackedWriteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer3 = this.aux;
        if (fileChannelBackedWriteBuffer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer2.writeInt(fileChannelBackedWriteBuffer3.position());
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer4 = this.aux;
        if (fileChannelBackedWriteBuffer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        this.writeId(fileChannelBackedWriteBuffer4, 0);
    }

    @Override
    public void visitObjectArrayDump(long arrayObjectId, long stackTraceSerialNumber, long arrayClassObjectId, @NotNull long[] objects) {
        long[] $receiver$iv;
        long it;
        long element$iv;
        int n;
        boolean bl;
        boolean bl2 = bl = arrayObjectId <= (long)Integer.MAX_VALUE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl3 = bl = arrayClassObjectId <= (long)Integer.MAX_VALUE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer = this.offsets;
        if (fileChannelBackedWriteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        boolean bl4 = bl = fileChannelBackedWriteBuffer.position() / 4 == (int)arrayObjectId;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer2 = this.offsets;
        if (fileChannelBackedWriteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer3 = this.aux;
        if (fileChannelBackedWriteBuffer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer2.writeInt(fileChannelBackedWriteBuffer3.position());
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer4 = this.aux;
        if (fileChannelBackedWriteBuffer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        this.writeId(fileChannelBackedWriteBuffer4, (int)arrayClassObjectId);
        long[] $receiver$iv2 = objects;
        int count$iv22 = 0;
        long[] lArray = $receiver$iv2;
        int n2 = lArray.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = lArray[n];
            boolean bl5 = false;
            if (!(it != 0L)) continue;
            ++count$iv22;
        }
        int nonNullElementsCount = count$iv22;
        long[] count$iv22 = objects;
        int nullElementsCount = count$iv22.length - nonNullElementsCount;
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer5 = this.aux;
        if (fileChannelBackedWriteBuffer5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer5.writeNonNegativeLEB128Int(nullElementsCount);
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer6 = this.aux;
        if (fileChannelBackedWriteBuffer6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer6.writeNonNegativeLEB128Int(nonNullElementsCount);
        lArray = $receiver$iv = objects;
        n2 = lArray.length;
        for (n = 0; n < n2; ++n) {
            boolean bl6;
            it = element$iv = lArray[n];
            boolean bl7 = false;
            if (it == 0L) continue;
            boolean bl8 = bl6 = it <= (long)Integer.MAX_VALUE;
            if (_Assertions.ENABLED && !bl6) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer7 = this.aux;
            if (fileChannelBackedWriteBuffer7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
            }
            this.writeId(fileChannelBackedWriteBuffer7, (int)it);
        }
    }

    @Override
    public void visitInstanceDump(long objectId, long stackTraceSerialNumber, long classObjectId, @NotNull ByteBuffer bytes) {
        CreateAuxiliaryFilesVisitor createAuxiliaryFilesVisitor;
        boolean bl;
        boolean bl2 = bl = objectId <= (long)Integer.MAX_VALUE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl3 = bl = classObjectId <= (long)Integer.MAX_VALUE;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer = this.offsets;
        if (fileChannelBackedWriteBuffer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        boolean bl4 = bl = fileChannelBackedWriteBuffer.position() / 4 == (int)objectId;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer2 = this.offsets;
        if (fileChannelBackedWriteBuffer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"offsets");
        }
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer3 = this.aux;
        if (fileChannelBackedWriteBuffer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        fileChannelBackedWriteBuffer2.writeInt(fileChannelBackedWriteBuffer3.position());
        FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer4 = this.aux;
        if (fileChannelBackedWriteBuffer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
        }
        this.writeId(fileChannelBackedWriteBuffer4, (int)classObjectId);
        int classOffset = 0;
        ClassDefinition objectClass = this.classStore.get(classObjectId);
        CreateAuxiliaryFilesVisitor $receiver = createAuxiliaryFilesVisitor = this;
        boolean bl5 = false;
        ClassDefinition classDef = objectClass;
        while (true) {
            InstanceField[] $receiver$iv;
            InstanceField[] instanceFieldArray = $receiver$iv = classDef.getRefInstanceFields();
            int n = instanceFieldArray.length;
            for (int j = 0; j < n; ++j) {
                boolean bl6;
                InstanceField element$iv;
                InstanceField it = element$iv = instanceFieldArray[j];
                boolean bl7 = false;
                int offset = classOffset + it.getOffset();
                long value2 = bytes.getLong(offset);
                if (value2 == 0L) {
                    FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer5 = $receiver.aux;
                    if (fileChannelBackedWriteBuffer5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                    }
                    $receiver.writeId(fileChannelBackedWriteBuffer5, 0);
                    continue;
                }
                long reference2 = $receiver.parser.remap(value2);
                boolean bl8 = bl6 = reference2 != 0L;
                if (_Assertions.ENABLED && !bl6) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer6 = $receiver.aux;
                if (fileChannelBackedWriteBuffer6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                }
                $receiver.writeId(fileChannelBackedWriteBuffer6, (int)reference2);
            }
            classOffset += classDef.getSuperClassOffset();
            if (classDef.getSuperClassId() == 0L) break;
            classDef = $receiver.classStore.get(classDef.getSuperClassId());
        }
        if (Intrinsics.areEqual((Object)objectClass, (Object)this.directByteBufferClass)) {
            if (this.directByteBufferCapacityOffset == -1 || this.directByteBufferFdOffset == -1) {
                FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer7 = this.aux;
                if (fileChannelBackedWriteBuffer7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                }
                fileChannelBackedWriteBuffer7.writeNonNegativeLEB128Int(1);
            } else {
                int directByteBufferCapacity = bytes.getInt(this.directByteBufferCapacityOffset);
                long directByteBufferFd = bytes.getLong(this.directByteBufferFdOffset);
                if (directByteBufferFd == 0L) {
                    FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer8 = this.aux;
                    if (fileChannelBackedWriteBuffer8 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                    }
                    fileChannelBackedWriteBuffer8.writeNonNegativeLEB128Int(directByteBufferCapacity);
                } else {
                    FileChannelBackedWriteBuffer fileChannelBackedWriteBuffer9 = this.aux;
                    if (fileChannelBackedWriteBuffer9 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"aux");
                    }
                    fileChannelBackedWriteBuffer9.writeNonNegativeLEB128Int(1);
                }
            }
        }
    }

    private final void writeId(@NotNull FileChannelBackedWriteBuffer $receiver, int id) {
        $receiver.writeNonNegativeLEB128Int(id);
    }

    public CreateAuxiliaryFilesVisitor(@NotNull FileChannel auxOffsetsChannel, @NotNull FileChannel auxChannel, @NotNull ClassStore classStore, @NotNull HProfEventBasedParser parser) {
        this.auxOffsetsChannel = auxOffsetsChannel;
        this.auxChannel = auxChannel;
        this.classStore = classStore;
        this.parser = parser;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(CreateAuxiliaryFilesVisitor.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/visitors/CreateAuxiliaryFilesVisitor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

