/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector;

import com.android.ddmlib.Client;
import com.android.layoutinspector.model.ClientWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowPickerDialog
extends DialogWrapper {
    @NonNls
    private static final String WINDOW_PICKER_DIMENSIONS_KEY = "LayoutInspector.WindowPicker.Options.Dimensions";
    private final JPanel myPanel;
    private final JComboBox myWindowsCombo;
    @Nullable
    ClientWindow mySelectedWindow;

    public WindowPickerDialog(@NotNull Project project, @NotNull Client client, @NotNull List<ClientWindow> windows) {
        super(project, true);
        this.setTitle(AndroidBundle.message("android.ddms.actions.layoutinspector.windowpicker", new Object[0]));
        this.myPanel = new JPanel(new BorderLayout());
        this.myWindowsCombo = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(windows));
        this.myWindowsCombo.setRenderer(new ClientWindowRenderer());
        this.myWindowsCombo.setSelectedIndex(0);
        this.myPanel.add((Component)this.myWindowsCombo, "Center");
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return WINDOW_PICKER_DIMENSIONS_KEY;
    }

    protected void doOKAction() {
        Object selection = this.myWindowsCombo.getSelectedItem();
        if (selection instanceof ClientWindow) {
            this.mySelectedWindow = (ClientWindow)selection;
        }
        super.doOKAction();
    }

    @Nullable
    public ClientWindow getSelectedWindow() {
        return this.mySelectedWindow;
    }

    private static class ClientWindowRenderer
    extends ColoredListCellRenderer {
        private ClientWindowRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list, Object value2, int index, boolean selected, boolean hasFocus) {
            assert (value2 instanceof ClientWindow);
            this.append(((ClientWindow)value2).getDisplayName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

