/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.actions;

import com.android.ddmlib.Client;
import com.android.tools.idea.editors.layoutInspector.AndroidLayoutInspectorService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import icons.StudioIcons;
import org.jetbrains.android.actions.AndroidProcessChooserDialog;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nullable;

public class AndroidRunLayoutInspectorAction
extends AnAction {
    public AndroidRunLayoutInspectorAction() {
        super(AndroidBundle.message("android.ddms.actions.layoutinspector.title", new Object[0]), AndroidBundle.message("android.ddms.actions.layoutinspector.description", new Object[0]), StudioIcons.Shell.Menu.LAYOUT_INSPECTOR);
    }

    public void update(AnActionEvent e) {
        super.update(e);
        if (AndroidRunLayoutInspectorAction.isDebuggerPaused(e.getProject())) {
            e.getPresentation().setDescription(AndroidBundle.message("android.ddms.actions.layoutinspector.description.disabled", new Object[0]));
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setDescription(AndroidBundle.message("android.ddms.actions.layoutinspector.description", new Object[0]));
            e.getPresentation().setEnabled(true);
        }
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        assert (project != null);
        AndroidProcessChooserDialog dialog2 = new AndroidProcessChooserDialog(project, false);
        dialog2.show();
        if (dialog2.getExitCode() == 0) {
            Client client = dialog2.getClient();
            if (client != null) {
                ((AndroidLayoutInspectorService)ServiceManager.getService((Project)project, AndroidLayoutInspectorService.class)).getTask(project, client).queue();
            } else {
                Logger.getInstance(AndroidRunLayoutInspectorAction.class).warn("Not launching layout inspector - no client selected");
            }
        }
    }

    public static boolean isDebuggerPaused(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        return session != null && !session.isStopped() && session.isPaused();
    }
}

