/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.actions;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.editors.layoutInspector.ui.ViewNodeActiveDisplay;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutInspectorEvent;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/editors/layoutInspector/actions/LoadOverlayAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "myPreview", "Lcom/android/tools/idea/editors/layoutInspector/ui/ViewNodeActiveDisplay;", "(Lcom/android/tools/idea/editors/layoutInspector/ui/ViewNodeActiveDisplay;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "loadImageFile", "Ljava/awt/Image;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadOverlay", "update", "Companion", "android-layout-inspector"})
public final class LoadOverlayAction
extends AnAction
implements CustomComponentAction {
    private final ViewNodeActiveDisplay myPreview;
    @JvmField
    @NotNull
    public static final String ACTION_ID = "Load Overlay";
    @JvmField
    @NotNull
    public static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        return (JComponent)new ActionButtonWithText((AnAction)this, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        if (e == null) {
            return;
        }
        if (this.myPreview.hasOverlay()) {
            e.getPresentation().setIcon(StudioIcons.LayoutInspector.CLEAR_OVERLAY);
            e.getPresentation().setText("Clear Overlay");
        } else {
            e.getPresentation().setIcon(StudioIcons.LayoutInspector.LOAD_OVERLAY);
            e.getPresentation().setText(ACTION_ID);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (this.myPreview.hasOverlay()) {
            this.myPreview.setOverLay(null, null);
        } else {
            UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.LAYOUT_INSPECTOR_EVENT).setLayoutInspectorEvent(LayoutInspectorEvent.newBuilder().setType(LayoutInspectorEvent.LayoutInspectorEventType.OVERLAY_IMAGE)));
            this.loadOverlay(e);
        }
    }

    private final void loadOverlay(AnActionEvent e) {
        boolean bl;
        FileTypeDescriptor descriptor2 = new FileTypeDescriptor("Choose Overlay", new String[]{"svg", "png", "jpg"});
        FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser((FileChooserDescriptor)descriptor2, null, null);
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Object object = e.getProject();
        if (object == null || (object = object.getBasePath()) == null) {
            object = "/";
        }
        VirtualFile toSelect = localFileSystem.refreshAndFindFileByPath((String)object);
        VirtualFile[] virtualFileArray = new VirtualFile[1];
        VirtualFile virtualFile = toSelect;
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        virtualFileArray[0] = virtualFile;
        VirtualFile[] files2 = fileChooserDialog.choose(null, virtualFileArray);
        VirtualFile[] virtualFileArray2 = files2;
        if (virtualFileArray2.length == 0) {
            return;
        }
        boolean bl2 = bl = files2.length == 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.myPreview.setOverLay(this.loadImageFile(files2[0]), files2[0].getName());
    }

    private final Image loadImageFile(VirtualFile file) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(file.getInputStream());
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)("Failed to read image from \"" + file.getName() + "\" Error: " + e.getMessage()), (String)"Error");
            LOG.warn((Throwable)e);
            return null;
        }
        return bufferedImage;
    }

    public LoadOverlayAction(@NotNull ViewNodeActiveDisplay myPreview) {
        super(ACTION_ID, "Overlay Image", StudioIcons.LayoutInspector.LOAD_OVERLAY);
        this.myPreview = myPreview;
    }

    static {
        Companion = new Companion(null);
        ACTION_ID = ACTION_ID;
        LOG = Logger.getInstance(LoadOverlayAction.class);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/editors/layoutInspector/actions/LoadOverlayAction$Companion;", "", "()V", "ACTION_ID", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "android-layout-inspector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

