/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.ui;

import com.android.tools.idea.editors.layoutInspector.LayoutInspectorContext;
import com.android.tools.idea.editors.layoutInspector.actions.LoadOverlayAction;
import com.android.tools.idea.editors.layoutInspector.actions.SetOverlayAlphaAction;
import com.android.tools.idea.editors.layoutInspector.ui.ViewNodeActiveDisplay;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Anchor;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.intellij.images.editor.ImageZoomModel;
import org.intellij.images.editor.actions.ActualSizeAction;
import org.intellij.images.editor.actions.ToggleGridAction;
import org.intellij.images.editor.actions.ZoomInAction;
import org.intellij.images.editor.actions.ZoomOutAction;
import org.intellij.images.options.EditorOptions;
import org.intellij.images.options.Options;
import org.intellij.images.options.OptionsManager;
import org.intellij.images.options.ZoomOptions;
import org.intellij.images.ui.ImageComponentDecorator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutInspectorPanel
extends JPanel
implements DataProvider,
ImageComponentDecorator {
    private final Class[] SUPPORTED_IMAGE_ACTIONS = new Class[]{ToggleGridAction.class, ZoomInAction.class, ZoomOutAction.class, ActualSizeAction.class};
    @NotNull
    private final JScrollPane myScrollPane;
    @NotNull
    private ViewNodeActiveDisplay myPreview;
    @NotNull
    private final ImageZoomModel myZoomModel = new ViewNodeZoomModel();
    @NotNull
    private final ImageWheelAdapter myWheelAdapter = new ImageWheelAdapter();

    public LayoutInspectorPanel(@NotNull LayoutInspectorContext context) {
        super(new BorderLayout());
        this.setOpaque(true);
        this.myPreview = new ViewNodeActiveDisplay(context.getRoot(), context.getBufferedImage());
        this.myPreview.addViewNodeActiveDisplayListener(context);
        this.add((Component)this.getActionPanel(), "North");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.myPreview, "Center");
        this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)panel2);
        this.myScrollPane.setVerticalScrollBarPolicy(20);
        this.myScrollPane.setHorizontalScrollBarPolicy(30);
        this.myScrollPane.addMouseWheelListener(this.myWheelAdapter);
        this.add((Component)this.myScrollPane, "Center");
        context.setPreview(this.myPreview);
    }

    @NotNull
    private JPanel getActionPanel() {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup liActionGroup = this.getInspectorActionGroup();
        ActionToolbar liActionToolbar = actionManager.createActionToolbar("LiActionsToolbar", (ActionGroup)liActionGroup, true);
        liActionToolbar.updateActionsImmediately();
        liActionToolbar.setTargetComponent((JComponent)this);
        JComponent actionToolbarPanel = liActionToolbar.getComponent();
        actionToolbarPanel.setName("LiActionsToolbar");
        ActionGroup actionGroup = this.getZoomActionGroup(actionManager);
        ActionToolbar actionToolbar = actionManager.createActionToolbar("Images.Editor", actionGroup, true);
        actionToolbar.updateActionsImmediately();
        actionToolbar.setTargetComponent((JComponent)this);
        JComponent toolbarPanel = actionToolbar.getComponent();
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(IdeBorderFactory.createBorder((int)8));
        if (((Boolean)StudioFlags.LAYOUT_INSPECTOR_LOAD_OVERLAY_ENABLED.get()).booleanValue()) {
            topPanel.add((Component)actionToolbarPanel, "West");
        }
        topPanel.add((Component)toolbarPanel, "East");
        return topPanel;
    }

    private DefaultActionGroup getInspectorActionGroup() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new LoadOverlayAction(this.myPreview), Constraints.FIRST);
        actionGroup.add((AnAction)new SetOverlayAlphaAction(this.myPreview), new Constraints(Anchor.AFTER, "Load Overlay"));
        return actionGroup;
    }

    private ActionGroup getZoomActionGroup(ActionManager actionManager) {
        DefaultActionGroup intellijActionGroup = (DefaultActionGroup)actionManager.getAction("Images.EditorToolbar");
        DefaultActionGroup zoomActionGroup = new DefaultActionGroup();
        for (AnAction child : intellijActionGroup.getChildActionsOrStubs()) {
            if (child instanceof ActionStub) {
                for (Class cls : this.SUPPORTED_IMAGE_ACTIONS) {
                    if (!Objects.equals(((ActionStub)child).getClassName(), cls.getName())) continue;
                    zoomActionGroup.add(child);
                }
                continue;
            }
            for (Class cls : this.SUPPORTED_IMAGE_ACTIONS) {
                if (!child.getClass().equals(cls)) continue;
                zoomActionGroup.add(child);
            }
        }
        return zoomActionGroup;
    }

    public void setTransparencyChessboardVisible(boolean visible) {
    }

    public boolean isTransparencyChessboardVisible() {
        return false;
    }

    public boolean isEnabledForActionPlace(String place) {
        return false;
    }

    public void setGridVisible(boolean visible) {
        this.myPreview.setGridVisible(visible);
    }

    public boolean isGridVisible() {
        return this.myPreview.isGridVisible();
    }

    public boolean isFileSizeVisible() {
        return false;
    }

    public boolean isFileNameVisible() {
        return false;
    }

    @NotNull
    public ImageZoomModel getZoomModel() {
        return this.myZoomModel;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (ImageComponentDecorator.DATA_KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    @NotNull
    ViewNodeActiveDisplay getPreview() {
        return this.myPreview;
    }

    private final class ImageWheelAdapter
    implements MouseWheelListener {
        private ImageWheelAdapter() {
        }

        @Override
        public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
            Options options = OptionsManager.getInstance().getOptions();
            EditorOptions editorOptions = options.getEditorOptions();
            ZoomOptions zoomOptions = editorOptions.getZoomOptions();
            if (zoomOptions.isWheelZooming() && e.isControlDown()) {
                int rotation = e.getWheelRotation();
                if (rotation < 0 && LayoutInspectorPanel.this.myZoomModel.canZoomIn()) {
                    LayoutInspectorPanel.this.myZoomModel.zoomIn();
                } else if (rotation > 0 && LayoutInspectorPanel.this.myZoomModel.canZoomOut()) {
                    LayoutInspectorPanel.this.myZoomModel.zoomOut();
                }
                e.consume();
            }
        }
    }

    private class ViewNodeZoomModel
    implements ImageZoomModel {
        private static final double DELTA = 1.3;
        private boolean myZoomLevelChanged = false;

        private ViewNodeZoomModel() {
        }

        public double getZoomFactor() {
            return LayoutInspectorPanel.this.myPreview.getZoomFactor();
        }

        public void setZoomFactor(double zoomFactor) {
            LayoutInspectorPanel.this.myPreview.setZoomFactor((float)zoomFactor);
            this.myZoomLevelChanged = false;
        }

        public void fitZoomToWindow() {
        }

        public void zoomOut() {
            this.setZoomFactor(this.getZoomFactor() / 1.3);
            this.myZoomLevelChanged = true;
        }

        public void zoomIn() {
            this.setZoomFactor(this.getZoomFactor() * 1.3);
            this.myZoomLevelChanged = true;
        }

        public void setZoomLevelChanged(boolean value2) {
        }

        public boolean canZoomOut() {
            return LayoutInspectorPanel.this.myScrollPane.getHorizontalScrollBar().isVisible() || LayoutInspectorPanel.this.myScrollPane.getVerticalScrollBar().isVisible();
        }

        public boolean canZoomIn() {
            return this.getZoomFactor() < ImageZoomModel.MACRO_ZOOM_LIMIT;
        }

        public boolean isZoomLevelChanged() {
            return this.myZoomLevelChanged;
        }
    }
}

