/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.tools.idea.editors.manifest.ManifestPanel;
import com.android.tools.idea.gradle.variant.view.BuildVariantUpdater;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import java.awt.BorderLayout;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestEditor
extends UserDataHolderBase
implements FileEditor {
    private final AndroidFacet myFacet;
    private JPanel myLazyContainer;
    private ManifestPanel myManifestPanel;
    private final VirtualFile mySelectedFile;
    private boolean mySelected;
    private final PsiTreeChangeListener myPsiChangeListener = new PsiTreeChangeAdapter(){

        public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            ManifestEditor.this.psiChange(event);
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            ManifestEditor.this.psiChange(event);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            ManifestEditor.this.psiChange(event);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            ManifestEditor.this.psiChange(event);
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            ManifestEditor.this.psiChange(event);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            ManifestEditor.this.psiChange(event);
        }
    };
    private final BuildVariantView.BuildVariantSelectionChangeListener buildVariantListener = this::reload;

    ManifestEditor(@NotNull AndroidFacet facet, @NotNull VirtualFile manifestFile) {
        this.myFacet = facet;
        this.mySelectedFile = manifestFile;
        this.myLazyContainer = new JPanel(new BorderLayout());
    }

    private void psiChange(PsiTreeChangeEvent event) {
        PsiFile file = event.getFile();
        if (file != null && "AndroidManifest.xml".equals(file.getName())) {
            ApplicationManager.getApplication().invokeLater(this::reload);
        }
    }

    private void reload() {
        if (this.mySelected) {
            this.myManifestPanel.setManifestSnapshot(MergedManifestManager.getSnapshot(this.myFacet), this.mySelectedFile);
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this.myLazyContainer;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        return "Merged Manifest";
    }

    public void setState(@NotNull FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        this.mySelected = true;
        Project project = this.myFacet.getModule().getProject();
        if (this.myManifestPanel == null) {
            this.myManifestPanel = new ManifestPanel(this.myFacet);
            this.myLazyContainer.add(this.myManifestPanel);
            project.getMessageBus().connect((Disposable)this).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, result2 -> {
                if (result2 == ProjectSystemSyncManager.SyncResult.FAILURE || result2 == ProjectSystemSyncManager.SyncResult.SUCCESS) {
                    this.reload();
                }
            });
        }
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener(this.myPsiChangeListener);
        BuildVariantUpdater.getInstance(project).addSelectionChangeListener(this.buildVariantListener);
        this.reload();
    }

    public void deselectNotify() {
        this.mySelected = false;
        Project thisProject = this.myFacet.getModule().getProject();
        PsiManager.getInstance((Project)thisProject).removePsiTreeChangeListener(this.myPsiChangeListener);
        BuildVariantUpdater.getInstance(thisProject).removeSelectionChangeListener(this.buildVariantListener);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }
}

