/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.tools.idea.editors.strings.LocaleList;
import com.android.tools.idea.editors.strings.StringPsiUtils;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.rendering.Locale;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import icons.StudioIcons;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JList;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;

final class AddLocaleAction
extends AnAction {
    private final StringResourceViewPanel myPanel;

    AddLocaleAction(@NotNull StringResourceViewPanel panel2) {
        super("Add Locale", null, StudioIcons.LayoutEditor.Toolbar.ADD_LOCALE);
        this.myPanel = panel2;
    }

    public void update(@NotNull AnActionEvent event) {
        long count = this.myPanel.getTable().getModel().getKeys().stream().filter(key -> key.getDirectory() != null).count();
        event.getPresentation().setEnabled(count != 0L);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        StringResourceData data = this.myPanel.getTable().getData();
        assert (data != null);
        LocaleList list = new LocaleList(AddLocaleAction.getLocales(data.getLocaleSet()));
        JBPopup popup2 = JBPopupFactory.getInstance().createListPopupBuilder((JList)((Object)list)).setItemChoosenCallback(() -> this.lambda$actionPerformed$1((JList)((Object)list))).createPopup();
        popup2.showUnderneathOf(event.getInputEvent().getComponent());
    }

    @NotNull
    static Collection<Locale> getLocales(@NotNull Collection<Locale> localesToRemove) {
        return LocaleManager.getLanguageCodes((boolean)true).stream().flatMap(AddLocaleAction::getLocales).filter(locale -> !localesToRemove.contains(locale)).sorted(Locale.LANGUAGE_NAME_COMPARATOR).collect(Collectors.toList());
    }

    @NotNull
    private static Stream<Locale> getLocales(@NotNull String language) {
        Stream<Locale> regionStream = LocaleManager.getRelevantRegions((String)language).stream().map(region -> Locale.create(new LocaleQualifier(null, language, region, null)));
        return Stream.concat(Stream.of(AddLocaleAction.createLocale(language)), regionStream);
    }

    @NotNull
    private static Locale createLocale(@NotNull String language) {
        String full = language.length() == 2 ? language : "b+" + language;
        return Locale.create(new LocaleQualifier(full, language, null, null));
    }

    void createItem(@NotNull Locale locale) {
        StringResource resource;
        StringResourceKey key;
        Project project = this.myPanel.getFacet().getModule().getProject();
        XmlFile file = StringPsiUtils.getStringResourceFile(project, key = (resource = this.findResource()).getKey(), locale);
        if (file == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            StringPsiUtils.addString(file, key, resource.getDefaultValueAsString());
            this.myPanel.reloadData();
        });
    }

    @NotNull
    private StringResource findResource() {
        StringResourceKey key;
        StringResourceData data = this.myPanel.getTable().getData();
        assert (data != null);
        List<VirtualFile> folders = ResourceFolderManager.getInstance(this.myPanel.getFacet()).getFolders();
        if (!folders.isEmpty() && data.containsKey(key = new StringResourceKey("app_name", folders.get(0)))) {
            return data.getStringResource(key);
        }
        Optional<StringResource> optionalResource = data.getResources().stream().filter(resource -> resource.getKey().getDirectory() != null).findFirst();
        return optionalResource.orElseThrow(IllegalStateException::new);
    }

    private /* synthetic */ void lambda$actionPerformed$1(JList list) {
        this.createItem((Locale)list.getSelectedValue());
    }
}

