/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.resources.ResourceItem;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.table.FrozenColumnTableEvent;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.rendering.Locale;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteStringAction
extends AbstractAction {
    private final StringResourceViewPanel myPanel;

    public DeleteStringAction(@NotNull StringResourceViewPanel panel2) {
        super("Delete");
        this.myPanel = panel2;
    }

    public void update(@NotNull JMenuItem delete, @NotNull FrozenColumnTableEvent event) {
        StringResourceTable table2 = this.myPanel.getTable();
        int[] rows = table2.getSelectedModelRowIndices();
        int[] cols = table2.getSelectedModelColumnIndices();
        int tableRow = event.getViewRowIndex();
        int tableColumn = event.getViewColumnIndex();
        if ((rows.length == 0 || cols.length == 0) && tableRow >= 0 && tableColumn >= 0) {
            table2.setRowSelectionInterval(tableRow, tableRow);
            table2.setColumnSelectionInterval(tableColumn, tableColumn);
            rows = table2.getSelectedModelRowIndices();
            cols = table2.getSelectedModelColumnIndices();
        }
        for (int col : cols) {
            if (col != 0 && col != 1 && col != 2) continue;
            delete.setText("Delete Key(s)");
            delete.setVisible(true);
            return;
        }
        StringResourceTableModel model2 = table2.getModel();
        for (int row : rows) {
            for (int column : cols) {
                ResourceItem item;
                Locale locale = model2.getLocale(column);
                StringResource resource = model2.getStringResourceAt(row);
                ResourceItem resourceItem = item = locale == null ? resource.getDefaultValueAsResourceItem() : resource.getTranslationAsResourceItem(locale);
                if (item == null) continue;
                delete.setText("Delete String(s)");
                delete.setVisible(true);
                return;
            }
        }
        delete.setVisible(false);
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent event) {
        int[] cols;
        StringResourceTable table2 = this.myPanel.getTable();
        for (int col : cols = table2.getSelectedModelColumnIndices()) {
            if (col != 0 && col != 1 && col != 2) continue;
            this.myPanel.removeSelectedKeys();
            return;
        }
        int[] rows = table2.getSelectedModelRowIndices();
        if (rows.length == 1 && cols.length == 1) {
            table2.getModel().setValueAt("", rows[0], cols[0]);
        } else {
            WriteCommandAction.runWriteCommandAction((Project)this.myPanel.getFacet().getModule().getProject(), (String)"Delete multiple strings", null, () -> {
                for (int row : rows) {
                    for (int col : cols) {
                        table2.getModel().setValueAt("", row, col);
                    }
                }
            }, (PsiFile[])new PsiFile[0]);
        }
    }
}

