/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.table.NeedsTranslationForLocaleRowFilter;
import com.android.tools.idea.editors.strings.table.NeedsTranslationsRowFilter;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringResourceTableRowFilter;
import com.android.tools.idea.editors.strings.table.TextRowFilter;
import com.android.tools.idea.editors.strings.table.TranslatableRowFilter;
import com.android.tools.idea.rendering.Locale;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.ui.DialogBuilder;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FilterKeysAction
extends ComboBoxAction {
    private final StringResourceTable myTable;

    FilterKeysAction(@NotNull StringResourceTable table2) {
        this.myTable = table2;
    }

    public void update(@NotNull AnActionEvent event) {
        StringResourceTableRowFilter filter2 = this.myTable.getRowFilter();
        if (filter2 == null) {
            Presentation presentation = event.getPresentation();
            presentation.setIcon(null);
            presentation.setText("Show All Keys");
        } else {
            filter2.update(event.getPresentation());
        }
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@Nullable JComponent button2) {
        DefaultActionGroup group = new DefaultActionGroup(null, true);
        group.add(new AnAction("Show All Keys"){

            public void actionPerformed(@NotNull AnActionEvent event) {
                FilterKeysAction.this.myTable.setRowFilter(null);
            }
        });
        group.add(new AnAction("Show Translatable Keys"){

            public void actionPerformed(@NotNull AnActionEvent event) {
                FilterKeysAction.this.myTable.setRowFilter(new TranslatableRowFilter());
            }
        });
        group.add(new AnAction("Show Keys Needing Translations"){

            public void actionPerformed(@NotNull AnActionEvent event) {
                FilterKeysAction.this.myTable.setRowFilter(new NeedsTranslationsRowFilter());
            }
        });
        group.add(new AnAction("Filter by Text", "Filter the translations editor table keys by text", AllIcons.General.Filter){

            public void actionPerformed(@NotNull AnActionEvent e) {
                String filterString;
                JTextField textField2 = new JTextField();
                DialogBuilder builder = new DialogBuilder();
                builder.setTitle("Filter by Text");
                builder.setCenterPanel((JComponent)textField2);
                builder.setPreferredFocusComponent((JComponent)textField2);
                if (builder.showAndGet() && !(filterString = textField2.getText()).isEmpty()) {
                    FilterKeysAction.this.myTable.setRowFilter(new TextRowFilter(filterString));
                }
            }
        });
        StringResourceTableModel model2 = this.myTable.getModel();
        IntStream.range(4, model2.getColumnCount()).mapToObj(model2::getLocale).map(this::newShowKeysNeedingTranslationForLocaleAction).forEach(arg_0 -> ((DefaultActionGroup)group).add(arg_0));
        return group;
    }

    @NotNull
    private AnAction newShowKeysNeedingTranslationForLocaleAction(final @NotNull Locale locale) {
        String text = "Show Keys Needing a Translation for " + LocaleMenuAction.getLocaleLabel(locale, false);
        return new AnAction(text, null, locale.getFlagImage()){

            public void actionPerformed(@NotNull AnActionEvent event) {
                FilterKeysAction.this.myTable.setRowFilter(new NeedsTranslationForLocaleRowFilter(locale));
            }
        };
    }
}

