/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.VirtualFiles;
import com.android.tools.idea.res.IdeResourceNameValidator;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewStringKeyDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JComboBox<VirtualFile> myResourceFolderComboBox;
    private EditorTextField myKeyField;
    private EditorTextField myDefaultValueField;
    private final AndroidFacet myFacet;
    private final InputValidatorEx myResourceNameValidator;
    private final Collection<StringResourceKey> myKeys;
    private String myKey;
    private String myDefaultValue;
    private VirtualFile myResFolder;

    NewStringKeyDialog(@NotNull AndroidFacet facet, @NotNull Collection<StringResourceKey> keys) {
        super(facet.getModule().getProject(), false);
        this.myFacet = facet;
        this.$$$setupUI$$$();
        this.myResourceNameValidator = IdeResourceNameValidator.forResourceName(ResourceType.STRING);
        this.myKeys = keys;
        this.init();
        this.setTitle("Add Key");
        this.setButtonName(this.getOKAction(), "okButton");
        this.setButtonName(this.getCancelAction(), "cancelButton");
    }

    private void setButtonName(@NotNull Action action2, @NotNull String name) {
        JButton button2 = this.getButton(action2);
        assert (button2 != null);
        button2.setName(name);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private void createUIComponents() {
        this.myResourceFolderComboBox = new ComboBox((Object[])ResourceFolderManager.getInstance(this.myFacet).getFolders().toArray(VirtualFile.EMPTY_ARRAY));
        this.myResourceFolderComboBox.setName("resourceFolderComboBox");
        this.myResourceFolderComboBox.setRenderer((ListCellRenderer<VirtualFile>)new ListCellRendererWrapper<VirtualFile>(){

            public void customize(@NotNull JList list, @NotNull VirtualFile folder, int index, boolean selected, boolean focused) {
                this.setText(VirtualFiles.toString(folder, NewStringKeyDialog.this.myFacet.getModule().getProject()));
            }
        });
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myKeyField;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myKeyField.getText().isEmpty()) {
            return new ValidationInfo("Key cannot be empty", (JComponent)this.myKeyField);
        }
        String key = this.myKeyField.getText().trim();
        String error = this.myResourceNameValidator.getErrorText(key);
        if (error != null) {
            return new ValidationInfo(error, (JComponent)this.myKeyField);
        }
        if (this.myDefaultValueField.getText().isEmpty()) {
            return new ValidationInfo("Default Value cannot be empty", (JComponent)this.myDefaultValueField);
        }
        VirtualFile folder = (VirtualFile)this.myResourceFolderComboBox.getSelectedItem();
        if (this.myKeys.contains(new StringResourceKey(key, folder))) {
            assert (folder != null);
            return new ValidationInfo(key + " already exists in " + VirtualFiles.toString(folder, this.myFacet.getModule().getProject()));
        }
        return null;
    }

    protected void doOKAction() {
        this.myKey = this.myKeyField.getText().trim();
        this.myDefaultValue = this.myDefaultValueField.getText().trim();
        this.myResFolder = (VirtualFile)this.myResourceFolderComboBox.getSelectedItem();
        super.doOKAction();
    }

    @NotNull
    StringResourceKey getKey() {
        return new StringResourceKey(this.myKey, this.myResFolder);
    }

    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        EditorTextField editorTextField;
        EditorTextField editorTextField2;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Key:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Default Value:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Resource Folder:");
        jBLabel3.setDisplayedMnemonic('F');
        jBLabel3.setDisplayedMnemonicIndex(9);
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        JComboBox<VirtualFile> jComboBox = this.myResourceFolderComboBox;
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, new Dimension(250, -1), null, null));
        this.myKeyField = editorTextField2 = new EditorTextField();
        editorTextField2.setName("keyTextField");
        jPanel.add((Component)editorTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myDefaultValueField = editorTextField = new EditorTextField();
        editorTextField.setName("defaultValueTextField");
        jPanel.add((Component)editorTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        jBLabel3.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

