/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.StringResourceRepository;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

final class ResourceLoadingTask
extends Task.Backgroundable {
    private final StringResourceViewPanel myPanel;
    private final Supplier<LocalResourceRepository> myRepositorySupplier;
    private LocalResourceRepository myRepository;

    ResourceLoadingTask(@NotNull StringResourceViewPanel panel2) {
        this(panel2, () -> ResourceRepositoryManager.getModuleResources(panel2.getFacet()));
    }

    ResourceLoadingTask(@NotNull StringResourceViewPanel panel2, @NotNull Supplier<LocalResourceRepository> repositorySupplier) {
        super(panel2.getFacet().getModule().getProject(), "Loading String Resources...");
        this.myPanel = panel2;
        this.myRepositorySupplier = repositorySupplier;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        indicator.setIndeterminate(true);
        this.myRepository = this.myRepositorySupplier.get();
    }

    public void onSuccess() {
        this.myPanel.getTable().setModel(new StringResourceTableModel(StringResourceRepository.create(this.myRepository), this.myPanel.getFacet()));
        this.myPanel.getLoadingPanel().stopLoading();
    }

    public void onCancel() {
        this.myPanel.getLoadingPanel().stopLoading();
    }
}

