/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.editors.strings.SelectedEditorFeature;
import com.android.tools.idea.editors.strings.StringPreview;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.StringsVirtualFile;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceEditor
extends UserDataHolderBase
implements FileEditor {
    public static final Icon ICON = StudioIcons.LayoutEditor.Toolbar.LANGUAGE;
    public static final String NAME = "String Resource Editor";
    private static final String TOOL_WINDOW_ID = "StringPreview";
    private StringResourceViewPanel myPanel;
    private final PreviewFeature myPreviewFeature;

    StringResourceEditor(@NotNull StringsVirtualFile file) {
        AndroidFacet facet = file.getFacet();
        UIUtil.invokeAndWaitIfNeeded(() -> {
            this.myPanel = new StringResourceViewPanel(facet, (Disposable)this);
            return this.myPanel;
        });
        this.myPreviewFeature = new PreviewFeature((FileEditor)this, facet.getModule());
        this.myPanel.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent event) {
                Document document = event.getDocument();
                try {
                    StringResourceEditor.this.myPreviewFeature.setText(document.getText(0, document.getLength()));
                }
                catch (BadLocationException exception) {
                    StringResourceEditor.this.myPreviewFeature.setText("");
                }
            }
        });
        this.myPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent event) {
                StringResourceEditor.this.myPreviewFeature.setText(((JTextComponent)event.getSource()).getText());
            }
        });
    }

    @NotNull
    public StringResourceViewPanel getPanel() {
        return this.myPanel;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel.getLoadingPanel();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        return FileEditorState.INSTANCE;
    }

    public void setState(@NotNull FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        this.myPreviewFeature.selectNotify();
    }

    public void deselectNotify() {
        this.myPreviewFeature.deselectNotify();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @NotNull
    public String toString() {
        return "StringResourceEditor " + (Object)((Object)this.myPanel.getFacet()) + " " + System.identityHashCode((Object)this);
    }

    static class PreviewFeature
    extends SelectedEditorFeature {
        private final Module myModule;
        private StringPreview myPreview;
        private String myPreviewString;

        public PreviewFeature(@NotNull FileEditor editor2, @NotNull Module module) {
            super(editor2, module.getProject());
            this.myModule = module;
        }

        @Override
        public boolean isReady() {
            return !DumbService.getInstance((Project)this.myModule.getProject()).isDumb() && !AndroidProjectInfo.getInstance(this.myModule.getProject()).requiredAndroidModelMissing() && ToolWindowManager.getInstance((Project)this.myModule.getProject()).getToolWindow(StringResourceEditor.TOOL_WINDOW_ID) == null;
        }

        @Override
        public void open() {
            this.myPreview = new StringPreview(this.myModule);
            if (this.myPreviewString != null) {
                this.myPreview.setText(this.myPreviewString);
            }
            Project project = this.myModule.getProject();
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
            ToolWindow toolWindow = manager.registerToolWindow(StringResourceEditor.TOOL_WINDOW_ID, false, ToolWindowAnchor.RIGHT, (Disposable)project, true);
            toolWindow.setIcon(StudioIcons.Shell.ToolWindows.ANDROID_PREVIEW);
            toolWindow.setStripeTitle("Preview");
            toolWindow.getContentManager().addContent(ContentFactory.SERVICE.getInstance().createContent(this.myPreview.getComponent(), "", false));
        }

        @Override
        public void close() {
            ToolWindowManager.getInstance((Project)this.myModule.getProject()).unregisterToolWindow(StringResourceEditor.TOOL_WINDOW_ID);
            this.myPreview = null;
        }

        public void setText(@NotNull String text) {
            this.myPreviewString = text;
            if (this.myPreview != null) {
                this.myPreview.setText(text);
            }
        }
    }
}

